/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.events.TradeEditEvent;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSetItemPrice2 {
    private UUID traderID;
    private int tradeIndex;
    private MoneyUtil.CoinValue newPrice;
    private boolean isFree;
    private String customName;
    private String newDirection;

    public MessageSetItemPrice2(UUID traderID, int tradeIndex, MoneyUtil.CoinValue newPrice, boolean isFree, String customName, String newDirection) {
        this.traderID = traderID;
        this.tradeIndex = tradeIndex;
        this.newPrice = newPrice;
        this.isFree = isFree;
        this.customName = customName;
        this.newDirection = newDirection;
    }

    public static void encode(MessageSetItemPrice2 message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.traderID);
        buffer.writeInt(message.tradeIndex);
        buffer.m_130079_(message.newPrice.writeToNBT(new CompoundTag(), "CoinValue"));
        buffer.writeBoolean(message.isFree);
        buffer.m_130070_(message.customName);
        buffer.m_130070_(message.newDirection);
    }

    public static MessageSetItemPrice2 decode(FriendlyByteBuf buffer) {
        return new MessageSetItemPrice2(buffer.m_130259_(), buffer.readInt(), new MoneyUtil.CoinValue(buffer.m_130260_()), buffer.readBoolean(), buffer.m_130136_(30), buffer.m_130136_(ItemTradeData.MaxTradeTypeStringLength()));
    }

    public static void handle(MessageSetItemPrice2 message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData data1 = TradingOffice.getData(message.traderID);
            if (data1 != null && data1 instanceof UniversalItemTraderData) {
                UniversalItemTraderData data2 = (UniversalItemTraderData)data1;
                MoneyUtil.CoinValue oldPrice = data2.getTrade(message.tradeIndex).getCost();
                boolean wasFree = data2.getTrade(message.tradeIndex).isFree();
                data2.getTrade(message.tradeIndex).setCost(message.newPrice);
                data2.getTrade(message.tradeIndex).setFree(message.isFree);
                data2.getTrade(message.tradeIndex).setCustomName(message.customName);
                data2.getTrade(message.tradeIndex).setTradeType(ItemTradeData.loadTradeType(message.newDirection));
                if (oldPrice.getRawValue() != message.newPrice.getRawValue() || wasFree != message.isFree) {
                    TradeEditEvent.TradePriceEditEvent e = new TradeEditEvent.TradePriceEditEvent((Supplier<ITrader>)((Supplier)() -> {
                        UniversalTraderData d = TradingOffice.getData(message.traderID);
                        if (d instanceof UniversalItemTraderData) {
                            return (UniversalItemTraderData)d;
                        }
                        return null;
                    }), message.tradeIndex, oldPrice, wasFree);
                    MinecraftForge.EVENT_BUS.post((Event)e);
                }
                TradingOffice.MarkDirty(message.traderID);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

