/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.universal_trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.events.ItemTradeEditEvent;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fmllegacy.network.NetworkEvent;

public class MessageSetTradeItem2 {
    private UUID traderID;
    private int tradeIndex;
    ItemStack newItem;
    int slot;

    public MessageSetTradeItem2(UUID traderID, int tradeIndex, ItemStack newItem, int slot) {
        this.traderID = traderID;
        this.tradeIndex = tradeIndex;
        this.newItem = newItem;
        this.slot = slot;
    }

    public static void encode(MessageSetTradeItem2 message, FriendlyByteBuf buffer) {
        buffer.m_130077_(message.traderID);
        buffer.writeInt(message.tradeIndex);
        buffer.writeItemStack(message.newItem, false);
        buffer.writeInt(message.slot);
    }

    public static MessageSetTradeItem2 decode(FriendlyByteBuf buffer) {
        return new MessageSetTradeItem2(buffer.m_130259_(), buffer.readInt(), buffer.m_130267_(), buffer.readInt());
    }

    public static void handle(MessageSetTradeItem2 message, java.util.function.Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            UniversalTraderData data1 = TradingOffice.getData(message.traderID);
            if (data1 != null && data1 instanceof UniversalItemTraderData) {
                UniversalItemTraderData data2 = (UniversalItemTraderData)data1;
                ItemStack oldItem = ItemStack.f_41583_;
                ItemTradeData trade = data2.getTrade(message.tradeIndex);
                if (message.slot == 1) {
                    oldItem = trade.getBarterItem();
                    trade.setBarterItem(message.newItem);
                } else {
                    oldItem = trade.getSellItem();
                    trade.setSellItem(message.newItem);
                }
                ItemTradeEditEvent.ItemTradeItemEditEvent e = new ItemTradeEditEvent.ItemTradeItemEditEvent((Supplier<ITrader>)((Supplier)() -> {
                    UniversalTraderData d = TradingOffice.getData(message.traderID);
                    if (d instanceof UniversalItemTraderData) {
                        return (UniversalItemTraderData)d;
                    }
                    return null;
                }), message.tradeIndex, oldItem, message.slot);
                MinecraftForge.EVENT_BUS.post((Event)e);
                TradingOffice.MarkDirty(message.traderID);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

