/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;

public interface IItemTrader
extends ITrader {
    public ItemTradeData getTrade(int var1);

    public List<ItemTradeData> getAllTrades();

    public Container getStorage();

    public void markTradesDirty();

    public void markStorageDirty();

    public void openTradeMenu(Player var1);

    public void openStorageMenu(Player var1);

    public void openItemEditMenu(Player var1, int var2);

    default public TradeEvent.PreTradeEvent runPreTradeEvent(Player player, int tradeIndex) {
        ItemTradeData trade = this.getTrade(tradeIndex);
        TradeEvent.PreTradeEvent event = new TradeEvent.PreTradeEvent(player, trade, (Supplier<ITrader>)((Supplier)() -> this));
        trade.beforeTrade(event);
        if (this instanceof ITradeRuleHandler) {
            ((ITradeRuleHandler)((Object)this)).beforeTrade(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    default public TradeEvent.TradeCostEvent runTradeCostEvent(Player player, int tradeIndex) {
        ItemTradeData trade = this.getTrade(tradeIndex);
        TradeEvent.TradeCostEvent event = new TradeEvent.TradeCostEvent(player, trade, (Supplier<ITrader>)((Supplier)() -> this));
        trade.tradeCost(event);
        if (this instanceof ITradeRuleHandler) {
            ((ITradeRuleHandler)((Object)this)).tradeCost(event);
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event;
    }

    default public void runPostTradeEvent(Player player, int tradeIndex, MoneyUtil.CoinValue pricePaid) {
        ItemTradeData trade = this.getTrade(tradeIndex);
        TradeEvent.PostTradeEvent event = new TradeEvent.PostTradeEvent(player, trade, (Supplier<ITrader>)((Supplier)() -> this), pricePaid);
        trade.afterTrade(event);
        if (event.isDirty()) {
            this.markTradesDirty();
            event.clean();
        }
        if (this instanceof ITradeRuleHandler) {
            ((ITradeRuleHandler)((Object)this)).afterTrade(event);
            if (event.isDirty()) {
                ((ITradeRuleHandler)((Object)this)).markRulesDirty();
                event.clean();
            }
        }
        MinecraftForge.EVENT_BUS.post((Event)event);
    }
}

