/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MoneyUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.CompoundTag;

public abstract class TradeData
implements ITradeRuleHandler {
    public static final String DEFAULT_KEY = "Trades";
    protected MoneyUtil.CoinValue cost = new MoneyUtil.CoinValue(new MoneyUtil.CoinValue.CoinValuePair[0]);
    protected boolean isFree = false;
    List<TradeRule> rules = new ArrayList<TradeRule>();

    public abstract TradeDirection getTradeDirection();

    public boolean isFree() {
        return this.isFree && this.cost.getRawValue() <= 0L;
    }

    public void setFree(boolean isFree) {
        this.isFree = isFree;
    }

    public final boolean validCost() {
        return this.isFree || this.cost.getRawValue() > 0L;
    }

    public boolean isValid() {
        return this.validCost();
    }

    public MoneyUtil.CoinValue getCost() {
        return this.cost;
    }

    public void setCost(MoneyUtil.CoinValue value) {
        this.cost = value;
    }

    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = new CompoundTag();
        this.cost.writeToNBT(tradeNBT, "Price");
        tradeNBT.m_128379_("IsFree", this.isFree);
        TradeRule.writeRules(tradeNBT, this.rules);
        return tradeNBT;
    }

    protected void loadFromNBT(CompoundTag nbt) {
        if (nbt.m_128425_("Price", 3)) {
            this.cost.readFromOldValue(nbt.m_128451_("Price"));
        } else if (nbt.m_128425_("Price", 9)) {
            this.cost.readFromNBT(nbt, "Price");
        }
        this.isFree = nbt.m_128441_("IsFree") ? nbt.m_128471_("IsFree") : false;
        this.rules.clear();
        this.rules = TradeRule.readRules(nbt);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.rules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.rules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.rules.forEach(rule -> rule.afterTrade(event));
    }

    @Override
    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.rules.size(); ++i) {
            if (newRule.type != this.rules.get((int)i).type) continue;
            return;
        }
        this.rules.add(newRule);
    }

    @Override
    public List<TradeRule> getRules() {
        return this.rules;
    }

    @Override
    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    @Override
    public void removeRule(TradeRule rule) {
        if (this.rules.contains(rule)) {
            this.rules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.rules.clear();
    }

    @Override
    public void markRulesDirty() {
    }

    public static enum TradeDirection {
        SALE,
        PURCHASE,
        NONE;

    }
}

