/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.TicketKioskRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryBuilder;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ItemTradeRestriction
extends ForgeRegistryEntry<ItemTradeRestriction> {
    static IForgeRegistry<ItemTradeRestriction> ITEM_TRADE_RESTRICTIONS;
    private static final List<ItemTradeRestriction> RESTRICTIONS;
    public static final ItemTradeRestriction NONE;
    public static final ItemTradeRestriction ARMOR_HEAD;
    public static final ItemTradeRestriction ARMOR_CHEST;
    public static final ItemTradeRestriction ARMOR_LEGS;
    public static final ItemTradeRestriction ARMOR_FEET;
    public static final ItemTradeRestriction TICKET_KIOSK;
    private final String classicType;

    public ItemTradeRestriction() {
        this.classicType = "";
    }

    public ItemTradeRestriction(String classicType) {
        this.classicType = classicType;
    }

    public ItemStack modifySellItem(ItemStack sellItem, ItemTradeData trade) {
        return sellItem;
    }

    public boolean allowSellItem(ItemStack itemStack) {
        return true;
    }

    public ItemStack filterSellItem(ItemStack itemStack) {
        return itemStack;
    }

    public int getSaleStock(ItemStack sellItem, Container traderStorage) {
        return InventoryUtil.GetItemCount(traderStorage, sellItem) / sellItem.m_41613_();
    }

    public void removeItemsFromStorage(ItemStack sellItem, Container traderStorage) {
        InventoryUtil.RemoveItemCount(traderStorage, sellItem);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return null;
    }

    private static ItemTradeRestriction register(String key, ItemTradeRestriction restriction) {
        restriction.setRegistryName(key);
        RESTRICTIONS.add(restriction);
        return restriction;
    }

    @SubscribeEvent
    public static void createRegistry(RegistryEvent.NewRegistry event) {
        RegistryBuilder builder = new RegistryBuilder();
        builder.setType(ItemTradeRestriction.class);
        ResourceLocation key = new ResourceLocation("lightmanscurrency", "item_trade_restrictions");
        builder.setName(key);
        builder.setDefaultKey(key);
        ITEM_TRADE_RESTRICTIONS = builder.create();
    }

    @SubscribeEvent
    public static void registerRestrictions(RegistryEvent.Register<ItemTradeRestriction> event) {
        RESTRICTIONS.forEach(restriction -> event.getRegistry().register((IForgeRegistryEntry)restriction));
        RESTRICTIONS.clear();
    }

    public static ItemTradeRestriction get(String key) {
        ResourceLocation testKey = null;
        try {
            testKey = new ResourceLocation(key);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ItemTradeRestriction restriction = null;
        if (testKey != null) {
            restriction = (ItemTradeRestriction)ITEM_TRADE_RESTRICTIONS.getValue(testKey);
        }
        if (restriction == null) {
            AtomicReference temp = new AtomicReference();
            ITEM_TRADE_RESTRICTIONS.forEach(r -> {
                if (r.classicType.equals(key)) {
                    temp.set(r);
                }
            });
            if (temp.get() != null) {
                return (ItemTradeRestriction)((Object)temp.get());
            }
            return NONE;
        }
        return restriction;
    }

    static {
        RESTRICTIONS = new ArrayList<ItemTradeRestriction>();
        NONE = ItemTradeRestriction.register("none", new ItemTradeRestriction("NONE"));
        ARMOR_HEAD = ItemTradeRestriction.register("armor_head", new EquipmentRestriction(EquipmentSlot.HEAD, "ARMOR_HEAD"));
        ARMOR_CHEST = ItemTradeRestriction.register("armor_chest", new EquipmentRestriction(EquipmentSlot.CHEST, "ARMOR_CHEST"));
        ARMOR_LEGS = ItemTradeRestriction.register("armor_legs", new EquipmentRestriction(EquipmentSlot.LEGS, "ARMOR_LEGS"));
        ARMOR_FEET = ItemTradeRestriction.register("armor_feet", new EquipmentRestriction(EquipmentSlot.FEET, "ARMOR_FEET"));
        TICKET_KIOSK = ItemTradeRestriction.register("ticket_kiosk", new TicketKioskRestriction("TICKET"));
    }
}

