/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.slots.TicketSlot;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TicketKioskRestriction
extends ItemTradeRestriction {
    public TicketKioskRestriction() {
    }

    public TicketKioskRestriction(String classicType) {
        super(classicType);
    }

    @Override
    public ItemStack modifySellItem(ItemStack sellItem, ItemTradeData trade) {
        if (sellItem.m_41720_() instanceof TicketItem && trade.hasCustomName()) {
            sellItem.m_41714_((Component)new TextComponent(trade.getCustomName()));
        }
        return sellItem;
    }

    @Override
    public boolean allowSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return true;
        }
        return itemStack.m_41720_().getTags().contains(TicketItem.TICKET_MATERIAL_TAG) && itemStack.m_41720_() != ModItems.TICKET;
    }

    @Override
    public ItemStack filterSellItem(ItemStack itemStack) {
        if (TicketItem.isMasterTicket(itemStack)) {
            return TicketItem.CreateTicket(TicketItem.GetTicketID(itemStack), 1);
        }
        if (itemStack.m_41720_().getTags().contains(TicketItem.TICKET_MATERIAL_TAG) && itemStack.m_41720_() != ModItems.TICKET) {
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getSaleStock(ItemStack sellItem, Container traderStorage) {
        if (sellItem.m_41720_() == ModItems.TICKET) {
            return InventoryUtil.GetItemTagCount(traderStorage, TicketItem.TICKET_MATERIAL_TAG, ModItems.TICKET_MASTER) / sellItem.m_41613_();
        }
        return super.getSaleStock(sellItem, traderStorage);
    }

    @Override
    public void removeItemsFromStorage(ItemStack sellItem, Container traderStorage) {
        if (sellItem.m_41720_() == ModItems.TICKET) {
            if (!InventoryUtil.RemoveItemCount(traderStorage, sellItem)) {
                InventoryUtil.RemoveItemTagCount(traderStorage, TicketItem.TICKET_MATERIAL_TAG, sellItem.m_41613_(), ModItems.TICKET_MASTER);
            }
        } else {
            super.removeItemsFromStorage(sellItem, traderStorage);
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public Pair<ResourceLocation, ResourceLocation> getEmptySlotBG() {
        return Pair.of((Object)InventoryMenu.f_39692_, (Object)TicketSlot.EMPTY_TICKET_SLOT);
    }
}

