/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerBlacklist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "blacklist");
    List<String> bannedPlayerNames = new ArrayList<String>();

    public PlayerBlacklist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (this.bannedPlayerNames.contains(event.getPlayer().m_5446_().getString())) {
            event.denyTrade((Component)new TranslatableComponent("traderule.lightmanscurrency.blacklist.denial"));
        }
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (int i = 0; i < this.bannedPlayerNames.size(); ++i) {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("name", this.bannedPlayerNames.get(i));
            playerNameList.add((Object)thisCompound);
        }
        compound.m_128365_("BannedPlayersNames", (Tag)playerNameList);
        return compound;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("BannedPlayersNames", 9)) {
            this.bannedPlayerNames.clear();
            ListTag playerNameList = compound.m_128437_("BannedPlayersNames", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                if (!thisCompound.m_128425_("name", 8)) continue;
                this.bannedPlayerNames.add(thisCompound.m_128461_("name"));
            }
        }
    }

    @Override
    public int getGUIX() {
        return 32;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox nameInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        final int namesPerPage = 11;

        protected final PlayerBlacklist getBlacklistRule() {
            if (this.getRuleRaw() instanceof PlayerBlacklist) {
                return (PlayerBlacklist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            Font font = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new EditBox(font, n, n2, 176 - 20, 20, (Component)new TextComponent("")));
            this.buttonAddPlayer = this.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.blacklist.add"), this::PressBlacklistButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.addCustomRenderable(new Button(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.blacklist.remove"), this::PressForgiveButton));
        }

        @Override
        public void renderTab(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getBlacklistRule() == null) {
                return;
            }
            int n = this.screen.guiLeft();
            int n2 = this.screen.guiTop() + 55;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(matrixStack, n, n2, 0, 176, 176, 80);
            int n3 = this.screen.guiLeft();
            int n4 = this.screen.guiTop() + 55 + 80;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(matrixStack, n3, n4, 0, 176, 176, 34);
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.getBlacklistRule().bannedPlayerNames.size() && i < this.namesPerPage * 2; ++i) {
                this.screen.getFont().m_92883_(matrixStack, this.getBlacklistRule().bannedPlayerNames.get(i), (float)(this.screen.guiLeft() + 10 + 78 * x), (float)(this.screen.guiTop() + 57 + 10 * y), 0xFFFFFF);
                if (++y < this.namesPerPage) continue;
                y = 0;
                ++x;
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
        }

        void PressBlacklistButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                if (!this.getBlacklistRule().bannedPlayerNames.contains(name)) {
                    this.getBlacklistRule().bannedPlayerNames.add(name);
                    this.screen.markRulesDirty();
                }
                this.nameInput.m_94144_("");
            }
        }

        void PressForgiveButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                if (this.getBlacklistRule().bannedPlayerNames.contains(name)) {
                    this.getBlacklistRule().bannedPlayerNames.remove(name);
                    this.screen.markRulesDirty();
                }
                this.nameInput.m_94144_("");
            }
        }
    }
}

