/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.util.TextInputUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerDiscounts
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "discount_list");
    List<String> playerList = new ArrayList<String>();
    int discount = 10;

    public int getDiscountPercent() {
        return this.discount;
    }

    public void setDiscountPercent(int percent) {
        this.discount = MathUtil.clamp(percent, 0, 100);
    }

    private double getDiscountMult() {
        return 1.0 - (double)this.discount / 100.0;
    }

    private double getIncreaseMult() {
        return 1.0 + (double)this.discount / 100.0;
    }

    public PlayerDiscounts() {
        super(TYPE);
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.playerList.contains(event.getPlayer().m_5446_().getString())) {
            switch (event.getTrade().getTradeDirection()) {
                case SALE: {
                    event.applyCostMultiplier(this.getDiscountMult());
                    break;
                }
                case PURCHASE: {
                    event.applyCostMultiplier(this.getIncreaseMult());
                    break;
                }
            }
        }
    }

    @Override
    protected CompoundTag write(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (int i = 0; i < this.playerList.size(); ++i) {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("name", this.playerList.get(i));
            playerNameList.add((Object)thisCompound);
        }
        compound.m_128365_("Players", (Tag)playerNameList);
        compound.m_128405_("discount", this.discount);
        return compound;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("Players", 9)) {
            this.playerList.clear();
            ListTag playerNameList = compound.m_128437_("Players", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                if (!thisCompound.m_128425_("name", 8)) continue;
                this.playerList.add(thisCompound.m_128461_("name"));
            }
        }
        if (compound.m_128425_("discount", 3)) {
            this.discount = compound.m_128451_("discount");
        }
    }

    @Override
    public Component getButtonText() {
        return new TranslatableComponent("gui.button.lightmanscurrency.discount_list");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox nameInput;
        EditBox discountInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        Button buttonSetDiscount;
        final int namesPerPage = 9;

        protected final PlayerDiscounts getRule() {
            if (this.getRuleRaw() instanceof PlayerDiscounts) {
                return (PlayerDiscounts)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            Font font = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 34;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new EditBox(font, n, n2, 176 - 20, 20, (Component)new TextComponent("")));
            this.buttonAddPlayer = this.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 55, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.discount.add"), this::PressAddButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.addCustomRenderable(new Button(n3 + 176 - 88, this.screen.guiTop() + 55, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.discount.remove"), this::PressForgetButton));
            this.discountInput = this.addCustomRenderable(new EditBox(this.screen.getFont(), this.screen.guiLeft() + 10, this.screen.guiTop() + 9, 20, 20, (Component)new TextComponent("")));
            this.discountInput.m_94199_(2);
            this.discountInput.m_94144_(Integer.toString(this.getRule().discount));
            this.buttonSetDiscount = this.addCustomRenderable(new Button(this.screen.guiLeft() + 110, this.screen.guiTop() + 10, 50, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.discount.set"), this::PressSetDiscountButton));
        }

        @Override
        public void renderTab(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getRule() == null) {
                return;
            }
            int n = this.screen.guiLeft();
            int n2 = this.screen.guiTop() + 78;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(poseStack, n, n2, 0, 176, 176, 80);
            int n3 = this.screen.guiLeft();
            int n4 = this.screen.guiTop() + 78 + 80;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(poseStack, n3, n4, 0, 176, 176, 11);
            this.screen.getFont().m_92883_(poseStack, new TranslatableComponent("gui.lightmanscurrency.discount.tooltip").getString(), (float)(this.discountInput.f_93620_ + this.discountInput.m_5711_() + 4), (float)(this.discountInput.f_93621_ + 3), 0xFFFFFF);
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.getRule().playerList.size() && x < 2; ++i) {
                this.screen.getFont().m_92883_(poseStack, this.getRule().playerList.get(i), (float)(this.screen.guiLeft() + 10 + 78 * x), (float)(this.screen.guiTop() + 80 + 10 * y), 0xFFFFFF);
                if (++y < this.namesPerPage) continue;
                y = 0;
                ++x;
            }
        }

        @Override
        public void onScreenTick() {
            TextInputUtil.whitelistInteger(this.discountInput, 0L, 99L);
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
            this.removeCustomWidget(this.discountInput);
            this.removeCustomWidget(this.buttonSetDiscount);
        }

        void PressAddButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                if (!this.getRule().playerList.contains(name)) {
                    this.getRule().playerList.add(name);
                    this.screen.markRulesDirty();
                }
                this.nameInput.m_94144_("");
            }
        }

        void PressForgetButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                if (this.getRule().playerList.contains(name)) {
                    this.getRule().playerList.remove(name);
                    this.screen.markRulesDirty();
                }
                this.nameInput.m_94144_("");
            }
        }

        void PressSetDiscountButton(Button button) {
            int discount;
            this.getRule().discount = discount = TextInputUtil.getIntegerValue(this.discountInput, 1);
            this.screen.markRulesDirty();
        }
    }
}

