/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class PlayerWhitelist
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "whitelist");
    List<String> whitelistPlayerNames = new ArrayList<String>();

    public PlayerWhitelist() {
        super(TYPE);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        if (!this.whitelistPlayerNames.contains(event.getPlayer().m_5446_().getString())) {
            event.denyTrade((Component)new TranslatableComponent("traderule.lightmanscurrency.whitelist.denial"));
        }
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        ListTag playerNameList = new ListTag();
        for (int i = 0; i < this.whitelistPlayerNames.size(); ++i) {
            CompoundTag thisCompound = new CompoundTag();
            thisCompound.m_128359_("name", this.whitelistPlayerNames.get(i));
            playerNameList.add((Object)thisCompound);
        }
        compound.m_128365_("WhitelistedPlayersNames", (Tag)playerNameList);
        return compound;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("WhitelistedPlayersNames", 9)) {
            this.whitelistPlayerNames.clear();
            ListTag playerNameList = compound.m_128437_("WhitelistedPlayersNames", 10);
            for (int i = 0; i < playerNameList.size(); ++i) {
                CompoundTag thisCompound = playerNameList.m_128728_(i);
                if (!thisCompound.m_128425_("name", 8)) continue;
                this.whitelistPlayerNames.add(thisCompound.m_128461_("name"));
            }
        }
    }

    @Override
    public int getGUIX() {
        return 16;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        EditBox nameInput;
        Button buttonAddPlayer;
        Button buttonRemovePlayer;
        final int namesPerPage = 11;

        protected final PlayerWhitelist getWhitelistRule() {
            if (this.getRuleRaw() instanceof PlayerWhitelist) {
                return (PlayerWhitelist)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            Font font = this.screen.getFont();
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 9;
            Objects.requireNonNull(this.screen);
            this.nameInput = this.addCustomRenderable(new EditBox(font, n, n2, 176 - 20, 20, (Component)new TextComponent("")));
            this.buttonAddPlayer = this.screen.addCustomRenderable(new Button(this.screen.guiLeft() + 10, this.screen.guiTop() + 30, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.whitelist.add"), this::PressWhitelistButton));
            int n3 = this.screen.guiLeft();
            Objects.requireNonNull(this.screen);
            this.buttonRemovePlayer = this.screen.addCustomRenderable(new Button(n3 + 176 - 88, this.screen.guiTop() + 30, 78, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.whitelist.remove"), this::PressForgetButton));
        }

        @Override
        public void renderTab(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
            if (this.getWhitelistRule() == null) {
                return;
            }
            int n = this.screen.guiLeft();
            int n2 = this.screen.guiTop() + 55;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(matrixStack, n, n2, 0, 176, 176, 80);
            int n3 = this.screen.guiLeft();
            int n4 = this.screen.guiTop() + 55 + 80;
            Objects.requireNonNull(this.screen);
            Objects.requireNonNull(this.screen);
            this.screen.m_93228_(matrixStack, n3, n4, 0, 176, 176, 34);
            int x = 0;
            int y = 0;
            for (int i = 0; i < this.getWhitelistRule().whitelistPlayerNames.size() && i < this.namesPerPage * 2; ++i) {
                this.screen.getFont().m_92883_(matrixStack, this.getWhitelistRule().whitelistPlayerNames.get(i), (float)(this.screen.guiLeft() + 10 + 78 * x), (float)(this.screen.guiTop() + 57 + 10 * y), 0xFFFFFF);
                if (++y < this.namesPerPage) continue;
                y = 0;
                ++x;
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.nameInput);
            this.removeCustomWidget(this.buttonAddPlayer);
            this.removeCustomWidget(this.buttonRemovePlayer);
        }

        void PressWhitelistButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                if (!this.getWhitelistRule().whitelistPlayerNames.contains(name)) {
                    this.getWhitelistRule().whitelistPlayerNames.add(name);
                    this.screen.markRulesDirty();
                }
                this.nameInput.m_94144_("");
            }
        }

        void PressForgetButton(Button button) {
            String name = this.nameInput.m_94155_();
            if (name != "") {
                if (this.getWhitelistRule().whitelistPlayerNames.contains(name)) {
                    this.getWhitelistRule().whitelistPlayerNames.remove(name);
                    this.screen.markRulesDirty();
                }
                this.nameInput.m_94144_("");
            }
        }
    }
}

