/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.util;

import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class MoneyUtil {
    private static List<CoinData> coinList = new ArrayList<CoinData>();
    private static boolean coinListDirty = false;
    private static List<CoinData> publicCoinList = new ArrayList<CoinData>();
    private static boolean mintRecipesDirty = false;
    private static List<MintRecipe> mintRecipes = null;
    private static boolean meltRecipesDirty = false;
    private static List<MintRecipe> meltRecipes = null;
    private static boolean init = false;

    public static boolean initialized() {
        return init;
    }

    public static void init() {
        LightmansCurrency.LogInfo("Initializing the Money Utilities.");
        if (init) {
            return;
        }
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModItems.COIN_COPPER).defineInitial("item.lightmanscurrency.coin_copper.initial").defineMintingMaterial(Items.f_151052_));
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModItems.COIN_IRON).defineInitial("item.lightmanscurrency.coin_iron.initial").defineMintingMaterial(Items.f_42416_).defineConversion(ModItems.COIN_COPPER, (Integer)Config.COMMON.ironCoinWorth.get()));
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModItems.COIN_GOLD).defineInitial("item.lightmanscurrency.coin_gold.initial").defineMintingMaterial(Items.f_42417_).defineConversion(ModItems.COIN_IRON, (Integer)Config.COMMON.goldCoinWorth.get()));
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModItems.COIN_EMERALD).defineInitial("item.lightmanscurrency.coin_emerald.initial").defineMintingMaterial(Items.f_42616_).defineConversion(ModItems.COIN_GOLD, (Integer)Config.COMMON.emeraldCoinWorth.get()));
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModItems.COIN_DIAMOND).defineInitial("item.lightmanscurrency.coin_diamond.initial").defineMintingMaterial(Items.f_42415_).defineConversion(ModItems.COIN_EMERALD, (Integer)Config.COMMON.diamondCoinWorth.get()));
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModItems.COIN_NETHERITE).defineInitial("item.lightmanscurrency.coin_netherite.initial").defineMintingMaterial(Items.f_42418_).defineConversion(ModItems.COIN_DIAMOND, (Integer)Config.COMMON.netheriteCoinWorth.get()));
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINPILE_COPPER.item).defineConversion(ModItems.COIN_COPPER, (Integer)Config.COMMON.coinpileCopperWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINBLOCK_COPPER.item).defineConversion(ModBlocks.COINPILE_COPPER.item, (Integer)Config.COMMON.coinBlockCopperWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINPILE_IRON.item).defineConversion(ModItems.COIN_IRON, (Integer)Config.COMMON.coinpileIronWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINBLOCK_IRON.item).defineConversion(ModBlocks.COINPILE_IRON.item, (Integer)Config.COMMON.coinBlockIronWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINPILE_GOLD.item).defineConversion(ModItems.COIN_GOLD, (Integer)Config.COMMON.coinpileGoldWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINBLOCK_GOLD.item).defineConversion(ModBlocks.COINPILE_GOLD.item, (Integer)Config.COMMON.coinBlockGoldWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINPILE_EMERALD.item).defineConversion(ModItems.COIN_EMERALD, (Integer)Config.COMMON.coinpileEmeraldWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINBLOCK_EMERALD.item).defineConversion(ModBlocks.COINPILE_EMERALD.item, (Integer)Config.COMMON.coinBlockEmeraldWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINPILE_DIAMOND.item).defineConversion(ModItems.COIN_DIAMOND, (Integer)Config.COMMON.coinpileDiamondWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINBLOCK_DIAMOND.item).defineConversion(ModBlocks.COINPILE_DIAMOND.item, (Integer)Config.COMMON.coinBlockDiamondWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINPILE_NETHERITE.item).defineConversion(ModItems.COIN_NETHERITE, (Integer)Config.COMMON.coinpileNetheriteWorth.get()).setHidden());
        MoneyUtil.addCoinItem(CoinData.getBuilder(ModBlocks.COINBLOCK_NETHERITE.item).defineConversion(ModBlocks.COINPILE_NETHERITE.item, (Integer)Config.COMMON.coinBlockNetheriteWorth.get()).setHidden());
        init = true;
        MoneyUtil.sortCoinList();
    }

    private static void addCoinItem(CoinData.Builder newCoinDataBuilder) {
        MoneyUtil.addCoinItem(newCoinDataBuilder, false);
    }

    public static void AddCoinItem(CoinData.Builder newCoinDataBuilder) {
        MoneyUtil.addCoinItem(newCoinDataBuilder, false);
    }

    private static void addCoinItem(CoinData.Builder newCoinDataBuilder, boolean ignoreDuplicateWarning) {
        if (coinList == null) {
            coinList = new ArrayList<CoinData>();
        }
        CoinData newCoinData = newCoinDataBuilder.build();
        CoinData duplicateDependentOwner = null;
        for (CoinData coinData : coinList) {
            if (coinData.getCoinItem() == newCoinData.getCoinItem()) {
                LightmansCurrency.LogWarning("Attempted to add Duplicate Coin Item (" + newCoinData.getCoinItem().getRegistryName().toString() + ") to the master coin list.");
                return;
            }
            if (coinData.worthOtherCoin != newCoinData.worthOtherCoin || newCoinData.worthOtherCoin == null || newCoinData.isHidden || coinData.isHidden) continue;
            duplicateDependentOwner = coinData;
            if (ignoreDuplicateWarning) continue;
            LightmansCurrency.LogWarning("Attempted to add a new Coin Item '" + newCoinData.getCoinItem().getRegistryName() + "' with the same dependent (" + duplicateDependentOwner.worthOtherCoin.getRegistryName() + ") as another coin (" + coinData.coinItem.getRegistryName() + ").\nManually splicing the dependents to keep the chain clean.");
            LightmansCurrency.LogWarning("To avoid this problem, run MoneyUtil.changeCoinConversion(Item changedCoin, Item otherCoin, int otherCoinCount) before adding the new coin type.");
        }
        if (duplicateDependentOwner != null) {
            if (duplicateDependentOwner.worthOtherCoinCount > newCoinData.worthOtherCoinCount) {
                duplicateDependentOwner.worthOtherCoin = newCoinData.coinItem;
                float ratio = (float)duplicateDependentOwner.worthOtherCoinCount / (float)newCoinData.worthOtherCoinCount;
                if (ratio % 1.0f == 0.0f) {
                    duplicateDependentOwner.worthOtherCoinCount = (int)ratio;
                    if (!ignoreDuplicateWarning) {
                        LightmansCurrency.LogInfo("Duplicate dependent fits in, so changing the other coins dependency to this coin in a manner such that its total value remains the same.");
                        LightmansCurrency.LogInfo("You may safely register this coin while flagging it to ignore warnings if you're getting tired of seeing this message.");
                    }
                }
            } else {
                newCoinData.worthOtherCoin = duplicateDependentOwner.coinItem;
                float ratio = (float)newCoinData.worthOtherCoinCount / (float)duplicateDependentOwner.worthOtherCoinCount;
                if (ratio % 1.0f == 0.0f) {
                    newCoinData.worthOtherCoinCount = (int)ratio;
                    if (!ignoreDuplicateWarning) {
                        LightmansCurrency.LogInfo("Duplicate dependent fits in, so changing this coins dependency to the other coin in a manner such that its total value remains the same.");
                        LightmansCurrency.LogInfo("You may safely register this coin while flagging it to ignore warnings if you're getting tired of seeing this message.");
                    }
                }
            }
        }
        LightmansCurrency.LogDebug("Adding " + newCoinData.getCoinItem().getRegistryName());
        coinList.add(newCoinData);
        coinListDirty = coinListDirty || !newCoinData.isHidden;
        mintRecipesDirty = true;
        meltRecipesDirty = true;
    }

    public static void AddCoinItem(CoinData.Builder newCoinDataBuilder, boolean ignoreDuplicateWarning) {
        MoneyUtil.addCoinItem(newCoinDataBuilder, ignoreDuplicateWarning);
        MoneyUtil.sortCoinList();
    }

    public static void changeCoinConversion(Item changedCoin, Item otherCoin, int otherCoinCount) {
        CoinData changedData = MoneyUtil.getData(changedCoin);
        if (changedData == null) {
            if (MoneyUtil.initialized()) {
                LightmansCurrency.LogError("Cannot change the coin conversion as '" + changedCoin.getRegistryName() + "' has not been registered as a coin.");
            }
            return;
        }
        if (!changedData.isHidden) {
            for (CoinData coinData : coinList) {
                if (coinData.worthOtherCoin != otherCoin || coinData.coinItem == changedCoin || coinData.isHidden) continue;
                LightmansCurrency.LogError("Cannot change the coin's dependent to a dependent (" + otherCoin.getRegistryName() + ") that is also being used by another coin (" + coinData.coinItem.getRegistryName() + ").");
                return;
            }
        }
        if (changedData.overrideConversion(otherCoin, otherCoinCount)) {
            // empty if block
        }
        MoneyUtil.sortCoinList();
    }

    private static void sortCoinList() {
        ArrayList<CoinData> newList = new ArrayList<CoinData>();
        while (coinList.size() > 0) {
            int highestValueIndex = 0;
            long highestValue = coinList.get(0).getValue();
            for (int i = 1; i < coinList.size(); ++i) {
                if (coinList.get(i).getValue() <= highestValue) continue;
                highestValueIndex = i;
                highestValue = coinList.get(i).getValue();
            }
            newList.add(coinList.get(highestValueIndex));
            coinList.remove(highestValueIndex);
        }
        coinList = newList;
    }

    public static boolean isCoin(Item item) {
        return MoneyUtil.isCoin(item, true);
    }

    public static boolean isCoin(Item item, boolean allowHidden) {
        if (item == null) {
            return false;
        }
        for (CoinData coinData : coinList) {
            if (!coinData.getCoinItem().equals(item)) continue;
            return allowHidden || !coinData.isHidden;
        }
        return false;
    }

    public static boolean isCoinHidden(Item item) {
        if (item == null) {
            return false;
        }
        for (CoinData coinData : coinList) {
            if (coinData.coinItem != item) continue;
            return coinData.isHidden;
        }
        return false;
    }

    public static boolean isCoin(@Nonnull ItemStack stack) {
        return MoneyUtil.isCoin(stack, true);
    }

    public static boolean isCoin(@Nonnull ItemStack stack, boolean allowHidden) {
        return MoneyUtil.isCoin(stack.m_41720_(), allowHidden);
    }

    public static long getValue(Item coinItem) {
        CoinData coinData = MoneyUtil.getData(coinItem);
        if (coinData != null) {
            return coinData.getValue();
        }
        return 0L;
    }

    public static long getValue(ItemStack coinStack) {
        return MoneyUtil.getValue(coinStack.m_41720_()) * (long)coinStack.m_41613_();
    }

    public static long getValue(NonNullList<ItemStack> inventory) {
        long value = 0L;
        for (int i = 0; i < inventory.size(); ++i) {
            value += MoneyUtil.getValue((ItemStack)inventory.get(i));
        }
        return value;
    }

    public static long getValue(Container inventory) {
        long value = 0L;
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            value += MoneyUtil.getValue(inventory.m_8020_(i));
        }
        return value;
    }

    public static void ConvertAllCoinsUp(Container inventory) {
        int i;
        for (i = 1; i < coinList.size(); ++i) {
            MoneyUtil.ConvertCoinsUp(inventory, coinList.get(i).getCoinItem());
        }
        for (i = coinList.size() - 1; i > 0; --i) {
            MoneyUtil.ConvertCoinsUp(inventory, coinList.get(i).getCoinItem());
        }
    }

    public static NonNullList<ItemStack> ConvertAllCoinsUp(NonNullList<ItemStack> inventoryList) {
        Container inventory = InventoryUtil.buildInventory(inventoryList);
        MoneyUtil.ConvertAllCoinsUp(inventory);
        return InventoryUtil.buildList(inventory);
    }

    public static void ConvertCoinsUp(Container inventory, Item smallCoin) {
        Pair<Item, Integer> upwardConversion = MoneyUtil.getUpwardConversion(smallCoin);
        if (upwardConversion == null) {
            return;
        }
        Item largeCoin = (Item)upwardConversion.getFirst();
        int smallCoinCount = (Integer)upwardConversion.getSecond();
        if (!MoneyUtil.isCoin(largeCoin)) {
            return;
        }
        while (InventoryUtil.GetItemCount(inventory, smallCoin) >= smallCoinCount) {
            InventoryUtil.RemoveItemCount(inventory, smallCoin, smallCoinCount);
            ItemStack newCoinStack = new ItemStack((ItemLike)largeCoin, 1);
            if (InventoryUtil.PutItemStack(inventory, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(inventory, new ItemStack((ItemLike)smallCoin, smallCoinCount));
            return;
        }
    }

    public static void ConvertAllCoinsDown(Container inventory) {
        MoneyUtil.ConvertAllCoinsDown(inventory, 2);
    }

    private static void ConvertAllCoinsDown(Container inventory, int iterations) {
        for (int x = 0; x < iterations; ++x) {
            for (int i = 0; i < coinList.size() - 1; ++i) {
                if (MoneyUtil.coinList.get((int)i).isHidden) continue;
                MoneyUtil.ConvertCoinsDown(inventory, coinList.get(i).getCoinItem());
            }
        }
    }

    public static void ConvertCoinsDown(Container inventory, Item largeCoin) {
        CoinData coinData = MoneyUtil.getData(largeCoin);
        Item smallCoin = coinData.worthOtherCoin;
        int smallCoinCount = coinData.worthOtherCoinCount;
        if (!MoneyUtil.isCoin(smallCoin)) {
            return;
        }
        while (InventoryUtil.GetItemCount(inventory, largeCoin) > 0) {
            InventoryUtil.RemoveItemCount(inventory, largeCoin, 1);
            ItemStack newCoinStack = new ItemStack((ItemLike)smallCoin, smallCoinCount);
            if (InventoryUtil.PutItemStack(inventory, newCoinStack)) continue;
            InventoryUtil.TryPutItemStack(inventory, new ItemStack((ItemLike)largeCoin, 1));
            return;
        }
    }

    public static void SortCoins(Container inventory) {
        InventoryUtil.MergeStacks(inventory);
        ArrayList<ItemStack> oldInventory = new ArrayList<ItemStack>();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            if (inventory.m_8020_(i).m_41619_()) continue;
            oldInventory.add(inventory.m_8020_(i));
        }
        inventory.m_6211_();
        int index = 0;
        while (oldInventory.size() > 0) {
            int highestIndex = 0;
            long highestIndividualValue = MoneyUtil.getValue(((ItemStack)oldInventory.get(0)).m_41720_());
            long highestWholeValue = highestIndividualValue * (long)((ItemStack)oldInventory.get(0)).m_41613_();
            for (int i = 1; i < oldInventory.size(); ++i) {
                ItemStack stack = (ItemStack)oldInventory.get(i);
                long thisIndividualValue = MoneyUtil.getValue(stack.m_41720_());
                long thisWholeValue = thisIndividualValue * (long)stack.m_41613_();
                if (thisIndividualValue > highestIndividualValue) {
                    highestIndex = i;
                    highestIndividualValue = thisIndividualValue;
                    highestWholeValue = thisWholeValue;
                    continue;
                }
                if (thisIndividualValue != highestIndividualValue || thisWholeValue <= highestWholeValue) continue;
                highestIndex = i;
                highestWholeValue = thisWholeValue;
            }
            inventory.m_6836_(index, (ItemStack)oldInventory.get(highestIndex));
            ++index;
            oldInventory.remove(highestIndex);
        }
    }

    public static NonNullList<ItemStack> SortCoins(NonNullList<ItemStack> inventory) {
        Container tempInventory = InventoryUtil.buildInventory(inventory);
        MoneyUtil.SortCoins(tempInventory);
        return InventoryUtil.buildList(tempInventory);
    }

    public static boolean ProcessPayment(@Nullable Container inventory, @Nonnull Player player, @Nonnull CoinValue price) {
        return MoneyUtil.ProcessPayment(inventory, player, price, false);
    }

    public static boolean ProcessPayment(@Nullable Container inventory, @Nonnull Player player, @Nonnull CoinValue price, boolean ignoreWallet) {
        ItemStack wallet = ignoreWallet ? ItemStack.f_41583_ : LightmansCurrency.getWalletStack(player);
        long valueToTake = price.getRawValue();
        long rawInventoryValue = 0L;
        if (inventory != null) {
            rawInventoryValue += MoneyUtil.getValue(inventory);
        }
        if (!wallet.m_41619_()) {
            rawInventoryValue += MoneyUtil.getValue(WalletItem.getWalletInventory(wallet));
        }
        if (rawInventoryValue < valueToTake) {
            return false;
        }
        if (inventory != null) {
            valueToTake = MoneyUtil.takeObjectsOfValue(valueToTake, inventory, true);
        }
        if (valueToTake > 0L && !wallet.m_41619_()) {
            NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(wallet);
            valueToTake = MoneyUtil.takeObjectsOfValue(valueToTake, walletInventory);
            WalletItem.putWalletInventory(wallet, walletInventory);
        }
        if (valueToTake < 0L) {
            List<ItemStack> change = MoneyUtil.getCoinsOfValue(Math.abs(valueToTake));
            for (ItemStack coinStack : change) {
                if (!wallet.m_41619_()) {
                    coinStack = WalletItem.PickupCoin(wallet, coinStack);
                }
                if (!coinStack.m_41619_() && inventory != null) {
                    coinStack = InventoryUtil.TryPutItemStack(inventory, coinStack);
                }
                if (coinStack.m_41619_()) continue;
                player.m_150109_().m_150079_(coinStack);
            }
        }
        return true;
    }

    public static void ProcessChange(@Nullable Container inventory, @Nonnull Player player, @Nonnull CoinValue change) {
        MoneyUtil.ProcessChange(inventory, player, change, false);
    }

    public static void ProcessChange(@Nullable Container inventory, @Nonnull Player player, @Nonnull CoinValue change, boolean ignoreWallet) {
        ItemStack wallet = ignoreWallet ? ItemStack.f_41583_ : LightmansCurrency.getWalletStack(player);
        List<ItemStack> changeCoins = MoneyUtil.getCoinsOfValue(change);
        for (ItemStack coinStack : changeCoins) {
            if (!wallet.m_41619_()) {
                coinStack = WalletItem.PickupCoin(wallet, coinStack);
            }
            if (!coinStack.m_41619_() && inventory != null) {
                coinStack = InventoryUtil.TryPutItemStack(inventory, coinStack);
            }
            if (coinStack.m_41619_()) continue;
            player.m_150109_().m_150079_(coinStack);
        }
    }

    public static long takeObjectsOfValue(long value, Container inventory, boolean forceTake) {
        ItemStack itemStack;
        int i;
        long coinValue;
        if (MoneyUtil.getValue(inventory) < value && !forceTake) {
            return value;
        }
        for (CoinData coinData : coinList) {
            coinValue = coinData.getValue();
            if (coinValue > value) continue;
            for (i = 0; i < inventory.m_6643_() && coinValue <= value; ++i) {
                itemStack = inventory.m_8020_(i);
                if (!inventory.m_8020_(i).m_41720_().equals(coinData.getCoinItem())) continue;
                while (coinValue <= value && !itemStack.m_41619_()) {
                    value -= coinValue;
                    itemStack.m_41764_(itemStack.m_41613_() - 1);
                    if (!itemStack.m_41619_()) continue;
                    inventory.m_6836_(i, ItemStack.f_41583_);
                }
            }
        }
        if (value > 0L) {
            for (int c = coinList.size() - 1; c >= 0; --c) {
                Item coin = coinList.get(c).getCoinItem();
                coinValue = coinList.get(c).getValue();
                for (i = 0; i < inventory.m_6643_() && value > 0L; ++i) {
                    itemStack = inventory.m_8020_(i);
                    if (itemStack.m_41720_() != coin) continue;
                    while (value > 0L && !itemStack.m_41619_()) {
                        value -= coinValue;
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        if (!itemStack.m_41619_()) continue;
                        inventory.m_6836_(i, ItemStack.f_41583_);
                    }
                }
            }
        }
        return value;
    }

    private static long takeObjectsOfValue(long value, NonNullList<ItemStack> inventory) {
        return MoneyUtil.takeObjectsOfValue(value, inventory, false);
    }

    private static long takeObjectsOfValue(long value, NonNullList<ItemStack> inventory, boolean forceTake) {
        ItemStack itemStack;
        int i;
        long coinValue;
        if (MoneyUtil.getValue(inventory) < value && !forceTake) {
            return value;
        }
        for (CoinData coinData : coinList) {
            coinValue = coinData.getValue();
            if (coinValue > value) continue;
            for (i = 0; i < inventory.size() && coinValue <= value; ++i) {
                itemStack = (ItemStack)inventory.get(i);
                if (!((ItemStack)inventory.get(i)).m_41720_().equals(coinData.getCoinItem())) continue;
                while (coinValue <= value && !itemStack.m_41619_()) {
                    value -= coinValue;
                    itemStack.m_41764_(itemStack.m_41613_() - 1);
                    if (!itemStack.m_41619_()) continue;
                    inventory.set(i, (Object)ItemStack.f_41583_);
                }
            }
        }
        if (value > 0L) {
            for (int c = coinList.size() - 1; c >= 0; --c) {
                Item coin = coinList.get(c).getCoinItem();
                coinValue = coinList.get(c).getValue();
                for (i = 0; i < inventory.size() && value > 0L; ++i) {
                    itemStack = (ItemStack)inventory.get(i);
                    if (itemStack.m_41720_() != coin) continue;
                    while (value > 0L && !itemStack.m_41619_()) {
                        value -= coinValue;
                        itemStack.m_41764_(itemStack.m_41613_() - 1);
                        if (!itemStack.m_41619_()) continue;
                        inventory.set(i, (Object)ItemStack.f_41583_);
                    }
                }
            }
        }
        return value;
    }

    public static List<ItemStack> getCoinsOfValue(long value) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        if (value <= 0L) {
            return items;
        }
        for (int i = 0; i < coinList.size(); ++i) {
            if (MoneyUtil.coinList.get((int)i).isHidden) continue;
            Item coin = coinList.get(i).getCoinItem();
            int coinsToGive = 0;
            long coinValue = coinList.get(i).getValue();
            while (coinValue <= value) {
                value -= coinValue;
                ++coinsToGive;
            }
            while (coinsToGive > 0) {
                int giveCount = coinsToGive;
                if (giveCount > 64) {
                    giveCount = 64;
                }
                coinsToGive -= giveCount;
                ItemStack newStack = new ItemStack((ItemLike)coin, giveCount);
                items.add(newStack);
            }
        }
        return items;
    }

    public static List<ItemStack> getCoinsOfValue(CoinValue value) {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (CoinValue.CoinValuePair pricePair : value.coinValues) {
            int amountToAdd;
            for (int amount = pricePair.amount; amount > 0; amount -= amountToAdd) {
                ItemStack newStack = new ItemStack((ItemLike)pricePair.coin);
                amountToAdd = MathUtil.clamp(amount, 0, newStack.m_41741_());
                newStack.m_41764_(amountToAdd);
                items.add(newStack);
            }
        }
        return items;
    }

    public static String getStringOfValue(long value) {
        Object string = "";
        if (value <= 0L) {
            return string;
        }
        for (int i = 0; i < coinList.size(); ++i) {
            CoinData coinData = coinList.get(i);
            if (coinData.isHidden) continue;
            int coinCount = 0;
            long coinValue = coinList.get(i).getValue();
            while (coinValue <= value) {
                value -= coinValue;
                ++coinCount;
            }
            if (coinCount <= 0) continue;
            string = (String)string + String.valueOf(coinCount);
            string = (String)string + coinData.getInitial().getString();
        }
        return string;
    }

    public static String getStringOfValue(CoinValue value) {
        Object string = "";
        for (int i = 0; i < value.coinValues.size(); ++i) {
            CoinValue.CoinValuePair pricePair = value.coinValues.get(i);
            CoinData coinData = MoneyUtil.getData(pricePair.coin);
            if (coinData == null) continue;
            string = (String)string + String.valueOf(pricePair.amount);
            string = (String)string + coinData.getInitial().getString();
        }
        return string;
    }

    public static List<MintRecipe> getMintRecipes() {
        if (mintRecipes == null || mintRecipesDirty) {
            mintRecipesDirty = false;
            mintRecipes = new ArrayList<MintRecipe>();
            for (CoinData coinData : coinList) {
                MintRecipe recipe = coinData.getMintRecipe();
                if (recipe == null) continue;
                mintRecipes.add(recipe);
            }
        }
        return mintRecipes;
    }

    public static List<MintRecipe> getMeltRecipes() {
        if (meltRecipes == null || meltRecipesDirty) {
            meltRecipesDirty = false;
            meltRecipes = new ArrayList<MintRecipe>();
            for (CoinData coinData : coinList) {
                MintRecipe recipe = coinData.getMeltRecipe();
                if (recipe == null) continue;
                meltRecipes.add(recipe);
            }
        }
        return meltRecipes;
    }

    public static CoinData getData(Item coinItem) {
        for (CoinData coinData : coinList) {
            if (coinData.coinItem != coinItem) continue;
            return coinData;
        }
        return null;
    }

    public static List<Item> getAllCoins() {
        return MoneyUtil.getAllCoins(false);
    }

    public static List<Item> getAllCoins(boolean includeHidden) {
        ArrayList<Item> coinItems = new ArrayList<Item>();
        for (int i = 0; i < coinList.size(); ++i) {
            if (MoneyUtil.coinList.get((int)i).isHidden && !includeHidden) continue;
            coinItems.add(MoneyUtil.coinList.get((int)i).coinItem);
        }
        return coinItems;
    }

    public static List<CoinData> getAllData() {
        return MoneyUtil.getAllData(false);
    }

    public static List<CoinData> getAllData(boolean includeHidden) {
        if (publicCoinList == null || coinListDirty) {
            coinListDirty = false;
            publicCoinList = new ArrayList<CoinData>();
            for (int i = 0; i < coinList.size(); ++i) {
                if (MoneyUtil.coinList.get((int)i).isHidden) continue;
                publicCoinList.add(coinList.get(i));
            }
        }
        if (includeHidden) {
            return coinList;
        }
        return publicCoinList;
    }

    private static Item getItemFromID(String coinID) {
        for (CoinData coinData : coinList) {
            if (!coinData.coinItem.getRegistryName().toString().equals(coinID)) continue;
            return coinData.coinItem;
        }
        LightmansCurrency.LogWarning("Could not find a coin with an id of " + coinID);
        return Items.f_41852_;
    }

    public static Pair<Item, Integer> getUpwardConversion(Item coinItem) {
        Item largeCoin = null;
        int amount = Integer.MAX_VALUE;
        for (CoinData coinData : coinList) {
            if (coinData.worthOtherCoin != coinItem || coinData.worthOtherCoinCount >= amount || coinData.isHidden) continue;
            largeCoin = coinData.coinItem;
            amount = coinData.worthOtherCoinCount;
        }
        if (largeCoin != null) {
            return new Pair(largeCoin, (Object)amount);
        }
        return null;
    }

    public static Pair<Item, Integer> getDownwardConversion(Item coinItem) {
        Item largeCoin = null;
        int amount = Integer.MAX_VALUE;
        for (CoinData coinData : coinList) {
            if (coinData.worthOtherCoin != coinItem || coinData.worthOtherCoinCount >= amount) continue;
            largeCoin = coinData.coinItem;
            amount = coinData.worthOtherCoinCount;
        }
        if (largeCoin != null) {
            return new Pair(largeCoin, (Object)amount);
        }
        return null;
    }

    public static class CoinData {
        private Item coinItem;
        private Item worthOtherCoin = null;
        private int worthOtherCoinCount = 0;
        private Component initial;
        private Item mintingMaterialItem = null;
        private ResourceLocation mintingMaterialTag = null;
        private boolean isHidden = false;

        private CoinData(Builder builder) {
            this.coinItem = builder.coinItem;
            this.worthOtherCoin = builder.worthOtherCoin;
            this.worthOtherCoinCount = builder.worthOtherCoinCount;
            this.initial = builder.initialText;
            this.mintingMaterialItem = builder.mintingMaterialItem;
            this.mintingMaterialTag = builder.mintingMaterialTag;
            this.isHidden = builder.isHidden;
        }

        public long getValue() {
            if (!this.convertsDownwards()) {
                return 1L;
            }
            CoinData otherCoinData = MoneyUtil.getData(this.worthOtherCoin);
            if (otherCoinData != null) {
                return (long)this.worthOtherCoinCount * otherCoinData.getValue();
            }
            LightmansCurrency.LogError("CoinData.getValue() returning 1 due it's dependent coin not being registered.");
            return 1L;
        }

        public Item getCoinItem() {
            return this.coinItem;
        }

        public boolean convertsDownwards() {
            return this.worthOtherCoin != null && this.worthOtherCoinCount > 0;
        }

        public Pair<Item, Integer> getDownwardConversion() {
            return new Pair((Object)this.worthOtherCoin, (Object)this.worthOtherCoinCount);
        }

        private boolean overrideConversion(@Nonnull Item newOtherCoin, int newOtherCoinAmount) {
            if (newOtherCoin == this.worthOtherCoin && newOtherCoinAmount == this.worthOtherCoinCount) {
                LightmansCurrency.LogDebug("Conversion for " + this.coinItem.getRegistryName() + " does not need changing.");
                return false;
            }
            LightmansCurrency.LogDebug("Conversion for " + this.coinItem.getRegistryName() + " changed from " + this.worthOtherCoinCount + "x'" + this.worthOtherCoin.getRegistryName() + "' to " + newOtherCoinAmount + "x'" + newOtherCoin.getRegistryName() + "'");
            this.worthOtherCoin = newOtherCoin;
            this.worthOtherCoinCount = newOtherCoinAmount;
            return true;
        }

        public Component getInitial() {
            if (this.initial != null) {
                return this.initial;
            }
            LightmansCurrency.LogWarning("No initial found for the coin '" + this.coinItem.getRegistryName().toString() + "'.");
            return new TextComponent(this.coinItem.m_7626_(new ItemStack((ItemLike)this.coinItem)).getString().substring(0, 1).toLowerCase());
        }

        public MintRecipe getMintRecipe() {
            if (!Config.canMint(this.coinItem)) {
                return null;
            }
            if (this.mintingMaterialItem != null) {
                return new MintRecipe(this.mintingMaterialItem, this.coinItem);
            }
            if (this.mintingMaterialTag != null) {
                return new MintRecipe(this.mintingMaterialTag, this.coinItem);
            }
            return null;
        }

        public MintRecipe getMeltRecipe() {
            List tagItems;
            Tag tag;
            if (!Config.canMelt(this.coinItem)) {
                return null;
            }
            if (this.mintingMaterialItem != null) {
                return new MintRecipe(this.coinItem, this.mintingMaterialItem);
            }
            if (this.mintingMaterialTag != null && (tag = ItemTags.m_13193_().m_7689_(this.mintingMaterialTag)) != null && (tagItems = tag.m_6497_()).size() > 0) {
                Item resultItem = (Item)tagItems.get(0);
                LightmansCurrency.LogInfo("Creating melt recipe for " + this.coinItem.getRegistryName().toString() + " using the first item with the given tag '" + this.mintingMaterialTag.toString() + "' (" + resultItem.getRegistryName().toString() + ")");
                return new MintRecipe(this.coinItem, resultItem);
            }
            return null;
        }

        public boolean isHidden() {
            return this.isHidden;
        }

        public static Builder getBuilder(Item coinItem) {
            return new Builder(coinItem);
        }

        public static class Builder {
            final Item coinItem;
            Item worthOtherCoin = null;
            int worthOtherCoinCount = 0;
            Component initialText = null;
            Item mintingMaterialItem = null;
            ResourceLocation mintingMaterialTag = null;
            boolean isHidden = false;

            public Builder(@Nonnull Item coinItem) {
                this.coinItem = coinItem;
            }

            public Builder defineConversion(Item otherCoin, int coinAmount) {
                this.worthOtherCoin = otherCoin;
                this.worthOtherCoinCount = coinAmount;
                return this;
            }

            public Builder defineInitial(Component textComponent) {
                this.initialText = textComponent;
                return this;
            }

            public Builder defineInitial(String translationString) {
                this.initialText = new TranslatableComponent(translationString);
                return this;
            }

            public Builder defineMintingMaterial(Item mintingMaterial) {
                this.mintingMaterialItem = mintingMaterial;
                return this;
            }

            public Builder defineMintingMaterialTag(ResourceLocation mintingMaterial) {
                this.mintingMaterialTag = mintingMaterial;
                return this;
            }

            public Builder setHidden() {
                this.isHidden = true;
                return this;
            }

            public CoinData build() {
                return new CoinData(this);
            }
        }
    }

    public static class CoinValue {
        public static final String DEFAULT_KEY = "CoinValue";
        public final List<CoinValuePair> coinValues;
        public static final CoinValue EMPTY = new CoinValue(new CoinValuePair[0]);

        public CoinValue(CompoundTag compound) {
            this.coinValues = new ArrayList<CoinValuePair>();
            this.readFromNBT(compound, DEFAULT_KEY);
            this.roundValue();
        }

        public CoinValue(long rawValue) {
            this.coinValues = new ArrayList<CoinValuePair>();
            this.readFromOldValue(rawValue);
            this.roundValue();
        }

        public CoinValue(NonNullList<ItemStack> inventory) {
            this.coinValues = new ArrayList<CoinValuePair>();
            for (ItemStack stack : inventory) {
                Item coinItem = stack.m_41720_();
                int count = stack.m_41613_();
                CoinData coinData = MoneyUtil.getData(coinItem);
                if (coinData != null) {
                    while (coinData != null && coinData.isHidden && coinData.convertsDownwards()) {
                        coinItem = (Item)coinData.getDownwardConversion().getFirst();
                        count *= ((Integer)coinData.getDownwardConversion().getSecond()).intValue();
                        coinData = MoneyUtil.getData(coinItem);
                    }
                    for (int i = 0; i < this.coinValues.size(); ++i) {
                        if (this.coinValues.get((int)i).coin != coinItem) continue;
                        this.coinValues.get((int)i).amount += count;
                        count = 0;
                        break;
                    }
                    if (count <= 0) continue;
                    this.coinValues.add(new CoinValuePair(coinItem, count));
                    continue;
                }
                if (coinItem == Items.f_41852_) continue;
                LightmansCurrency.LogInfo("Coin Data for coin '" + coinItem.getRegistryName() + "' is null.");
            }
            this.roundValue();
        }

        public CoinValue(CoinValue otherValue) {
            this.coinValues = new ArrayList<CoinValuePair>();
            for (CoinValuePair pricePair : otherValue.coinValues) {
                this.coinValues.add(pricePair.copy());
            }
            this.roundValue();
        }

        @SafeVarargs
        public CoinValue(CoinValuePair ... priceValues) {
            this.coinValues = new ArrayList<CoinValuePair>();
            for (CoinValuePair value : priceValues) {
                for (int i = 0; i < this.coinValues.size(); ++i) {
                    if (this.coinValues.get((int)i).coin != value.coin) continue;
                    this.coinValues.get((int)i).amount += value.amount;
                    value.amount = 0;
                }
                if (value.amount <= 0) continue;
                this.coinValues.add(value);
            }
            this.roundValue();
        }

        private CoinValue(List<CoinValuePair> priceValues) {
            this.coinValues = priceValues;
            this.roundValue();
        }

        public CompoundTag writeToNBT(CompoundTag compound, String key) {
            ListTag list = new ListTag();
            for (CoinValuePair value : this.coinValues) {
                CompoundTag thisCompound = new CompoundTag();
                ResourceLocation resource = value.coin.getRegistryName();
                if (resource == null || !MoneyUtil.isCoin(value.coin)) continue;
                thisCompound.m_128359_("id", resource.toString());
                thisCompound.m_128405_("amount", value.amount);
                list.add((Object)thisCompound);
            }
            compound.m_128365_(key, (net.minecraft.nbt.Tag)list);
            return compound;
        }

        public void readFromNBT(CompoundTag compound, String key) {
            ListTag listNBT = compound.m_128437_(key, 10);
            if (listNBT != null) {
                this.coinValues.clear();
                for (int i = 0; i < listNBT.size(); ++i) {
                    CompoundTag thisCompound = listNBT.m_128728_(i);
                    Item priceCoin = MoneyUtil.getItemFromID(thisCompound.m_128461_("id"));
                    int amount = thisCompound.m_128451_("amount");
                    this.coinValues.add(new CoinValuePair(priceCoin, amount));
                }
            }
        }

        public void readFromOldValue(long oldPrice) {
            this.coinValues.clear();
            List<ItemStack> coinItems = MoneyUtil.getCoinsOfValue(oldPrice);
            for (ItemStack stack : coinItems) {
                Item coinItem = stack.m_41720_();
                int amount = stack.m_41613_();
                for (int i = 0; i < this.coinValues.size(); ++i) {
                    if (this.coinValues.get((int)i).coin != coinItem) continue;
                    this.coinValues.get((int)i).amount += amount;
                    amount = 0;
                }
                if (amount <= 0) continue;
                this.coinValues.add(new CoinValuePair(coinItem, amount));
            }
        }

        public void addValue(CoinValue other) {
            CoinValue otherPrice = other.copy();
            for (int i = 0; i < this.coinValues.size(); ++i) {
                for (int j = 0; j < otherPrice.coinValues.size(); ++j) {
                    if (this.coinValues.get((int)i).coin != otherPrice.coinValues.get((int)j).coin) continue;
                    this.coinValues.get((int)i).amount += otherPrice.coinValues.get((int)j).amount;
                    otherPrice.coinValues.get((int)j).amount = 0;
                }
            }
            for (CoinValuePair pair : otherPrice.coinValues) {
                if (pair.amount <= 0) continue;
                this.coinValues.add(pair);
            }
            this.roundValue();
        }

        public void addValue(Item coin, int amount) {
            for (int i = 0; i < this.coinValues.size(); ++i) {
                CoinValuePair pair = this.coinValues.get(i);
                if (pair.coin != coin) continue;
                pair.amount += amount;
                amount = 0;
            }
            if (amount > 0) {
                this.coinValues.add(new CoinValuePair(coin, amount));
            }
            this.roundValue();
        }

        public void removeValue(Item coin, int amount) {
            for (int i = 0; i < this.coinValues.size(); ++i) {
                CoinValuePair pair = this.coinValues.get(i);
                if (pair.coin != coin) continue;
                pair.amount -= amount;
                if (pair.amount <= 0) {
                    this.coinValues.remove(i);
                }
                return;
            }
        }

        private void roundValue() {
            while (this.needsRounding()) {
                for (int i = 0; i < this.coinValues.size(); ++i) {
                    if (!this.needsRounding(i)) continue;
                    CoinValuePair pair = this.coinValues.get(i);
                    Pair<Item, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
                    int largeAmount = 0;
                    while (pair.amount >= (Integer)conversion.getSecond()) {
                        ++largeAmount;
                        pair.amount -= ((Integer)conversion.getSecond()).intValue();
                    }
                    if (pair.amount == 0) {
                        this.coinValues.remove(i);
                        --i;
                    }
                    for (CoinValuePair thisPair : this.coinValues) {
                        if (thisPair.coin != conversion.getFirst()) continue;
                        thisPair.amount += largeAmount;
                        largeAmount = 0;
                    }
                    if (largeAmount <= 0) continue;
                    this.coinValues.add(new CoinValuePair((Item)conversion.getFirst(), largeAmount));
                }
            }
            this.sortValue();
        }

        private void sortValue() {
            ArrayList<CoinValuePair> newList = new ArrayList<CoinValuePair>();
            while (this.coinValues.size() > 0) {
                long largestValue = MoneyUtil.getValue(this.coinValues.get((int)0).coin);
                int largestIndex = 0;
                for (int i = 1; i < this.coinValues.size(); ++i) {
                    long thisValue = MoneyUtil.getValue(this.coinValues.get((int)i).coin);
                    if (thisValue <= largestValue) continue;
                    largestIndex = i;
                    largestValue = thisValue;
                }
                newList.add(this.coinValues.get(largestIndex));
                this.coinValues.remove(largestIndex);
            }
            for (int i = 0; i < newList.size(); ++i) {
                this.coinValues.add((CoinValuePair)newList.get(i));
            }
        }

        private boolean needsRounding() {
            for (int i = 0; i < this.coinValues.size(); ++i) {
                if (!this.needsRounding(i)) continue;
                return true;
            }
            return false;
        }

        private boolean needsRounding(int index) {
            CoinValuePair pair = this.coinValues.get(index);
            Pair<Item, Integer> conversion = MoneyUtil.getUpwardConversion(pair.coin);
            return conversion != null && pair.amount >= (Integer)conversion.getSecond();
        }

        public int getEntry(Item coinItem) {
            for (CoinValuePair pair : this.coinValues) {
                if (pair.coin != coinItem) continue;
                return pair.amount;
            }
            return 0;
        }

        public CoinValue copy() {
            return new CoinValue(this);
        }

        public String getString() {
            return MoneyUtil.getStringOfValue(this);
        }

        public long getRawValue() {
            long value = 0L;
            for (CoinValuePair pricePair : this.coinValues) {
                CoinData coinData = MoneyUtil.getData(pricePair.coin);
                if (coinData == null) continue;
                value += (long)pricePair.amount * coinData.getValue();
            }
            return value;
        }

        public CoinValue ApplyMultiplier(double costMultiplier) {
            CoinValue multipliedValue = new CoinValue(new CoinValuePair[0]);
            costMultiplier = MathUtil.clamp(costMultiplier, 0.0, 10.0);
            for (int i = 0; i < this.coinValues.size(); ++i) {
                int amount = this.coinValues.get((int)i).amount;
                Item coin = this.coinValues.get((int)i).coin;
                double newAmount = (double)amount * costMultiplier;
                double leftoverAmount = newAmount % 1.0;
                multipliedValue.addValue(coin, (int)newAmount);
                CoinData coinData = MoneyUtil.getData(coin);
                while (coinData != null && coinData.convertsDownwards() && leftoverAmount > 0.0) {
                    Pair<Item, Integer> conversion = coinData.getDownwardConversion();
                    coin = (Item)conversion.getFirst();
                    coinData = MoneyUtil.getData(coin);
                    newAmount = leftoverAmount * (double)((Integer)conversion.getSecond()).intValue();
                    leftoverAmount = newAmount % 1.0;
                    multipliedValue.addValue(coin, (int)newAmount);
                }
            }
            return multipliedValue;
        }

        public Pair<ItemStack, ItemStack> getTradeItems() {
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(this);
            ItemStack stack1 = ItemStack.f_41583_;
            ItemStack stack2 = ItemStack.f_41583_;
            if (coins.size() > 0) {
                stack1 = coins.get(0);
            } else {
                LightmansCurrency.LogWarning("A CoinValue used in a trade gave no coins as an output.");
            }
            if (coins.size() > 1) {
                stack2 = coins.get(1);
            }
            if (coins.size() > 2) {
                LightmansCurrency.LogWarning("A CoinValue used in a trade gave more than two stacks of coins of output.");
            }
            return new Pair((Object)stack1, (Object)stack2);
        }

        public ItemStack getTradeItem() {
            List<ItemStack> coins = MoneyUtil.getCoinsOfValue(this);
            ItemStack stack = ItemStack.f_41583_;
            if (coins.size() > 0) {
                stack = coins.get(0);
            } else {
                LightmansCurrency.LogWarning("A CoinValue used in a trade gave no coins as an output.");
            }
            if (coins.size() > 1) {
                LightmansCurrency.LogWarning("A CoinValue used in a trade output gave more than one stack of coins of output.");
            }
            return stack;
        }

        public static CoinValue easyBuild1(ItemStack ... stack) {
            ArrayList<CoinValuePair> pairs = new ArrayList<CoinValuePair>();
            for (int i = 0; i < stack.length; ++i) {
                if (MoneyUtil.isCoin(stack[i]) || !MoneyUtil.initialized()) {
                    pairs.add(new CoinValuePair(stack[i].m_41720_(), stack[i].m_41613_()));
                    continue;
                }
                LightmansCurrency.LogWarning("CoinValue.easyBuild1: ItemStack at index " + i + " is not a valid coin.");
            }
            return new CoinValue(pairs);
        }

        public static CoinValue easyBuild2(Container inventory) {
            return new CoinValue(MoneyUtil.getValue(inventory));
        }

        public static class CoinValuePair {
            public final Item coin;
            public int amount = 0;

            public CoinValuePair(Item coin, int amount) {
                this.coin = coin;
                this.amount = amount;
            }

            public CoinValuePair copy() {
                return new CoinValuePair(this.coin, this.amount);
            }
        }
    }

    public static class MintRecipe {
        ResourceLocation itemInTag = null;
        Item itemIn = null;
        Item itemOut = null;

        public MintRecipe(ResourceLocation itemTag, Item out) {
            this.itemInTag = itemTag;
            this.itemOut = out;
        }

        public MintRecipe(Item in, Item out) {
            this.itemIn = in;
            this.itemOut = out;
        }

        public boolean validInput(Item itemIn) {
            if (this.itemInTag != null) {
                if (itemIn.getTags() != null) {
                    return itemIn.getTags().contains(this.itemInTag);
                }
                return false;
            }
            return this.itemIn == itemIn;
        }

        public ItemStack getOutput() {
            return new ItemStack((ItemLike)this.itemOut, 1);
        }
    }
}

