/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;

public class BankAccountLogger
extends TextLogger {
    public BankAccountLogger() {
        super("BankAccountHistory");
    }

    public void AddLog(ITrader trader, CoinValue amount, boolean isDeposit) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.bank", new Object[]{this.getTraderText(trader), this.getDepositText(isDeposit), BankAccountLogger.getCostText(amount)}));
    }

    public void AddLog(Player player, CoinValue amount, boolean isDeposit) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.bank", new Object[]{this.getPlayerText(player), this.getDepositText(isDeposit), BankAccountLogger.getCostText(amount)}));
    }

    public void AddLog(Player player, CoinValue amount, Component destination, boolean wasReceived) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.bank.transfer", new Object[]{this.getPlayerText(player), BankAccountLogger.getCostText(amount), this.getToFromText(wasReceived), destination}));
    }

    protected final Component getToFromText(boolean wasReceived) {
        return new TranslatableComponent("log.bank.transfer." + (wasReceived ? "from" : "to"));
    }

    protected final Component getDepositText(boolean isDeposit) {
        return new TranslatableComponent("log.bank." + (isDeposit ? "deposit" : "withdraw"));
    }

    protected final Component getTraderText(ITrader trader) {
        return new TextComponent(trader.getName().getString()).m_130940_(ChatFormatting.YELLOW);
    }

    protected final Component getPlayerText(Player player) {
        return new TextComponent(player.m_5446_().getString()).m_130940_(ChatFormatting.GREEN);
    }
}

