/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class ItemShopLogger
extends TextLogger {
    public ItemShopLogger() {
        super("ItemShopHistory");
    }

    @Deprecated
    public void AddLog(Player player, ItemTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        this.AddLog(PlayerReference.of(player), trade, pricePaid, isCreative);
    }

    public void AddLog(PlayerReference player, ItemTradeData trade, @Nonnull CoinValue pricePaid, boolean isCreative) {
        TranslatableComponent creativeText = isCreative ? new TranslatableComponent("log.shoplog.creative") : new TextComponent("");
        TextComponent playerName = new TextComponent("\u00a7a" + player.lastKnownName());
        TranslatableComponent boughtText = new TranslatableComponent("log.shoplog." + trade.getTradeType().name().toLowerCase());
        Component itemText = trade.isPurchase() ? ItemShopLogger.getItemInputComponent(trade.getSellItem(0), trade.getSellItem(1)) : ItemShopLogger.getItemOutputComponent(trade.getSellItem(0), trade.getCustomName(0), trade.getSellItem(1), trade.getCustomName(1));
        Component cost = ItemShopLogger.getCostText(pricePaid);
        if (trade.isBarter()) {
            cost = itemText;
            itemText = ItemShopLogger.getItemInputComponent(trade.getBarterItem(0), trade.getBarterItem(1));
        }
        this.AddLog((MutableComponent)new TranslatableComponent("log.shoplog.item.format", new Object[]{creativeText, playerName, boughtText, itemText, cost}));
    }

    public static Component getItemInputComponent(ItemStack item1, ItemStack item2) {
        return ItemShopLogger.getItemOutputComponent(item1, "", item2, "");
    }

    public static Component getItemOutputComponent(ItemStack item1, String customName1, ItemStack item2, String customName2) {
        if (item1.m_41619_() && item2.m_41619_()) {
            return new TextComponent("");
        }
        if (item1.m_41619_() && !item2.m_41619_()) {
            return ItemShopLogger.getItemComponent(item2, customName2);
        }
        if (!item1.m_41619_() && item2.m_41619_()) {
            return ItemShopLogger.getItemComponent(item1, customName1);
        }
        return new TranslatableComponent("log.shoplog.and", new Object[]{ItemShopLogger.getItemComponent(item1, customName1), ItemShopLogger.getItemComponent(item2, customName2)});
    }

    public static Component getItemComponent(ItemStack item, String customName) {
        MutableComponent itemName = new TextComponent("").m_7220_((Component)(customName.isBlank() ? item.m_41786_() : new TextComponent(customName))).m_130940_(item.m_41791_().f_43022_);
        if (item.m_41788_() && customName.isBlank()) {
            itemName.m_130940_(ChatFormatting.ITALIC);
        }
        return new TranslatableComponent("log.shoplog.item.itemformat", new Object[]{item.m_41613_(), itemName});
    }
}

