/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.api;

import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;

public class SettingsLogger
extends TextLogger {
    public SettingsLogger() {
        super("SettingsHistory");
    }

    public static final Component getEnableDisableText(boolean enabled, ChatFormatting enableFormat, ChatFormatting disableFormat) {
        return new TranslatableComponent("log.settings." + (enabled ? "enabled" : "disabled")).m_130940_(enabled ? enableFormat : disableFormat);
    }

    public static final Component getToFromText(boolean enabled, ChatFormatting ... format) {
        return new TranslatableComponent("log.settings." + (enabled ? "to" : "from")).m_130944_(format);
    }

    public static final Component getAddRemoveText(boolean added, ChatFormatting addFormat, ChatFormatting removeFormat) {
        return new TranslatableComponent("log.settings." + (added ? "add" : "remove")).m_130940_(added ? addFormat : removeFormat);
    }

    public static final Component getPlayerName(Player player) {
        return new TextComponent(player.m_7755_().getString()).m_130940_(ChatFormatting.GREEN);
    }

    public static final Component getTeamName(Team team) {
        if (team != null) {
            return new TextComponent(team.getName()).m_130940_(ChatFormatting.GREEN);
        }
        return new TextComponent("NULL");
    }

    public static final Component getPlayerName(PlayerReference player) {
        return new TextComponent(player.lastKnownName()).m_130940_(ChatFormatting.GREEN);
    }

    public static final Component format(Object value, ChatFormatting ... format) {
        return new TextComponent(value.toString()).m_130944_(format);
    }

    public void LogNameChange(Player player, String oldName, String newName) {
        if (player == null) {
            return;
        }
        if (oldName.isEmpty()) {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.changename.set", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(newName, ChatFormatting.GOLD)}));
        } else if (newName.isEmpty()) {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.changename.reset", new Object[]{SettingsLogger.getPlayerName(player)}));
        } else {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.changename", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(oldName, ChatFormatting.GOLD), SettingsLogger.format(newName, ChatFormatting.GOLD)}));
        }
    }

    public void LogOwnerChange(Player player, PlayerReference oldOwner, PlayerReference newOwner) {
        if (player == null) {
            return;
        }
        if (oldOwner.is((Entity)player)) {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.passed", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(newOwner)}));
        } else if (newOwner.is((Entity)player)) {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.taken", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(oldOwner)}));
        } else {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(oldOwner), SettingsLogger.getPlayerName(newOwner)}));
        }
    }

    public void LogTeamChange(Player player, PlayerReference owner, Team oldTeam, Team newTeam) {
        if (player == null || owner == null) {
            return;
        }
        if (oldTeam == null) {
            if (owner.is((Entity)player)) {
                this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.passed", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(newTeam)}));
            } else {
                this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getPlayerName(owner), SettingsLogger.getTeamName(newTeam)}));
            }
        } else if (newTeam == null) {
            if (owner.is((Entity)player)) {
                this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.taken", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam)}));
            } else {
                this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam), SettingsLogger.getPlayerName(owner)}));
            }
        } else {
            this.AddLog((MutableComponent)new TranslatableComponent("log.settings.newowner.transferred", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getTeamName(oldTeam), SettingsLogger.getTeamName(newTeam)}));
        }
    }

    public void LogCreativeToggle(Player player, boolean isNowCreative) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.creativemode", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getEnableDisableText(isNowCreative, ChatFormatting.GREEN, ChatFormatting.RED)}));
    }

    public void LogAddRemoveTrade(Player player, boolean added, int newCount) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.addremovetrade", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getAddRemoveText(added, ChatFormatting.GOLD, ChatFormatting.GOLD), SettingsLogger.format(newCount, ChatFormatting.GOLD)}));
    }

    public void LogAllyChange(Player player, PlayerReference ally, boolean added) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.addremoveally", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.getAddRemoveText(added, ChatFormatting.GOLD, ChatFormatting.GOLD), SettingsLogger.getPlayerName(ally), SettingsLogger.getToFromText(added, new ChatFormatting[0])}));
    }

    public void LogAllyPermissionChange(Player player, String permission, Object oldValue, Object newValue) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.permission.ally", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(permission, ChatFormatting.GOLD), SettingsLogger.format(oldValue, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogAllyPermissionChange(Player player, String permission, Object newValue) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.permission.ally.simple", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(permission, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogSettingsChange(Player player, String setting, Object oldValue, Object newValue) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.change", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(setting, ChatFormatting.GOLD), SettingsLogger.format(oldValue, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogSettingsChange(Player player, String setting, Object newValue) {
        this.AddLog((MutableComponent)new TranslatableComponent("log.settings.change.simple", new Object[]{SettingsLogger.getPlayerName(player), SettingsLogger.format(setting, ChatFormatting.GOLD), SettingsLogger.format(newValue, ChatFormatting.GOLD)}));
    }

    public void LogText(MutableComponent text) {
        this.AddLog(text);
    }
}

