/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.armor_display.MessageRequestArmorStandID;
import io.github.lightman314.lightmanscurrency.network.message.armor_display.MessageSendArmorStandID;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.EquipmentRestriction;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class ArmorDisplayTraderBlockEntity
extends ItemTraderBlockEntity {
    public static final int TRADE_COUNT = 4;
    ArmorStand armorStand;
    UUID armorStandID = null;
    private int armorStandEntityId = -1;
    int requestTimer = 0;
    int updateTimer = 0;

    public ArmorDisplayTraderBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.ARMOR_TRADER, pos, state, 4);
    }

    @Override
    public ItemTradeRestriction getRestriction(int tradeIndex) {
        switch (tradeIndex % 4) {
            case 0: {
                return new EquipmentRestriction(EquipmentSlot.HEAD, this::getArmorStand);
            }
            case 1: {
                return new EquipmentRestriction(EquipmentSlot.CHEST, this::getArmorStand);
            }
            case 2: {
                return new EquipmentRestriction(EquipmentSlot.LEGS, this::getArmorStand);
            }
            case 3: {
                return new EquipmentRestriction(EquipmentSlot.FEET, this::getArmorStand);
            }
        }
        return ItemTradeRestriction.NONE;
    }

    @Override
    public void markTradesDirty() {
        super.markTradesDirty();
        if (this.isServer()) {
            this.updateArmorStandArmor();
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        if (this.getArmorStand() == null) {
            if (this.requestTimer <= 0) {
                this.requestTimer = 20;
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageRequestArmorStandID(this.f_58858_));
            } else {
                --this.requestTimer;
            }
        }
    }

    @Override
    public void serverTick() {
        super.serverTick();
        if (this.updateTimer <= 0) {
            this.updateTimer = 20;
            this.validateArmorStand();
            this.updateArmorStandArmor();
            this.killIntrudingArmorStands();
        } else {
            --this.updateTimer;
        }
    }

    public void validateArmorStand() {
        if (this.isClient()) {
            return;
        }
        if (this.armorStand == null || this.armorStand.m_146910_()) {
            if (this.armorStandID != null) {
                this.armorStand = this.getArmorStand(this.armorStandID);
                if (this.armorStand == null) {
                    this.spawnArmorStand();
                }
            } else {
                this.spawnArmorStand();
            }
        } else if (!this.armorStand.m_142081_().equals(this.armorStandID)) {
            this.destroyArmorStand();
            this.spawnArmorStand();
        }
    }

    private void spawnArmorStand() {
        if (this.f_58857_ == null || this.isClient()) {
            return;
        }
        this.armorStand = new ArmorStand(this.f_58857_, (double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5);
        this.armorStand.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_() + 0.5, this.getStandRotation(), 0.0f);
        this.armorStand.m_20331_(true);
        this.armorStand.m_20242_(true);
        this.armorStand.m_20225_(true);
        CompoundTag compound = this.armorStand.m_20240_(new CompoundTag());
        compound.m_128379_("Marker", true);
        compound.m_128379_("NoBasePlate", true);
        this.armorStand.m_20258_(compound);
        this.f_58857_.m_7967_((Entity)this.armorStand);
        this.armorStandID = this.armorStand.m_142081_();
        this.m_6596_();
    }

    protected void updateArmorStandArmor() {
        if (this.armorStand != null) {
            for (int i = 0; i < 4 && i < this.tradeCount; ++i) {
                ItemTradeData thisTrade = this.getTrade(i);
                ItemTradeRestriction r = thisTrade.getRestriction();
                EquipmentSlot slot = null;
                if (r instanceof EquipmentRestriction) {
                    EquipmentRestriction er = (EquipmentRestriction)r;
                    slot = er.getEquipmentSlot();
                }
                if (slot == null) continue;
                if (thisTrade.hasStock(this) || this.getCoreSettings().isCreative()) {
                    this.armorStand.m_8061_(slot, thisTrade.getSellItem(0));
                    continue;
                }
                this.armorStand.m_8061_(slot, ItemStack.f_41583_);
            }
        }
    }

    public void killIntrudingArmorStands() {
        if (this.f_58857_ != null && this.armorStand != null) {
            this.f_58857_.m_45976_(ArmorStand.class, this.m_58900_().m_60808_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_()).forEach(as -> {
                if (as.m_20182_().equals((Object)this.armorStand.m_20182_())) {
                    as.m_142687_(Entity.RemovalReason.DISCARDED);
                }
            });
        }
    }

    public void sendArmorStandSyncMessageToClient(PacketDistributor.PacketTarget target) {
        if (this.armorStand != null) {
            LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageSendArmorStandID(this.f_58858_, this.armorStand.m_142049_()));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void receiveArmorStandID(BlockPos pos, int entityId) {
        Minecraft mc = Minecraft.m_91087_();
        BlockEntity be = mc.f_91073_.m_7702_(pos);
        if (be instanceof ArmorDisplayTraderBlockEntity) {
            ((ArmorDisplayTraderBlockEntity)be).armorStandEntityId = entityId;
        }
    }

    protected void validateArmorStandValues() {
        if (this.armorStand == null) {
            return;
        }
        this.armorStand.m_7678_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_(), (double)((float)this.f_58858_.m_123343_() + 0.5f), this.getStandRotation(), 0.0f);
        if (!this.armorStand.m_20147_()) {
            this.armorStand.m_20331_(true);
        }
        if (this.armorStand.m_20145_()) {
            this.armorStand.m_6842_(false);
        }
        if (!this.armorStand.f_19794_) {
            this.armorStand.m_20242_(true);
        }
        if (!this.armorStand.m_20067_()) {
            this.armorStand.m_20225_(true);
        }
        if (!this.armorStand.m_31677_() || !this.armorStand.m_31674_()) {
            CompoundTag compound = this.armorStand.m_20240_(new CompoundTag());
            if (!this.armorStand.m_31677_()) {
                compound.m_128379_("Marker", true);
            }
            if (!this.armorStand.m_31674_()) {
                compound.m_128379_("NoBasePlate", true);
            }
            this.armorStand.m_20258_(compound);
        }
    }

    public void destroyArmorStand() {
        if (this.armorStand != null) {
            this.armorStand.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        this.writeArmorStandData(compound);
        super.m_183515_(compound);
    }

    protected CompoundTag writeArmorStandData(CompoundTag compound) {
        if (this.armorStand != null) {
            compound.m_128362_("ArmorStand", this.armorStand.m_142081_());
        }
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("ArmorStand")) {
            this.armorStandID = compound.m_128342_("ArmorStand");
        }
        super.m_142466_(compound);
    }

    protected ArmorStand getArmorStand() {
        if (this.isServer()) {
            return this.getArmorStand(this.armorStandID);
        }
        Entity entity = this.f_58857_.m_6815_(this.armorStandEntityId);
        if (entity != null && entity instanceof ArmorStand) {
            return (ArmorStand)entity;
        }
        return null;
    }

    protected ArmorStand getArmorStand(UUID id) {
        Entity entity = null;
        if (this.f_58857_ instanceof ServerLevel) {
            entity = ((ServerLevel)this.f_58857_).m_8791_(id);
        }
        if (entity != null && entity instanceof ArmorStand) {
            return (ArmorStand)entity;
        }
        return null;
    }

    protected float getStandRotation() {
        Direction facing = Direction.NORTH;
        if (this.m_58900_().m_60734_() instanceof IRotatableBlock) {
            facing = ((IRotatableBlock)this.m_58900_().m_60734_()).getFacing(this.m_58900_());
        }
        if (facing == Direction.SOUTH) {
            return 180.0f;
        }
        if (facing == Direction.NORTH) {
            return 0.0f;
        }
        if (facing == Direction.WEST) {
            return -90.0f;
        }
        if (facing == Direction.EAST) {
            return 90.0f;
        }
        return 0.0f;
    }
}

