/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CoinJarBlockEntity
extends BlockEntity {
    public static int COIN_LIMIT = 64;
    List<ItemStack> storage = new ArrayList<ItemStack>();

    public List<ItemStack> getStorage() {
        return this.storage;
    }

    public CoinJarBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntities.COIN_JAR, pos, state);
    }

    public boolean addCoin(ItemStack coin) {
        if (this.getCurrentCount() >= COIN_LIMIT) {
            return false;
        }
        if (!MoneyUtil.isCoin(coin, false)) {
            return false;
        }
        boolean foundStack = false;
        for (int i = 0; i < this.storage.size() && !foundStack; ++i) {
            if (!InventoryUtil.ItemMatches(coin, this.storage.get(i)) || this.storage.get(i).m_41613_() >= this.storage.get(i).m_41741_()) continue;
            this.storage.get(i).m_41769_(1);
            foundStack = true;
        }
        if (!foundStack) {
            ItemStack newCoin = coin.m_41777_();
            newCoin.m_41764_(1);
            this.storage.add(newCoin);
        }
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeStorage(new CompoundTag()));
        }
        return true;
    }

    protected int getCurrentCount() {
        int count = 0;
        for (int i = 0; i < this.storage.size(); ++i) {
            count += this.storage.get(i).m_41613_();
        }
        return count;
    }

    public void m_183515_(CompoundTag compound) {
        this.writeStorage(compound);
        super.m_183515_(compound);
    }

    protected CompoundTag writeStorage(CompoundTag compound) {
        ListTag storageList = new ListTag();
        for (int i = 0; i < this.storage.size(); ++i) {
            storageList.add((Object)this.storage.get(i).m_41739_(new CompoundTag()));
        }
        compound.m_128365_("Coins", (Tag)storageList);
        return compound;
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListTag storageList = compound.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                this.storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
        super.m_142466_(compound);
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public void writeItemTag(ItemStack item) {
        CompoundTag compound = item.m_41784_();
        compound.m_128365_("JarData", (Tag)this.writeStorage(new CompoundTag()));
    }

    public void readItemTag(ItemStack item) {
        CompoundTag jarData;
        CompoundTag compound;
        if (item.m_41782_() && (compound = item.m_41783_()).m_128425_("JarData", 10) && (jarData = compound.m_128469_("JarData")).m_128441_("Coins")) {
            this.storage = new ArrayList<ItemStack>();
            ListTag storageList = jarData.m_128437_("Coins", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisItem = storageList.m_128728_(i);
                this.storage.add(ItemStack.m_41712_((CompoundTag)thisItem));
            }
        }
    }
}

