/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import io.github.lightman314.lightmanscurrency.crafting.RecipeValidator;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

@Mod.EventBusSubscriber
public class CoinMintBlockEntity
extends BlockEntity {
    SimpleContainer storage = new SimpleContainer(2);
    private final LazyOptional<IItemHandler> inventoryHandlerLazyOptional = LazyOptional.of(() -> new MintItemCapability(this));

    public SimpleContainer getStorage() {
        return this.storage;
    }

    private final List<CoinMintRecipe> getCoinMintRecipes() {
        if (this.f_58857_ != null) {
            return CoinMintBlockEntity.getCoinMintRecipes(this.f_58857_);
        }
        return Lists.newArrayList();
    }

    public static final List<CoinMintRecipe> getCoinMintRecipes(Level level) {
        return RecipeValidator.getValidRecipes(level).getCoinMintRecipes();
    }

    public CoinMintBlockEntity(BlockPos pos, BlockState state) {
        this(ModBlockEntities.COIN_MINT, pos, state);
    }

    protected CoinMintBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.storage.m_19164_(container -> this.m_6596_());
    }

    public void m_183515_(CompoundTag compound) {
        InventoryUtil.saveAllItems("Storage", compound, (Container)this.storage);
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.storage = InventoryUtil.loadAllItems("Storage", compound, 2);
        this.storage.m_19164_(container -> this.m_6596_());
    }

    public void dumpContents(Level world, BlockPos pos) {
        InventoryUtil.dumpContents(world, pos, (Container)this.storage);
    }

    public boolean validMintInput() {
        return !this.getMintOutput().m_41619_();
    }

    public boolean validMintInput(ItemStack item) {
        SimpleContainer tempInv = new SimpleContainer(1);
        tempInv.m_6836_(0, item);
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.m_5818_((Container)tempInv, this.f_58857_)) continue;
            return true;
        }
        return false;
    }

    public int validOutputSpace() {
        ItemStack mintOutput = this.getMintOutput();
        ItemStack currentOutputSlot = this.getStorage().m_8020_(1);
        if (currentOutputSlot.m_41619_()) {
            return 64;
        }
        if (currentOutputSlot.m_41720_() != mintOutput.m_41720_()) {
            return 0;
        }
        return 64 - currentOutputSlot.m_41613_();
    }

    public ItemStack getMintOutput() {
        ItemStack mintInput = this.getStorage().m_8020_(0);
        if (mintInput.m_41619_()) {
            return ItemStack.f_41583_;
        }
        for (CoinMintRecipe recipe : this.getCoinMintRecipes()) {
            if (!recipe.m_5818_((Container)this.storage, this.f_58857_)) continue;
            return recipe.m_5874_((Container)this.storage).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getMintableOutput() {
        ItemStack output = this.getMintOutput();
        int countPerMint = output.m_41613_();
        int outputSpace = this.validOutputSpace();
        for (int inputCount = this.storage.m_8020_(0).m_41613_() - 1; output.m_41613_() + countPerMint <= outputSpace && inputCount > 0; --inputCount) {
            output.m_41769_(countPerMint);
        }
        return output;
    }

    public void mintCoins(int mintCount) {
        if (!this.validMintInput()) {
            return;
        }
        if (mintCount > this.getStorage().m_8020_(0).m_41613_()) {
            mintCount = this.getStorage().m_8020_(0).m_41613_();
        }
        if (mintCount > this.validOutputSpace()) {
            mintCount = this.validOutputSpace();
        }
        if (mintCount <= 0) {
            return;
        }
        ItemStack mintOutput = this.getMintOutput();
        mintOutput.m_41764_(mintCount);
        if (this.getStorage().m_8020_(1).m_41619_()) {
            this.getStorage().m_6836_(1, mintOutput);
        } else {
            this.getStorage().m_8020_(1).m_41764_(this.getStorage().m_8020_(1).m_41613_() + mintOutput.m_41613_());
        }
        this.getStorage().m_8020_(0).m_41764_(this.getStorage().m_8020_(0).m_41613_() - mintCount);
        this.m_6596_();
    }

    public void onLoad() {
        if (this.f_58857_.f_46443_) {
            BlockEntityUtil.requestUpdatePacket(this);
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187480_();
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryHandlerLazyOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryHandlerLazyOptional.invalidate();
    }

    public static class MintItemCapability
    implements IItemHandler {
        final CoinMintBlockEntity tileEntity;

        public MintItemCapability(CoinMintBlockEntity tileEntity) {
            this.tileEntity = tileEntity;
        }

        public int getSlots() {
            return this.tileEntity.getStorage().m_6643_();
        }

        public ItemStack getStackInSlot(int slot) {
            if (slot == 1 && this.tileEntity.getStorage().m_8020_(1).m_41619_() && !this.tileEntity.getMintOutput().m_41619_()) {
                return this.tileEntity.getMintableOutput();
            }
            return this.tileEntity.getStorage().m_8020_(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            if (slot != 0) {
                return stack.m_41777_();
            }
            if (!this.tileEntity.validMintInput(stack)) {
                return stack.m_41777_();
            }
            ItemStack currentStack = this.tileEntity.getStorage().m_8020_(0);
            if (currentStack.m_41619_()) {
                if (stack.m_41613_() > stack.m_41741_()) {
                    if (!simulate) {
                        ItemStack placeStack = stack.m_41777_();
                        placeStack.m_41764_(stack.m_41741_());
                        this.tileEntity.getStorage().m_6836_(0, placeStack);
                    }
                    ItemStack leftoverStack = stack.m_41777_();
                    leftoverStack.m_41764_(stack.m_41613_() - stack.m_41741_());
                    return leftoverStack;
                }
                if (!simulate) {
                    this.tileEntity.getStorage().m_6836_(0, stack.m_41777_());
                }
                return ItemStack.f_41583_;
            }
            if (InventoryUtil.ItemMatches(currentStack, stack)) {
                int newAmount = MathUtil.clamp(currentStack.m_41613_() + stack.m_41613_(), 0, currentStack.m_41741_());
                if (!simulate) {
                    ItemStack newStack = currentStack.m_41777_();
                    newStack.m_41764_(newAmount);
                    this.tileEntity.getStorage().m_6836_(0, newStack);
                }
                ItemStack leftoverStack = stack.m_41777_();
                leftoverStack.m_41764_(stack.m_41613_() + currentStack.m_41613_() - newAmount);
                return leftoverStack;
            }
            return stack.m_41777_();
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot != 1) {
                return ItemStack.f_41583_;
            }
            amount = MathUtil.clamp(amount, 0, 64);
            ItemStack currentStack = this.tileEntity.getStorage().m_8020_(1).m_41777_();
            if (currentStack.m_41619_() || currentStack.m_41613_() < amount) {
                int mintAmount = Math.min(this.tileEntity.getMintableOutput().m_41613_(), amount - currentStack.m_41613_());
                if (!simulate) {
                    if (mintAmount > 0) {
                        this.tileEntity.mintCoins(mintAmount);
                        currentStack = this.tileEntity.getStorage().m_8020_(1).m_41777_();
                    }
                } else if (mintAmount > 0) {
                    if (currentStack.m_41619_()) {
                        currentStack = this.tileEntity.getMintOutput();
                        currentStack.m_41764_(mintAmount);
                    } else {
                        currentStack.m_41769_(mintAmount);
                    }
                }
            }
            if (currentStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            ItemStack outputStack = currentStack.m_41777_();
            if (outputStack.m_41613_() > amount) {
                outputStack.m_41764_(amount);
            }
            if (!simulate) {
                currentStack.m_41764_(currentStack.m_41613_() - outputStack.m_41613_());
                if (currentStack.m_41613_() <= 0) {
                    currentStack = ItemStack.f_41583_;
                }
                this.tileEntity.getStorage().m_6836_(1, currentStack);
            }
            return outputStack;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot == 0 ? this.tileEntity.validMintInput(stack) : false;
        }
    }
}

