/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.traderblocks;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.interfaces.IRotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.templates.TraderBlockRotatable;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.items.tooltips.LCTooltips;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;

public class CardDisplayBlock
extends TraderBlockRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 4;

    public CardDisplayBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Override
    protected BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new ItemTraderBlockEntity(pos, state, 4);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return ModBlockEntities.ITEM_TRADER;
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isBlock, boolean isDoubleTrade) {
        Direction facing = this.getFacing(state);
        Vector3f forward = IRotatableBlock.getForwardVect(facing);
        Vector3f right = IRotatableBlock.getRightVect(facing);
        Vector3f up = Vector3f.f_122225_;
        Vector3f offset = IRotatableBlock.getOffsetVect(facing);
        Vector3f firstPosition = null;
        if (tradeSlot == 0) {
            rightOffset = MathUtil.VectorMult(right, 0.3125f);
            vertOffset = MathUtil.VectorMult(up, 0.5625f);
            forwardOffset = MathUtil.VectorMult(forward, 0.28125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 1) {
            rightOffset = MathUtil.VectorMult(right, 0.6875f);
            vertOffset = MathUtil.VectorMult(up, 0.5625f);
            forwardOffset = MathUtil.VectorMult(forward, 0.28125f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 2) {
            rightOffset = MathUtil.VectorMult(right, 0.3125f);
            vertOffset = MathUtil.VectorMult(up, 0.75f);
            forwardOffset = MathUtil.VectorMult(forward, 0.75f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        } else if (tradeSlot == 3) {
            rightOffset = MathUtil.VectorMult(right, 0.6875f);
            vertOffset = MathUtil.VectorMult(up, 0.75f);
            forwardOffset = MathUtil.VectorMult(forward, 0.75f);
            firstPosition = MathUtil.VectorAdd(offset, forwardOffset, rightOffset, vertOffset);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>(3);
        if (firstPosition != null) {
            float deltaDist;
            posList.add(firstPosition);
            float f = isBlock ? (isDoubleTrade ? 1.6f : 3.2f) : 0.5f;
            for (float distance = deltaDist = (v7536); distance < 4.0f; distance += deltaDist) {
                posList.add(MathUtil.VectorAdd(firstPosition, MathUtil.VectorMult(up, distance / 16.0f)));
            }
        } else {
            posList.add(new Vector3f(0.0f, 1.0f, 0.0f));
        }
        return posList;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state, boolean isBlock) {
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        int facing = this.getFacing(state).m_122416_();
        rotation.add(Vector3f.f_122225_.m_122240_((float)facing * -90.0f));
        rotation.add(Vector3f.f_122223_.m_122240_(90.0f));
        return rotation;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot, BlockState state, boolean isBlock) {
        return 0.4f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return 4;
    }

    @Override
    public Direction getRelativeSide(BlockState state, Direction side) {
        return ItemInterfaceBlockEntity.IItemHandlerBlock.getRelativeSide(this.getFacing(state), side);
    }

    @Override
    public ItemInterfaceBlockEntity.IItemHandlerBlockEntity getItemHandlerEntity(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof ItemInterfaceBlockEntity.IItemHandlerBlockEntity) {
            return (ItemInterfaceBlockEntity.IItemHandlerBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER;
    }
}

