/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.TraderInterfaceClientTab;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.common.util.NonNullSupplier;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class TraderInterfaceScreen
extends AbstractContainerScreen<TraderInterfaceMenu>
implements TraderStorageMenu.IClientMessage {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader_interface.png");
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    Map<Integer, TraderInterfaceClientTab<?>> availableTabs = new HashMap();
    Map<Integer, TabButton> tabButtons = new HashMap<Integer, TabButton>();
    List<AbstractWidget> tabRenderables = new ArrayList<AbstractWidget>();
    List<GuiEventListener> tabListeners = new ArrayList<GuiEventListener>();
    IconButton modeToggle;
    IconButton onlineModeToggle;

    public TraderInterfaceClientTab<?> currentTab() {
        return this.availableTabs.get(((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex());
    }

    public TraderInterfaceScreen(TraderInterfaceMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        ((TraderInterfaceMenu)this.f_97732_).getAllTabs().forEach((key, tab) -> this.availableTabs.put((Integer)key, tab.createClientTab(this)));
        this.f_97726_ = 206;
        this.f_97727_ = 236;
    }

    public void m_7856_() {
        super.m_7856_();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.tabButtons.clear();
        this.availableTabs.forEach((key, tab) -> {
            TabButton newButton = (TabButton)this.m_142416_((GuiEventListener)new TabButton(button -> this.changeTab((int)key), this.f_96547_, (TabButton.ITab)tab));
            if (key.intValue() == ((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex()) {
                newButton.f_93623_ = false;
            }
            this.tabButtons.put((Integer)key, newButton);
        });
        this.modeToggle = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_, this.f_97736_, this::ToggleMode, (NonNullSupplier<IconData>)((NonNullSupplier)() -> IconAndButtonUtil.GetIcon(((TraderInterfaceMenu)this.f_97732_).getBE().getMode())), (Button.OnTooltip)new IconAndButtonUtil.SuppliedTooltip((NonNullSupplier<Component>)((NonNullSupplier)() -> this.getMode().getDisplayText()))));
        this.onlineModeToggle = (IconButton)this.m_142416_((GuiEventListener)new IconButton(this.f_97735_ + this.f_97726_, this.f_97736_ + 20, this::ToggleOnlineMode, (NonNullSupplier<IconData>)((NonNullSupplier)() -> ((TraderInterfaceMenu)this.f_97732_).getBE().isOnlineMode() ? IconAndButtonUtil.ICON_ONLINEMODE_TRUE : IconAndButtonUtil.ICON_ONLINEMODE_FALSE), (Button.OnTooltip)new IconAndButtonUtil.SuppliedTooltip((NonNullSupplier<Component>)((NonNullSupplier)() -> new TranslatableComponent("gui.lightmanscurrency.interface.onlinemode." + ((TraderInterfaceMenu)this.f_97732_).getBE().isOnlineMode())))));
        this.currentTab().onOpen();
        this.m_181908_();
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        try {
            this.currentTab().renderBG(pose, mouseX, mouseY, partialTicks);
            this.tabRenderables.forEach(widget -> widget.m_6305_(pose, mouseX, mouseY, partialTicks));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab " + this.currentTab().getClass().getName(), e);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.f_169604_, 23.0f, (float)(this.f_97727_ - 94), 0x404040);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.m_7025_(pose, mouseX, mouseY);
        try {
            this.currentTab().renderTooltips(pose, mouseX, mouseY);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab tooltips " + this.currentTab().getClass().getName(), e);
        }
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, this.f_169369_);
        this.tabButtons.forEach((key, button) -> {
            if (button.m_5953_(mouseX, mouseY)) {
                this.m_96602_(pose, button.tab.getTooltip(), mouseX, mouseY);
            }
        });
    }

    public void m_181908_() {
        this.updateTabs();
        this.currentTab().tick();
    }

    private TraderInterfaceBlockEntity.ActiveMode getMode() {
        if (((TraderInterfaceMenu)this.f_97732_).getBE() != null) {
            return ((TraderInterfaceMenu)this.f_97732_).getBE().getMode();
        }
        return TraderInterfaceBlockEntity.ActiveMode.DISABLED;
    }

    private void ToggleMode(Button button) {
        ((TraderInterfaceMenu)this.f_97732_).changeMode(this.getMode().getNext());
    }

    private void ToggleOnlineMode(Button button) {
        ((TraderInterfaceMenu)this.f_97732_).setOnlineMode(!((TraderInterfaceMenu)this.f_97732_).getBE().isOnlineMode());
    }

    private void updateTabs() {
        int xPos = this.f_97735_ - 25;
        AtomicInteger index = new AtomicInteger(0);
        this.tabButtons.forEach((key, button) -> {
            TraderInterfaceClientTab<?> tab = this.availableTabs.get(key);
            button.f_93624_ = tab.tabButtonVisible();
            if (button.f_93624_) {
                int yPos = this.f_97736_ + 25 * index.get();
                button.reposition(xPos, yPos, 3);
                index.set(index.get() + 1);
            }
        });
    }

    public boolean m_7933_(int key, int scanCode, int mods) {
        if (this.currentTab().keyPressed(key, scanCode, mods)) {
            return true;
        }
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)key, (int)scanCode);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.m_7933_(key, scanCode, mods);
    }

    private TabButton getTabButton(int key) {
        if (this.tabButtons.containsKey(key)) {
            return this.tabButtons.get(key);
        }
        return null;
    }

    public void changeTab(int newTab) {
        this.changeTab(newTab, true, null);
    }

    public void changeTab(int newTab, boolean sendMessage, CompoundTag selfMessage) {
        if (newTab == ((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex()) {
            return;
        }
        int oldTab = ((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex();
        this.currentTab().onClose();
        TabButton button = this.getTabButton(((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex());
        if (button != null) {
            button.f_93623_ = true;
        }
        this.tabRenderables.clear();
        this.tabListeners.clear();
        ((TraderInterfaceMenu)this.f_97732_).changeTab(newTab);
        button = this.getTabButton(((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex());
        if (button != null) {
            button.f_93623_ = false;
        }
        if (selfMessage != null) {
            this.currentTab().receiveSelfMessage(selfMessage);
        }
        this.currentTab().onOpen();
        if (oldTab != ((TraderInterfaceMenu)this.f_97732_).getCurrentTabIndex() && sendMessage) {
            ((TraderInterfaceMenu)this.f_97732_).sendMessage(((TraderInterfaceMenu)this.f_97732_).createTabChangeMessage(newTab, null));
        }
    }

    @Override
    public void selfMessage(CompoundTag message) {
        if (message.m_128425_("ChangeTab", 3)) {
            this.changeTab(message.m_128451_("ChangeTab"), false, message);
        } else {
            this.currentTab().receiveSelfMessage(message);
        }
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabRenderables.add(widget);
        return widget;
    }

    public <T extends Widget> void removeRenderableTabWidget(T widget) {
        this.tabRenderables.remove(widget);
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public <T extends GuiEventListener> void removeTabListener(T listener) {
        this.tabListeners.remove(listener);
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabRenderables);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.currentTab().mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.currentTab().mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaMouseX, double deltaMouseY) {
        if (this.currentTab().mouseDragged(mouseX, mouseY, button, deltaMouseX, deltaMouseY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaMouseX, deltaMouseY);
    }

    public boolean m_5534_(char c, int code) {
        if (this.currentTab().charTyped(c, code)) {
            return true;
        }
        return super.m_5534_(c, code);
    }
}

