/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TradeButtonArea;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderMenu;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageExecuteTrade;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.ITraderSource;
import java.util.List;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraftforge.common.util.NonNullSupplier;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class TraderScreen
extends AbstractContainerScreen<TraderMenu> {
    public static final ResourceLocation GUI_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/trader.png");
    TradeButtonArea tradeDisplay;
    public static final int WIDTH = 206;
    public static final int HEIGHT = 236;
    Button buttonOpenStorage;
    Button buttonCollectCoins;
    Button buttonOpenTerminal;

    public TraderScreen(TraderMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        this.f_97726_ = 206;
        this.f_97727_ = 236;
    }

    public void m_7856_() {
        super.m_7856_();
        this.buttonOpenStorage = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.storageButton(this.f_97735_, this.f_97736_ - 20, this::OpenStorage, (NonNullSupplier<Boolean>)((NonNullSupplier)() -> ((TraderMenu)this.f_97732_).isSingleTrader() && ((TraderMenu)this.f_97732_).getSingleTrader().hasPermission(((TraderMenu)this.f_97732_).player, "openStorage"))));
        this.buttonCollectCoins = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.collectCoinButton(this.f_97735_ + 20, this.f_97736_ - 20, this::CollectCoins, ((TraderMenu)this.f_97732_).player, ((TraderMenu)this.f_97732_)::getSingleTrader));
        this.buttonOpenTerminal = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.backToTerminalButton(this.f_97735_ + 15 - 20, this.f_97736_ + this.f_97727_ - 20, this::OpenTerminal, (NonNullSupplier<Boolean>)((NonNullSupplier)((TraderMenu)this.f_97732_)::isUniversalTrader)));
        this.tradeDisplay = (TradeButtonArea)this.m_142416_((GuiEventListener)new TradeButtonArea(((TraderMenu)this.f_97732_).traderSource, ((TraderMenu)this.f_97732_)::getContext, this.f_97735_ + 3, this.f_97736_ + 17, this.f_97726_ - 6, 100, 2, x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.m_142416_((GuiEventListener)x$0);
        }, x$0 -> this.m_169411_((GuiEventListener)x$0), this::OnButtonPress, TradeButtonArea.FILTER_VALID));
        this.tradeDisplay.init();
        this.m_181908_();
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (Slot slot : ((TraderMenu)this.f_97732_).getCoinSlots()) {
            this.m_93228_(pose, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, this.f_97726_, 0, 18, 18);
        }
        if (((TraderMenu)this.f_97732_).getInteractionSlot().m_6659_()) {
            this.m_93228_(pose, this.f_97735_ + ((TraderMenu)this.f_97732_).getInteractionSlot().f_40220_ - 1, this.f_97736_ + ((TraderMenu)this.f_97732_).getInteractionSlot().f_40221_ - 1, this.f_97726_, 0, 18, 18);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.tradeDisplay.renderTraderName(pose, 8, 6, this.f_97726_ - 16, false);
        this.f_96547_.m_92889_(pose, this.f_169604_, 23.0f, (float)(this.f_97727_ - 94), 0x404040);
        String valueText = MoneyUtil.getStringOfValue(((TraderMenu)this.f_97732_).getContext(null).getAvailableFunds());
        this.f_96547_.m_92883_(pose, valueText, (float)(185 - this.f_96547_.m_92895_(valueText)), (float)(this.f_97727_ - 94), 0x404040);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(pose);
        this.tradeDisplay.getScrollBar().beforeWidgetRender(mouseY);
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.m_7025_(pose, mouseX, mouseY);
        if (((TraderMenu)this.f_97732_).m_142621_().m_41619_()) {
            this.tradeDisplay.renderTooltips((Screen)this, pose, this.f_97735_ + 8, this.f_97736_ + 6, this.f_97726_ - 16, mouseX, mouseY);
        }
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, this.f_169369_);
    }

    public void m_181908_() {
        this.tradeDisplay.tick();
    }

    private void OnButtonPress(ITrader trader, TradeButton.ITradeData trade) {
        if (trader == null || trade == null) {
            return;
        }
        ITraderSource ts = ((TraderMenu)this.f_97732_).traderSource.get();
        if (ts == null) {
            ((TraderMenu)this.f_97732_).player.m_6915_();
            return;
        }
        List<ITrader> traders = ts.getTraders();
        int ti = traders.indexOf(trader);
        if (ti < 0) {
            return;
        }
        ITrader t = traders.get(ti);
        if (t == null) {
            return;
        }
        int tradeIndex = t.getTradeInfo().indexOf(trade);
        if (tradeIndex < 0) {
            return;
        }
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageExecuteTrade(ti, tradeIndex));
    }

    private void OpenStorage(Button button) {
        if (((TraderMenu)this.f_97732_).isSingleTrader()) {
            ((TraderMenu)this.f_97732_).getSingleTrader().sendOpenStorageMessage();
        }
    }

    private void CollectCoins(Button button) {
        if (((TraderMenu)this.f_97732_).isSingleTrader()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        }
    }

    private void OpenTerminal(Button button) {
        if (((TraderMenu)this.f_97732_).isUniversalTrader()) {
            ((TraderMenu)this.f_97732_).player.m_6915_();
            LightmansCurrency.PROXY.openTerminalScreen();
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.tradeDisplay.getScrollBar().onMouseClicked(mouseX, mouseY, button);
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.tradeDisplay.getScrollBar().onMouseReleased(mouseX, mouseY, button);
        return super.m_6348_(mouseX, mouseY, button);
    }
}

