/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ILoggerSupport;
import io.github.lightman314.lightmanscurrency.api.TextLogger;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TraderSettingsScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TextLogWindow;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TabButton;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.TraderStorageClientTab;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageCollectCoins;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageStoreCoins;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import org.anti_ad.mc.ipn.api.IPNIgnore;

@IPNIgnore
public class TraderStorageScreen
extends AbstractContainerScreen<TraderStorageMenu>
implements TraderStorageMenu.IClientMessage {
    Map<Integer, TraderStorageClientTab<?>> availableTabs = new HashMap();
    Map<Integer, TabButton> tabButtons = new HashMap<Integer, TabButton>();
    Button buttonShowTrades;
    Button buttonCollectMoney;
    Button buttonOpenSettings;
    Button buttonStoreMoney;
    Button buttonShowLog;
    Button buttonClearLog;
    TextLogWindow logWindow;
    Button buttonTradeRules;
    List<AbstractWidget> tabRenderables = new ArrayList<AbstractWidget>();
    List<GuiEventListener> tabListeners = new ArrayList<GuiEventListener>();

    public TraderStorageClientTab<?> currentTab() {
        return this.availableTabs.get(((TraderStorageMenu)this.f_97732_).getCurrentTabIndex());
    }

    public TraderStorageScreen(TraderStorageMenu menu, Inventory inventory, Component title) {
        super((AbstractContainerMenu)menu, inventory, title);
        ((TraderStorageMenu)this.f_97732_).getAllTabs().forEach((key, tab) -> this.availableTabs.put((Integer)key, tab.createClientTab(this)));
        this.f_97726_ = 206;
        this.f_97727_ = 236;
    }

    public void m_7856_() {
        super.m_7856_();
        this.tabRenderables.clear();
        this.tabListeners.clear();
        this.tabButtons.clear();
        this.availableTabs.forEach((key, tab) -> {
            if (tab.tabButtonVisible()) {
                TabButton newButton = (TabButton)this.m_142416_((GuiEventListener)new TabButton(button -> this.changeTab((int)key), this.f_96547_, (TabButton.ITab)tab));
                if (key.intValue() == ((TraderStorageMenu)this.f_97732_).getCurrentTabIndex()) {
                    newButton.f_93623_ = false;
                }
                this.tabButtons.put((Integer)key, newButton);
            }
        });
        int xPos = this.f_97735_ - 25;
        AtomicInteger index = new AtomicInteger(0);
        this.tabButtons.forEach((key, button) -> {
            int yPos = this.f_97736_ + 25 * index.get();
            button.reposition(xPos, yPos, 3);
            index.set(index.get() + 1);
        });
        this.buttonShowTrades = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.traderButton(this.f_97735_, this.f_97736_ - 20, this::PressTradesButton));
        this.buttonCollectMoney = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.collectCoinButton(this.f_97735_ + 20, this.f_97736_ - 20, this::PressCollectionButton, ((TraderStorageMenu)this.f_97732_).player, ((TraderStorageMenu)this.f_97732_)::getTrader));
        this.buttonCollectMoney.f_93624_ = ((TraderStorageMenu)this.f_97732_).hasPermission("collectCoins") && !((TraderStorageMenu)this.f_97732_).getTrader().getCoreSettings().hasBankAccount();
        this.buttonStoreMoney = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.storeCoinButton(this.f_97735_ + 15 + 176, this.f_97736_ + 118, this::PressStoreCoinsButton));
        this.buttonStoreMoney.f_93624_ = false;
        this.buttonOpenSettings = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.openSettingsButton(this.f_97735_ + this.f_97726_ - 20, this.f_97736_ - 20, this::PressSettingsButton));
        this.buttonOpenSettings.f_93624_ = ((TraderStorageMenu)this.f_97732_).hasPermission("editSettings");
        this.buttonTradeRules = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.tradeRuleButton(this.f_97735_ + this.f_97726_ - 40, this.f_97736_ - 20, this::PressTradeRulesButton));
        this.buttonTradeRules.f_93624_ = ((TraderStorageMenu)this.f_97732_).hasPermission("editTradeRules");
        if (((TraderStorageMenu)this.f_97732_).getTrader() instanceof ILoggerSupport) {
            this.buttonShowLog = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.showLoggerButton(this.f_97735_ + 40, this.f_97736_ - 20, this::PressLogButton, () -> this.logWindow.f_93624_));
            this.buttonClearLog = (Button)this.m_142416_((GuiEventListener)IconAndButtonUtil.clearLoggerButton(this.f_97735_ + 60, this.f_97736_ - 20, this::PressClearLogButton));
            this.logWindow = (TextLogWindow)this.m_7787_((GuiEventListener)IconAndButtonUtil.traderLogWindow(this, () -> (ILoggerSupport)((Object)((TraderStorageMenu)this.f_97732_).getTrader())));
            this.logWindow.f_93624_ = false;
        }
        this.currentTab().onOpen();
        this.m_181908_();
    }

    protected void m_7286_(PoseStack pose, float partialTicks, int mouseX, int mouseY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TraderScreen.GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.m_93228_(pose, this.f_97735_, this.f_97736_, 0, 0, this.f_97726_, this.f_97727_);
        for (Slot slot : ((TraderStorageMenu)this.f_97732_).getCoinSlots()) {
            if (!slot.m_6659_()) continue;
            this.m_93228_(pose, this.f_97735_ + slot.f_40220_ - 1, this.f_97736_ + slot.f_40221_ - 1, this.f_97726_, 0, 18, 18);
        }
        try {
            this.currentTab().renderBG(pose, mouseX, mouseY, partialTicks);
            this.tabRenderables.forEach(widget -> widget.m_6305_(pose, mouseX, mouseY, partialTicks));
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab " + this.currentTab().getClass().getName(), e);
        }
    }

    protected void m_7027_(PoseStack pose, int mouseX, int mouseY) {
        this.f_96547_.m_92889_(pose, this.f_169604_, 23.0f, (float)(this.f_97727_ - 94), 0x404040);
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (((TraderStorageMenu)this.f_97732_).getTrader() == null) {
            ((TraderStorageMenu)this.f_97732_).player.m_6915_();
            return;
        }
        this.m_7333_(pose);
        if (this.logWindow != null && this.logWindow.f_93624_) {
            this.logWindow.m_6305_(pose, mouseX, mouseY, partialTicks);
            this.buttonShowLog.m_6305_(pose, mouseX, mouseY, partialTicks);
            if (this.buttonClearLog.f_93624_) {
                this.buttonClearLog.m_6305_(pose, mouseX, mouseY, partialTicks);
            }
            IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonShowLog, this.buttonClearLog}));
            return;
        }
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
        this.m_7025_(pose, mouseX, mouseY);
        try {
            this.currentTab().renderTooltips(pose, mouseX, mouseY);
        }
        catch (Exception e) {
            LightmansCurrency.LogError("Error rendering trader storage tab tooltips " + this.currentTab().getClass().getName(), e);
        }
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, this.f_169369_);
        this.tabButtons.forEach((key, button) -> {
            if (button.m_5953_(mouseX, mouseY)) {
                this.m_96602_(pose, button.tab.getTooltip(), mouseX, mouseY);
            }
        });
    }

    public void m_181908_() {
        if (((TraderStorageMenu)this.f_97732_).getTrader() == null) {
            ((TraderStorageMenu)this.f_97732_).player.m_6915_();
            return;
        }
        if (!((TraderStorageMenu)this.f_97732_).hasPermission("openStorage")) {
            ((TraderStorageMenu)this.f_97732_).player.m_6915_();
            ((TraderStorageMenu)this.f_97732_).getTrader().sendOpenTraderMessage();
            return;
        }
        this.buttonOpenSettings.f_93624_ = ((TraderStorageMenu)this.f_97732_).hasPermission("editSettings");
        this.buttonTradeRules.f_93624_ = ((TraderStorageMenu)this.f_97732_).hasPermission("editTradeRules");
        boolean bl = this.buttonStoreMoney.f_93624_ = ((TraderStorageMenu)this.f_97732_).HasCoinsToAdd() && ((TraderStorageMenu)this.f_97732_).hasPermission("storeCoins");
        if (this.buttonClearLog != null && ((TraderStorageMenu)this.f_97732_).getTrader() instanceof ILoggerSupport) {
            this.buttonClearLog.f_93624_ = ((TextLogger)((ILoggerSupport)((Object)((TraderStorageMenu)this.f_97732_).getTrader())).getLogger()).logText.size() > 0 && ((TraderStorageMenu)this.f_97732_).hasPermission("clearLogs");
        }
        this.currentTab().tick();
    }

    public boolean m_7933_(int p_97765_, int p_97766_, int p_97767_) {
        InputConstants.Key mouseKey = InputConstants.m_84827_((int)p_97765_, (int)p_97766_);
        if (this.f_96541_.f_91066_.f_92092_.isActiveAndMatches(mouseKey) && this.currentTab().blockInventoryClosing()) {
            return true;
        }
        return super.m_7933_(p_97765_, p_97766_, p_97767_);
    }

    private TabButton getTabButton(int key) {
        if (this.tabButtons.containsKey(key)) {
            return this.tabButtons.get(key);
        }
        return null;
    }

    public void changeTab(int newTab) {
        this.changeTab(newTab, true, null);
    }

    public void changeTab(int newTab, boolean sendMessage, CompoundTag selfMessage) {
        if (newTab == ((TraderStorageMenu)this.f_97732_).getCurrentTabIndex()) {
            return;
        }
        int oldTab = ((TraderStorageMenu)this.f_97732_).getCurrentTabIndex();
        this.currentTab().onClose();
        TabButton button = this.getTabButton(((TraderStorageMenu)this.f_97732_).getCurrentTabIndex());
        if (button != null) {
            button.f_93623_ = true;
        }
        this.tabRenderables.clear();
        this.tabListeners.clear();
        ((TraderStorageMenu)this.f_97732_).changeTab(newTab);
        button = this.getTabButton(((TraderStorageMenu)this.f_97732_).getCurrentTabIndex());
        if (button != null) {
            button.f_93623_ = false;
        }
        if (selfMessage != null) {
            this.currentTab().receiveSelfMessage(selfMessage);
        }
        this.currentTab().onOpen();
        if (oldTab != ((TraderStorageMenu)this.f_97732_).getCurrentTabIndex() && sendMessage) {
            ((TraderStorageMenu)this.f_97732_).sendMessage(((TraderStorageMenu)this.f_97732_).createTabChangeMessage(newTab, null));
        }
    }

    @Override
    public void selfMessage(CompoundTag message) {
        if (message.m_128425_("ChangeTab", 3)) {
            this.changeTab(message.m_128451_("ChangeTab"), false, message);
        } else {
            this.currentTab().receiveSelfMessage(message);
        }
    }

    public <T extends AbstractWidget> T addRenderableTabWidget(T widget) {
        this.tabRenderables.add(widget);
        return widget;
    }

    public <T extends Widget> void removeRenderableTabWidget(T widget) {
        this.tabRenderables.remove(widget);
    }

    public <T extends GuiEventListener> T addTabListener(T listener) {
        this.tabListeners.add(listener);
        return listener;
    }

    public <T extends GuiEventListener> void removeTabListener(T listener) {
        this.tabListeners.remove(listener);
    }

    public List<? extends GuiEventListener> m_6702_() {
        List coreListeners = super.m_6702_();
        ArrayList listeners = Lists.newArrayList();
        for (int i = 0; i < coreListeners.size(); ++i) {
            listeners.add((GuiEventListener)coreListeners.get(i));
        }
        listeners.addAll(this.tabRenderables);
        listeners.addAll(this.tabListeners);
        return listeners;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.currentTab().mouseClicked(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (this.currentTab().mouseReleased(mouseX, mouseY, button)) {
            return true;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double deltaMouseX, double deltaMouseY) {
        if (this.currentTab().mouseDragged(mouseX, mouseY, button, deltaMouseX, deltaMouseY)) {
            return true;
        }
        return super.m_7979_(mouseX, mouseY, button, deltaMouseX, deltaMouseY);
    }

    private void PressTradesButton(Button button) {
        ((TraderStorageMenu)this.f_97732_).getTrader().sendOpenTraderMessage();
    }

    private void PressCollectionButton(Button button) {
        if (((TraderStorageMenu)this.f_97732_).hasPermission("collectCoins")) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageCollectCoins());
        } else {
            Settings.PermissionWarning(((TraderStorageMenu)this.f_97732_).player, "collect stored coins", "collectCoins");
        }
    }

    private void PressStoreCoinsButton(Button button) {
        if (((TraderStorageMenu)this.f_97732_).hasPermission("storeCoins")) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageStoreCoins());
        } else {
            Settings.PermissionWarning(((TraderStorageMenu)this.f_97732_).player, "store coins", "storeCoins");
        }
    }

    private void PressLogButton(Button button) {
        this.logWindow.f_93624_ = !this.logWindow.f_93624_;
    }

    private void PressClearLogButton(Button button) {
        ((TraderStorageMenu)this.f_97732_).getTrader().sendClearLogMessage();
    }

    private void PressTradeRulesButton(Button button) {
        ((TraderStorageMenu)this.f_97732_).player.m_6915_();
        Minecraft.m_91087_().m_91152_((Screen)new TradeRuleScreen(((TraderStorageMenu)this.f_97732_).getTrader().getRuleScreenHandler(this.currentTab().getTradeRuleTradeIndex())));
    }

    private void PressSettingsButton(Button button) {
        ((TraderStorageMenu)this.f_97732_).player.m_6915_();
        Minecraft.m_91087_().m_91152_((Screen)new TraderSettingsScreen((Supplier<ITrader>)((Supplier)((TraderStorageMenu)this.f_97732_)::getTrader), player -> ((TraderStorageMenu)this.f_97732_).getTrader().sendOpenStorageMessage()));
    }
}

