/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class TransferTab
extends ATMTab {
    CoinValueInput amountWidget;
    EditBox playerInput;
    TeamSelectWidget teamSelection;
    IconButton buttonToggleMode;
    Button buttonTransfer;
    UUID selectedTeam = null;
    boolean playerMode = true;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORE_COINS;
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.atm.transfer");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.m_6262_());
        ((ATMMenu)this.screen.m_6262_()).setMessage((Component)new TextComponent(""));
        this.amountWidget = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft(), this.screen.getGuiTop() - 69, (Component)new TranslatableComponent("gui.lightmanscurrency.bank.transfertip"), CoinValue.EMPTY, this.screen.getFont(), value -> {}, this.screen::addRenderableTabWidget));
        this.amountWidget.init();
        this.amountWidget.allowFreeToggle = false;
        this.buttonToggleMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize() - 30, this.screen.getGuiTop() + 10, this::ToggleMode, this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of(ItemRenderUtil.getAlexHead()), (Button.OnTooltip)new IconAndButtonUtil.ToggleTooltip(() -> this.playerMode, (Component)new TranslatableComponent("tooltip.lightmanscurrency.atm.transfer.mode.team"), (Component)new TranslatableComponent("tooltip.lightmanscurrency.atm.transfer.mode.player"))));
        this.playerInput = this.screen.addRenderableTabWidget(new EditBox(this.screen.getFont(), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 50, this.screen.getXSize() - 20, 20, (Component)new TextComponent("")));
        this.playerInput.f_93624_ = this.playerMode;
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 30, 2, TeamButton.Size.NORMAL, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.teamSelection.setVisible(!this.playerMode);
        this.buttonTransfer = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 72, this.screen.getXSize() - 20, 20, (Component)new TranslatableComponent(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team"), this::PressTransfer));
        this.buttonTransfer.f_93623_ = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        BankAccount.AccountReference source = ((ATMMenu)this.screen.m_6262_()).getAccountSource();
        Team blockTeam = null;
        if (source != null && source.accountType == BankAccount.AccountType.Team) {
            blockTeam = ClientTradingOffice.getTeam(source.id);
        }
        for (Team team : ClientTradingOffice.getTeamList()) {
            if (!team.hasBankAccount() || team == blockTeam) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam != null) {
            return ClientTradingOffice.getTeam(this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID().equals(this.selectedTeam)) {
                return;
            }
            this.selectedTeam = team.getID();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressTransfer(Button button) {
        if (this.playerMode) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferPlayer(this.playerInput.m_94155_(), this.amountWidget.getCoinValue()));
            this.playerInput.m_94144_("");
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        } else if (this.selectedTeam != null) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferTeam(this.selectedTeam, this.amountWidget.getCoinValue()));
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        }
    }

    private void ToggleMode(Button button) {
        this.playerMode = !this.playerMode;
        this.buttonTransfer.m_93666_((Component)new TranslatableComponent(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team"));
        this.teamSelection.setVisible(!this.playerMode);
        this.playerInput.f_93624_ = this.playerMode;
        this.buttonToggleMode.setIcon(this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of(ItemRenderUtil.getAlexHead()));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.screen.getFont().m_92889_(pose, this.getTooltip(), (float)this.screen.getGuiLeft() + 8.0f, (float)this.screen.getGuiTop() + 6.0f, 0x404040);
        TranslatableComponent balance = ((ATMMenu)this.screen.m_6262_()).getAccount() == null ? new TranslatableComponent("gui.lightmanscurrency.bank.null") : new TranslatableComponent("gui.lightmanscurrency.bank.balance", new Object[]{((ATMMenu)this.screen.m_6262_()).getAccount().getCoinStorage().getString("0")});
        this.screen.getFont().m_92889_(pose, (Component)balance, (float)this.screen.getGuiLeft() + 8.0f, (float)(this.screen.getGuiTop() + 18), 0x404040);
        RenderSystem.m_157456_((int)0, (ResourceLocation)ATMScreen.GUI_TEXTURE);
        this.screen.m_93228_(pose, this.screen.getGuiLeft() + 7, this.screen.getGuiTop() + 97, 7, 79, 162, 18);
        List lines = this.screen.getFont().m_92865_().m_92432_(((ATMMenu)this.screen.m_6262_()).getLastMessage().getString(), this.screen.getXSize() - 15, Style.f_131099_);
        for (int i = 0; i < lines.size(); ++i) {
            Font font = this.screen.getFont();
            String string = ((FormattedText)lines.get(i)).getString();
            float f = this.screen.getGuiLeft() + 7;
            int n = this.screen.getGuiTop() + 97;
            Objects.requireNonNull(this.screen.getFont());
            font.m_92883_(pose, string, f, (float)(n + 9 * i), 0x404040);
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleMode}));
    }

    @Override
    public void tick() {
        this.amountWidget.tick();
        if (this.playerMode) {
            this.playerInput.m_94120_();
            this.buttonTransfer.f_93623_ = !this.playerInput.m_94155_().isBlank() && this.amountWidget.getCoinValue().isValid();
        } else {
            Team team = this.selectedTeam();
            this.buttonTransfer.f_93623_ = team != null && team.hasBankAccount() && this.amountWidget.getCoinValue().isValid();
        }
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.m_6262_());
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.playerMode;
    }
}

