/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.traderinterface;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.blockentity.TraderInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradingTerminalScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.TraderInterfaceScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.UniversalTraderButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.menus.TraderInterfaceMenu;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.TraderInterfaceClientTab;
import io.github.lightman314.lightmanscurrency.menus.traderinterface.base.TraderSelectTab;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ItemLike;

public class TraderSelectClientTab
extends TraderInterfaceClientTab<TraderSelectTab> {
    EditBox searchField;
    Button buttonPreviousPage;
    Button buttonNextPage;
    List<UniversalTraderButton> traderButtons;
    private int page = 0;
    private List<UniversalTraderData> filteredTraderList = new ArrayList<UniversalTraderData>();

    public TraderSelectClientTab(TraderInterfaceScreen screen, TraderSelectTab tab) {
        super(screen, tab);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)ModBlocks.TERMINAL);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.interface.trader");
    }

    @Override
    public boolean blockInventoryClosing() {
        return true;
    }

    private List<UniversalTraderData> traderList() {
        List<UniversalTraderData> traderList = this.filterTraders(ClientTradingOffice.getTraderList());
        traderList.sort(TradingTerminalScreen.TERMINAL_SORTER);
        return traderList;
    }

    private List<UniversalTraderData> filterTraders(List<UniversalTraderData> allTraders) {
        ArrayList<UniversalTraderData> traders = new ArrayList<UniversalTraderData>();
        TraderInterfaceBlockEntity be = this.menu.getBE();
        if (be == null) {
            return traders;
        }
        TraderInterfaceBlockEntity.InteractionType interaction = be.getInteractionType();
        for (UniversalTraderData trader : allTraders) {
            if (!be.validTraderType(trader) || (!interaction.trades || !trader.hasValidTrade()) && (!interaction.requiresPermissions || !trader.hasPermission(this.menu.getBE().getOwner(), "interactionLink"))) continue;
            traders.add(trader);
        }
        return traders;
    }

    @Override
    public void onOpen() {
        this.searchField = this.screen.addRenderableTabWidget(new EditBox(this.font, this.screen.getGuiLeft() + 43, this.screen.getGuiTop() + 6, 101, 9, (Component)new TranslatableComponent("gui.lightmanscurrency.terminal.search")));
        this.searchField.m_94182_(false);
        this.searchField.m_94199_(32);
        this.searchField.m_94202_(0xFFFFFF);
        this.buttonPreviousPage = this.screen.addRenderableTabWidget(IconAndButtonUtil.leftButton(this.screen.getGuiLeft(), this.screen.getGuiTop() - 20, this::PreviousPage));
        this.buttonNextPage = this.screen.addRenderableTabWidget(IconAndButtonUtil.rightButton(this.screen.getGuiLeft() + this.screen.getXSize() - 20, this.screen.getGuiTop() - 20, this::NextPage));
        this.initTraderButtons(this.screen.getGuiLeft(), this.screen.getGuiTop());
        this.page = MathUtil.clamp(this.page, 0, this.pageLimit());
        this.tick();
        this.updateTraderList();
        UniversalTraderData selectedTrader = this.menu.getBE().getTrader();
        if (selectedTrader != null) {
            this.page = this.pageOf(selectedTrader);
            this.updateTraderButtons();
        }
    }

    private void initTraderButtons(int guiLeft, int guiTop) {
        this.traderButtons = new ArrayList<UniversalTraderButton>();
        for (int y = 0; y < 4; ++y) {
            UniversalTraderButton newButton = this.screen.addRenderableTabWidget(new UniversalTraderButton(guiLeft + 30, guiTop + 18 + y * 30, this::SelectTrader, this.font));
            this.traderButtons.add(newButton);
        }
    }

    @Override
    public void renderBG(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TraderInterfaceScreen.GUI_TEXTURE);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.screen.m_93228_(pose, this.screen.getGuiLeft() + 28, this.screen.getGuiTop() + 4, 0, 236, 117, 12);
    }

    @Override
    public void renderTooltips(PoseStack pose, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.searchField.m_94120_();
        this.buttonPreviousPage.f_93624_ = this.pageLimit() > 0;
        this.buttonPreviousPage.f_93623_ = this.page > 0;
        this.buttonNextPage.f_93624_ = this.pageLimit() > 0;
        this.buttonNextPage.f_93623_ = this.page < this.pageLimit();
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            UniversalTraderButton button = this.traderButtons.get(i);
            button.selected = button.getData() != null && button.getData() == ((TraderInterfaceMenu)this.screen.m_6262_()).getBE().getTrader();
        }
    }

    @Override
    public boolean charTyped(char c, int code) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_5534_(c, code)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean keyPressed(int key, int scanCode, int mods) {
        String s = this.searchField.m_94155_();
        if (this.searchField.m_7933_(key, scanCode, mods)) {
            if (!Objects.equals(s, this.searchField.m_94155_())) {
                this.updateTraderList();
            }
            return true;
        }
        return false;
    }

    private void PreviousPage(Button button) {
        if (this.page > 0) {
            --this.page;
            this.updateTraderButtons();
        }
    }

    private void NextPage(Button button) {
        if (this.page < this.pageLimit()) {
            ++this.page;
            this.updateTraderButtons();
        }
    }

    private void SelectTrader(Button button) {
        int index = this.getTraderIndex(button);
        if (index >= 0 && index < this.filteredTraderList.size()) {
            UUID traderID = this.filteredTraderList.get(index).getTraderID();
            ((TraderSelectTab)this.commonTab).setTrader(traderID);
        }
    }

    private int getTraderIndex(Button button) {
        if (!this.traderButtons.contains(button)) {
            return -1;
        }
        int index = this.traderButtons.indexOf(button);
        return index += this.page * this.traderButtons.size();
    }

    private int pageLimit() {
        return (this.filteredTraderList.size() - 1) / this.traderButtons.size();
    }

    private int pageOf(UniversalTraderData trader) {
        if (this.filteredTraderList != null) {
            int index = this.filteredTraderList.indexOf(trader);
            if (index >= 0) {
                return index / this.traderButtons.size();
            }
            return this.page;
        }
        return this.page;
    }

    private void updateTraderList() {
        this.filteredTraderList = TradingOffice.filterTraders(this.searchField.m_94155_(), this.traderList());
        this.updateTraderButtons();
        if (this.page > this.pageLimit()) {
            this.page = this.pageLimit();
        }
    }

    private void updateTraderButtons() {
        int startIndex = this.page * this.traderButtons.size();
        for (int i = 0; i < this.traderButtons.size(); ++i) {
            if (startIndex + i < this.filteredTraderList.size()) {
                this.traderButtons.get(i).SetData(this.filteredTraderList.get(startIndex + i));
                continue;
            }
            this.traderButtons.get(i).SetData(null);
        }
    }
}

