/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.settings;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.settings.SettingsTab;
import io.github.lightman314.lightmanscurrency.trader.permissions.PermissionsList;
import io.github.lightman314.lightmanscurrency.trader.permissions.options.PermissionOption;
import java.util.List;
import net.minecraft.network.chat.FormattedText;

public abstract class PermissionsTab
extends SettingsTab {
    List<PermissionOption.OptionWidgets> widgets = Lists.newArrayList();
    List<PermissionOption> options;

    protected abstract int startHeight();

    private int calculateStartHeight() {
        return this.getScreen().guiTop() + this.startHeight();
    }

    protected abstract PermissionsList getPermissionsList();

    @Override
    public void initTab() {
        this.options = Lists.newArrayList();
        this.getScreen().getSettings().forEach(setting -> setting.getPermissionOptions().forEach(option -> this.options.add((PermissionOption)option)));
        int startHeight = this.calculateStartHeight();
        for (int i = 0; i < this.options.size(); ++i) {
            int xPos = this.getXPos(i);
            int yPos = this.getYPosOffset(i) + startHeight;
            PermissionOption option = this.options.get(i);
            PermissionOption.OptionWidgets optionWidgets = option.initWidgets(this.getScreen(), this::getPermissionsList, xPos, yPos);
            optionWidgets.getRenderableWidgets().forEach(widget -> this.getScreen().addRenderableTabWidget(widget));
            optionWidgets.getListeners().forEach(listener -> this.getScreen().addTabListener(listener));
            this.widgets.add(optionWidgets);
        }
    }

    private final int getYPosOffset(int index) {
        int yIndex = index / 2;
        return 20 * yIndex;
    }

    private final int getXPos(int index) {
        return this.getScreen().guiLeft() + (index % 2 == 0 ? 5 : 105);
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        int startHeight = this.calculateStartHeight();
        for (int i = 0; i < this.options.size(); ++i) {
            PermissionOption option = this.options.get(i);
            int xPos = this.getXPos(i) + option.widgetWidth();
            int yPos = this.getYPosOffset(i) + startHeight;
            int textWidth = 90 - option.widgetWidth();
            int textHeight = this.getFont().m_92920_(option.widgetName().getString(), textWidth);
            int yStart = (20 - textHeight) / 2 + yPos;
            this.getFont().m_92857_((FormattedText)option.widgetName(), xPos, yStart, textWidth, 0xFFFFFF);
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
    }

    @Override
    public void tick() {
        for (int i = 0; i < this.options.size(); ++i) {
            this.options.get(i).tick();
        }
    }

    @Override
    public void closeTab() {
    }
}

