/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class TeamSelectWidget
extends AbstractWidget {
    private final int rows;
    private final TeamButton.Size size;
    private final java.util.function.Supplier<List<Team>> teamSource;
    private final java.util.function.Supplier<Team> selectedTeam;
    private final Consumer<Integer> onPress;
    private List<TeamButton> teamButtons = Lists.newArrayList();
    private int scroll = 0;

    public void setVisible(boolean visible) {
        this.f_93624_ = visible;
        this.teamButtons.forEach(button -> {
            button.f_93624_ = visible;
        });
    }

    public TeamSelectWidget(int x, int y, int rows, java.util.function.Supplier<List<Team>> teamSource, java.util.function.Supplier<Team> selectedTeam, Consumer<Integer> onPress) {
        this(x, y, rows, TeamButton.Size.WIDE, teamSource, selectedTeam, onPress);
    }

    public TeamSelectWidget(int x, int y, int rows, TeamButton.Size size, java.util.function.Supplier<List<Team>> teamSource, java.util.function.Supplier<Team> selectedTeam, Consumer<Integer> onPress) {
        super(x, y, size.width, 20 * rows, (Component)new TextComponent(""));
        this.rows = rows;
        this.size = size;
        this.teamSource = teamSource;
        this.selectedTeam = selectedTeam;
        this.onPress = onPress;
    }

    public void init(Consumer<Button> addButton, Font font) {
        for (int i = 0; i < this.rows; ++i) {
            int index = i;
            TeamButton button = new TeamButton(this.f_93620_, this.f_93621_ + i * 20, this.size, this::onTeamSelect, font, (Supplier<Team>)((Supplier)() -> this.getTeam(index)), (Supplier<Boolean>)((Supplier)() -> this.isSelected(index)));
            this.teamButtons.add(button);
            addButton.accept(button);
        }
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        if (!this.f_93624_) {
            return;
        }
        TeamSelectWidget.m_93172_((PoseStack)pose, (int)this.f_93620_, (int)this.f_93621_, (int)(this.f_93620_ + this.f_93618_), (int)(this.f_93621_ + this.f_93619_), (int)-16777216);
    }

    private Team getTeam(int index) {
        List<Team> teamList = this.teamSource.get();
        this.validateScroll(teamList.size());
        if ((index += this.scroll) >= 0 && index < teamList.size()) {
            return teamList.get(index);
        }
        return null;
    }

    private boolean isSelected(int index) {
        Team team = this.getTeam(index);
        if (team == null) {
            return false;
        }
        return team == this.selectedTeam.get();
    }

    private void validateScroll(int teamListSize) {
        this.scroll = MathUtil.clamp(this.scroll, 0, this.maxScroll(teamListSize));
    }

    private int maxScroll(int teamListSize) {
        return MathUtil.clamp(teamListSize - this.rows, 0, Integer.MAX_VALUE);
    }

    private boolean canScrollDown() {
        return this.scroll < this.maxScroll(this.teamSource.get().size());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (!this.f_93624_) {
            return false;
        }
        if (delta < 0.0) {
            if (!this.canScrollDown()) return false;
            ++this.scroll;
            return true;
        } else {
            if (!(delta > 0.0)) return true;
            if (this.scroll <= 0) return false;
            --this.scroll;
        }
        return true;
    }

    private void onTeamSelect(Button button) {
        int index = this.teamButtons.indexOf(button);
        if (index < 0) {
            return;
        }
        this.onPress.accept(this.scroll + index);
    }

    public void m_142291_(NarrationElementOutput narrator) {
    }

    protected boolean m_7972_(int button) {
        return false;
    }

    public void m_7435_(SoundManager soundManager) {
    }
}

