/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.widget.button;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;

@OnlyIn(value=Dist.CLIENT)
public class IconButton
extends Button {
    private NonNullSupplier<IconData> iconSource;
    private NonNullSupplier<Boolean> activeCheck = () -> this.f_93623_;
    private NonNullSupplier<Boolean> visibilityCheck = () -> this.f_93624_;

    public IconButton(int x, int y, Button.OnPress pressable, @Nonnull IconData icon) {
        super(x, y, 20, 20, (Component)new TextComponent(""), pressable);
        this.setIcon(icon);
    }

    public IconButton(int x, int y, Button.OnPress pressable, @Nonnull NonNullSupplier<IconData> iconSource) {
        super(x, y, 20, 20, (Component)new TextComponent(""), pressable);
        this.setIcon(iconSource);
    }

    public IconButton(int x, int y, Button.OnPress pressable, @Nonnull IconData icon, Button.OnTooltip tooltip) {
        super(x, y, 20, 20, (Component)new TextComponent(""), pressable, tooltip);
        this.setIcon(icon);
    }

    public IconButton(int x, int y, Button.OnPress pressable, @Nonnull NonNullSupplier<IconData> iconSource, Button.OnTooltip tooltip) {
        super(x, y, 20, 20, (Component)new TextComponent(""), pressable, tooltip);
        this.setIcon(iconSource);
    }

    @Deprecated
    public IconButton(int x, int y, Button.OnPress pressable, Font font, IconData icon) {
        this(x, y, pressable, icon);
    }

    @Deprecated
    public IconButton(int x, int y, Button.OnPress pressable, ResourceLocation iconResource, int resourceX, int resourceY) {
        super(x, y, 20, 20, (Component)new TextComponent(""), pressable);
        this.setIcon(IconData.of(iconResource, resourceX, resourceY));
    }

    public void setVisiblityCheck(NonNullSupplier<Boolean> visibilityCheck) {
        this.visibilityCheck = visibilityCheck == null ? () -> this.f_93624_ : visibilityCheck;
    }

    public void setActiveCheck(NonNullSupplier<Boolean> activeCheck) {
        this.activeCheck = activeCheck == null ? () -> this.f_93623_ : activeCheck;
    }

    @Deprecated
    public void setResource(ResourceLocation iconResource, int resourceX, int resourceY) {
        this.iconSource = () -> IconData.of(iconResource, resourceX, resourceY);
    }

    public void setIcon(@Nonnull IconData icon) {
        this.iconSource = () -> icon;
    }

    public void setIcon(@Nonnull NonNullSupplier<IconData> iconSource) {
        this.iconSource = iconSource;
    }

    public void m_6305_(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.f_93624_ = (Boolean)this.visibilityCheck.get();
        this.f_93623_ = (Boolean)this.activeCheck.get();
        super.m_6305_(pose, mouseX, mouseY, partialTicks);
    }

    public void m_6303_(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        RenderSystem.m_157456_((int)0, (ResourceLocation)f_93617_);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.m_69478_();
        RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        RenderSystem.m_69408_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        int offset = this.m_7202_(this.f_93622_);
        this.m_93228_(matrixStack, this.f_93620_, this.f_93621_, 0, 46 + offset * 20, this.f_93618_ / 2, this.f_93619_);
        this.m_93228_(matrixStack, this.f_93620_ + this.f_93618_ / 2, this.f_93621_, 200 - this.f_93618_ / 2, 46 + offset * 20, this.f_93618_ / 2, this.f_93619_);
        if (!this.f_93623_) {
            RenderSystem.m_157429_((float)0.5f, (float)0.5f, (float)0.5f, (float)1.0f);
        }
        ((IconData)this.iconSource.get()).render(matrixStack, (AbstractWidget)this, Minecraft.m_91087_().f_91062_, this.f_93620_ + 2, this.f_93621_ + 2);
    }
}

