/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.blockentity.ItemTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class ItemTraderBlockEntityRenderer
implements BlockEntityRenderer<ItemTraderBlockEntity> {
    public static int positionLimit() {
        switch ((Config.Client.TraderRenderType)((Object)Config.CLIENT.traderRenderType.get())) {
            case PARTIAL: {
                return 1;
            }
            case NONE: {
                return 0;
            }
        }
        return Integer.MAX_VALUE;
    }

    public ItemTraderBlockEntityRenderer(BlockEntityRendererProvider.Context dispatcher) {
    }

    public void render(ItemTraderBlockEntity blockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int lightLevel, int id) {
        ItemTraderBlockEntityRenderer.renderItems(blockEntity, partialTicks, pose, buffer, lightLevel, id);
    }

    public static List<ItemStack> GetRenderItems(ItemTradeData trade) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = trade.getSellItem(i);
            if (item.m_41619_()) continue;
            result.add(item);
        }
        return result;
    }

    public static boolean BlockSpacing(List<ItemStack> renderItems) {
        for (ItemStack stack : renderItems) {
            boolean isBlock = stack.m_41720_() instanceof BlockItem;
            if (isBlock && ((List)Config.CLIENT.renderBlocksAsItems.get()).contains(stack.m_41720_().getRegistryName().toString())) {
                isBlock = false;
            }
            if (!isBlock) continue;
            return true;
        }
        return false;
    }

    public static void renderItems(ItemTraderBlockEntity blockEntity, float partialTicks, PoseStack pose, MultiBufferSource buffer, int lightLevel, int id) {
        for (int tradeSlot = 0; tradeSlot < blockEntity.getTradeCount() && tradeSlot < blockEntity.maxRenderIndex(); ++tradeSlot) {
            ItemTradeData trade = blockEntity.getTrade(tradeSlot);
            List<ItemStack> renderItems = ItemTraderBlockEntityRenderer.GetRenderItems(trade);
            if (renderItems.size() <= 0) continue;
            boolean isBlock = ItemTraderBlockEntityRenderer.BlockSpacing(renderItems);
            List<Vector3f> positions = blockEntity.GetStackRenderPos(tradeSlot, isBlock, renderItems.size() > 1);
            List<Quaternion> rotation = blockEntity.GetStackRenderRot(tradeSlot, partialTicks, isBlock);
            float scale = blockEntity.GetStackRenderScale(tradeSlot, isBlock);
            for (int pos = 0; pos < positions.size() && pos < blockEntity.getTradeStock(tradeSlot) && pos < ItemTraderBlockEntityRenderer.positionLimit(); ++pos) {
                pose.m_85836_();
                Vector3f position = positions.get(pos);
                pose.m_85837_((double)position.m_122239_(), (double)position.m_122260_(), (double)position.m_122269_());
                for (Quaternion rot : rotation) {
                    pose.m_85845_(rot);
                }
                pose.m_85841_(scale, scale, scale);
                if (renderItems.size() > 1) {
                    pose.m_85836_();
                    pose.m_85837_(0.25, 0.25, 0.0);
                    pose.m_85841_(0.5f, 0.5f, 0.5f);
                    Minecraft.m_91087_().m_91291_().m_174269_(renderItems.get(0), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
                    pose.m_85849_();
                    pose.m_85836_();
                    pose.m_85837_(-0.25, -0.25, 0.001);
                    pose.m_85841_(0.5f, 0.5f, 0.5f);
                    Minecraft.m_91087_().m_91291_().m_174269_(renderItems.get(1), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
                    pose.m_85849_();
                } else {
                    Minecraft.m_91087_().m_91291_().m_174269_(renderItems.get(0), ItemTransforms.TransformType.FIXED, lightLevel, OverlayTexture.f_118083_, pose, buffer, id);
                }
                pose.m_85849_();
            }
        }
    }
}

