/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.common.capability;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.capability.CurrencyCapabilities;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;

public class WalletCapability {
    public static LazyOptional<IWalletHandler> getWalletHandler(@Nonnull Entity entity) {
        return entity.getCapability(CurrencyCapabilities.WALLET);
    }

    public static ICapabilityProvider createProvider(Player playerEntity) {
        return new Provider(playerEntity);
    }

    public static void WalletSlotInteraction(Player player, int clickedSlot, boolean heldShift, ItemStack heldItem) {
        IWalletHandler walletHandler;
        boolean creative;
        AbstractContainerMenu menu = player.f_36096_;
        if (menu == null) {
            return;
        }
        boolean bl = creative = player.m_7500_() && !player.f_19853_.f_46443_;
        if (!creative) {
            heldItem = menu.m_142621_();
        }
        if ((walletHandler = (IWalletHandler)WalletCapability.getWalletHandler((Entity)player).orElse(null)) == null) {
            LightmansCurrency.LogWarning("Attempted to do a wallet slot interaction, but the player has no wallet handler.");
            return;
        }
        if (clickedSlot < 0) {
            if (heldShift) {
                ItemStack wallet = walletHandler.getWallet();
                if (wallet.m_41619_()) {
                    return;
                }
                if (player.m_150109_().m_36062_() >= 0) {
                    if (!creative) {
                        player.m_150109_().m_36054_(wallet);
                    }
                    walletHandler.setWallet(ItemStack.f_41583_);
                }
            } else {
                ItemStack wallet = walletHandler.getWallet();
                if (wallet.m_41619_() && heldItem.m_41619_()) {
                    return;
                }
                if (WalletSlot.isValidWallet(heldItem) || heldItem.m_41619_()) {
                    walletHandler.setWallet(heldItem);
                    if (!creative) {
                        menu.m_142503_(wallet);
                    }
                }
            }
        } else if (heldShift) {
            Inventory inventory = player.m_150109_();
            if (clickedSlot >= inventory.m_6643_()) {
                LightmansCurrency.LogWarning("Clicked on slot " + clickedSlot + " of " + player.m_150109_().m_6643_() + " on the " + DebugUtil.getSideText((Entity)player));
                return;
            }
            ItemStack slotItem = inventory.m_8020_(clickedSlot);
            if (WalletSlot.isValidWallet(slotItem) && walletHandler.getWallet().m_41619_()) {
                if (!creative) {
                    if (slotItem.m_41613_() > 1) {
                        inventory.m_7407_(clickedSlot, 1);
                    } else {
                        inventory.m_6836_(clickedSlot, ItemStack.f_41583_);
                    }
                }
                ItemStack newWallet = slotItem.m_41777_();
                newWallet.m_41764_(1);
                walletHandler.setWallet(newWallet);
            }
        }
    }

    public static class Provider
    implements ICapabilitySerializable<Tag> {
        final LazyOptional<IWalletHandler> optional;
        final IWalletHandler handler;

        Provider(Player playerEntity) {
            this.handler = new WalletHandler((LivingEntity)playerEntity);
            this.optional = LazyOptional.of(() -> this.handler);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nullable Capability<T> capability, Direction facing) {
            return CurrencyCapabilities.WALLET.orEmpty(capability, this.optional);
        }

        public Tag serializeNBT() {
            return this.handler.writeTag();
        }

        public void deserializeNBT(Tag tag) {
            this.handler.readTag(tag);
        }
    }

    public static class WalletHandler
    implements IWalletHandler {
        final LivingEntity entity;
        ItemStack backupWallet;
        boolean visible;
        boolean wasVisible;
        final Container walletInventory;

        public WalletHandler() {
            this(null);
        }

        public WalletHandler(LivingEntity entity) {
            this.entity = entity;
            this.backupWallet = ItemStack.f_41583_;
            this.walletInventory = new SimpleContainer(1);
            this.visible = true;
            this.wasVisible = true;
        }

        @Override
        public Container getInventory() {
            return this.walletInventory;
        }

        @Override
        public ItemStack getWallet() {
            return this.walletInventory.m_8020_(0);
        }

        @Override
        public void setWallet(ItemStack walletStack) {
            this.walletInventory.m_6836_(0, walletStack);
            if (!(walletStack.m_41720_() instanceof WalletItem) && !walletStack.m_41619_()) {
                LightmansCurrency.LogWarning("Equipped a non-wallet to the players wallet slot.");
            }
        }

        @Override
        public boolean visible() {
            return this.visible;
        }

        @Override
        public void setVisible(boolean visible) {
            this.visible = visible;
        }

        @Override
        public LivingEntity getEntity() {
            return this.entity;
        }

        @Override
        public boolean isDirty() {
            return !InventoryUtil.ItemMatches(this.backupWallet, this.getWallet()) || this.backupWallet.m_41613_() != this.getWallet().m_41613_() || this.wasVisible != this.visible;
        }

        @Override
        public void clean() {
            this.backupWallet = this.getWallet().m_41777_();
            this.wasVisible = this.visible;
        }

        @Override
        public Tag writeTag() {
            CompoundTag compound = new CompoundTag();
            CompoundTag walletItem = this.getWallet().m_41739_(new CompoundTag());
            compound.m_128365_("Wallet", (Tag)walletItem);
            compound.m_128379_("Visible", this.visible);
            return compound;
        }

        @Override
        public void readTag(Tag tag) {
            if (tag instanceof CompoundTag) {
                CompoundTag compound = (CompoundTag)tag;
                ItemStack wallet = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Wallet"));
                this.setWallet(wallet);
                if (compound.m_128441_("Visible")) {
                    this.visible = compound.m_128471_("Visible");
                }
                this.clean();
            }
        }
    }
}

