/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import com.google.common.base.Supplier;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.blocks.ATMBlock;
import io.github.lightman314.lightmanscurrency.blocks.CashRegisterBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinJarBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinMintBlock;
import io.github.lightman314.lightmanscurrency.blocks.CoinpileBlock;
import io.github.lightman314.lightmanscurrency.blocks.ItemTraderServerBlock;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.blocks.TerminalBlock;
import io.github.lightman314.lightmanscurrency.blocks.TicketMachineBlock;
import io.github.lightman314.lightmanscurrency.blocks.tradeinterface.ItemTraderInterfaceBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.ArmorDisplayBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.CardDisplayBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.DisplayCaseBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.FreezerBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.ShelfBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.TicketKioskBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.VendingMachineBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.VendingMachineLargeBlock;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.items.CashRegisterItem;
import io.github.lightman314.lightmanscurrency.items.CoinBlockItem;
import io.github.lightman314.lightmanscurrency.items.CoinJarItem;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Material;
import net.minecraftforge.registries.ObjectHolder;
import net.minecraftforge.registries.RegistryObject;

@ObjectHolder(value="lightmanscurrency")
public class ModBlocks {
    public static final Block COINPILE_COPPER = null;
    public static final Block COINPILE_IRON = null;
    public static final Block COINPILE_GOLD = null;
    public static final Block COINPILE_DIAMOND = null;
    public static final Block COINPILE_EMERALD = null;
    public static final Block COINPILE_NETHERITE = null;
    public static final Block COINBLOCK_COPPER = null;
    public static final Block COINBLOCK_IRON = null;
    public static final Block COINBLOCK_GOLD = null;
    public static final Block COINBLOCK_EMERALD = null;
    public static final Block COINBLOCK_DIAMOND = null;
    public static final Block COINBLOCK_NETHERITE = null;
    @ObjectHolder(value="atm")
    public static final Block MACHINE_ATM = null;
    @ObjectHolder(value="coinmint")
    public static final Block MACHINE_MINT = null;
    public static final Block DISPLAY_CASE = null;
    public static final Block VENDING_MACHINE = null;
    public static final Block VENDING_MACHINE_ORANGE = null;
    public static final Block VENDING_MACHINE_MAGENTA = null;
    public static final Block VENDING_MACHINE_LIGHTBLUE = null;
    public static final Block VENDING_MACHINE_YELLOW = null;
    public static final Block VENDING_MACHINE_LIME = null;
    public static final Block VENDING_MACHINE_PINK = null;
    public static final Block VENDING_MACHINE_GRAY = null;
    public static final Block VENDING_MACHINE_LIGHTGRAY = null;
    public static final Block VENDING_MACHINE_CYAN = null;
    public static final Block VENDING_MACHINE_PURPLE = null;
    public static final Block VENDING_MACHINE_BLUE = null;
    public static final Block VENDING_MACHINE_BROWN = null;
    public static final Block VENDING_MACHINE_GREEN = null;
    public static final Block VENDING_MACHINE_RED = null;
    public static final Block VENDING_MACHINE_BLACK = null;
    public static final Block VENDING_MACHINE_LARGE = null;
    public static final Block VENDING_MACHINE_LARGE_ORANGE = null;
    public static final Block VENDING_MACHINE_LARGE_MAGENTA = null;
    public static final Block VENDING_MACHINE_LARGE_LIGHTBLUE = null;
    public static final Block VENDING_MACHINE_LARGE_YELLOW = null;
    public static final Block VENDING_MACHINE_LARGE_LIME = null;
    public static final Block VENDING_MACHINE_LARGE_PINK = null;
    public static final Block VENDING_MACHINE_LARGE_GRAY = null;
    public static final Block VENDING_MACHINE_LARGE_LIGHTGRAY = null;
    public static final Block VENDING_MACHINE_LARGE_CYAN = null;
    public static final Block VENDING_MACHINE_LARGE_PURPLE = null;
    public static final Block VENDING_MACHINE_LARGE_BLUE = null;
    public static final Block VENDING_MACHINE_LARGE_BROWN = null;
    public static final Block VENDING_MACHINE_LARGE_GREEN = null;
    public static final Block VENDING_MACHINE_LARGE_RED = null;
    public static final Block VENDING_MACHINE_LARGE_BLACK = null;
    public static final Block SHELF_OAK = null;
    public static final Block SHELF_BIRCH = null;
    public static final Block SHELF_SPRUCE = null;
    public static final Block SHELF_JUNGLE = null;
    public static final Block SHELF_ACACIA = null;
    public static final Block SHELF_DARK_OAK = null;
    public static final Block SHELF_CRIMSON = null;
    public static final Block SHELF_WARPED = null;
    public static final Block CARD_DISPLAY_OAK = null;
    public static final Block CARD_DISPLAY_BIRCH = null;
    public static final Block CARD_DISPLAY_SPRUCE = null;
    public static final Block CARD_DISPLAY_JUNGLE = null;
    public static final Block CARD_DISPLAY_ACACIA = null;
    public static final Block CARD_DISPLAY_DARK_OAK = null;
    public static final Block CARD_DISPLAY_CRIMSON = null;
    public static final Block CARD_DISPLAY_WARPED = null;
    public static final Block ARMOR_DISPLAY = null;
    public static final Block FREEZER = null;
    @ObjectHolder(value="item_trader_server_sml")
    public static final Block ITEM_TRADER_SERVER_SMALL = null;
    @ObjectHolder(value="item_trader_server_med")
    public static final Block ITEM_TRADER_SERVER_MEDIUM = null;
    @ObjectHolder(value="item_trader_server_lrg")
    public static final Block ITEM_TRADER_SERVER_LARGE = null;
    @ObjectHolder(value="item_trader_server_xlrg")
    public static final Block ITEM_TRADER_SERVER_EXTRA_LARGE = null;
    public static final Block ITEM_TRADER_INTERFACE = null;
    public static final Block CASH_REGISTER = null;
    public static final Block TERMINAL = null;
    public static final Block PAYGATE = null;
    public static final Block TICKET_KIOSK = null;
    public static final Block TICKET_MACHINE = null;
    public static final Block PIGGY_BANK = null;
    public static final Block COINJAR_BLUE = null;

    private static BiFunction<Block, CreativeModeTab, Item> getDefaultGenerator() {
        return (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new BlockItem(block, properties);
        };
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCoinGenerator(boolean fireResistant) {
        return (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            if (fireResistant) {
                properties.m_41486_();
            }
            return new CoinBlockItem((Block)block, properties);
        };
    }

    private static BiFunction<Block, CreativeModeTab, Item> getCoinJarGenerator() {
        return (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new CoinJarItem((Block)block, properties);
        };
    }

    public static void init() {
        ModBlocks.register("coinpile_copper", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_COPPER)));
        ModBlocks.register("coinpile_iron", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_IRON)));
        ModBlocks.register("coinpile_gold", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_GOLD)));
        ModBlocks.register("coinpile_emerald", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_EMERALD)));
        ModBlocks.register("coinpile_diamond", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_DIAMOND)));
        ModBlocks.register("coinpile_netherite", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(true), (Supplier<Block>)((Supplier)() -> new CoinpileBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_NETHERITE)));
        ModBlocks.register("coinblock_copper", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_COPPER)));
        ModBlocks.register("coinblock_iron", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_IRON)));
        ModBlocks.register("coinblock_gold", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_GOLD)));
        ModBlocks.register("coinblock_emerald", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_EMERALD)));
        ModBlocks.register("coinblock_diamond", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(false), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_DIAMOND)));
        ModBlocks.register("coinblock_netherite", LightmansCurrency.COIN_GROUP, ModBlocks.getCoinGenerator(true), (Supplier<Block>)((Supplier)() -> new CoinBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), ModItems.COIN_NETHERITE)));
        ModBlocks.register("atm", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new ATMBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("coinmint", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new CoinMintBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_))));
        ModBlocks.register("cash_register", LightmansCurrency.MACHINE_GROUP, (block, tab) -> {
            Item.Properties properties = new Item.Properties();
            if (tab != null) {
                properties.m_41491_(tab);
            }
            return new CashRegisterItem((Block)block, properties);
        }, (Supplier<Block>)((Supplier)() -> new CashRegisterBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)10.0, (double)15.0))));
        ModBlocks.register("display_case", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new DisplayCaseBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56744_))));
        ModBlocks.registerColored("vending_machine", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new VendingMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))), Reference.Color.WHITE);
        ModBlocks.registerColored("vending_machine_large", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new VendingMachineLargeBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))), Reference.Color.WHITE);
        ModBlocks.registerWooden("shelf", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ShelfBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, Float.POSITIVE_INFINITY))));
        ModBlocks.registerWooden("card_display", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new CardDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76320_).m_60913_(2.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56736_))));
        ModBlocks.register("freezer", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new FreezerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("armor_display", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ArmorDisplayBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("ticket_kiosk", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new TicketKioskBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("item_trader_server_sml", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 3)));
        ModBlocks.register("item_trader_server_med", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 6)));
        ModBlocks.register("item_trader_server_lrg", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 12)));
        ModBlocks.register("item_trader_server_xlrg", LightmansCurrency.TRADING_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderServerBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_), 16)));
        ModBlocks.register("item_trader_interface", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new ItemTraderInterfaceBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(5.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("terminal", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new TerminalBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_), Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0))));
        ModBlocks.register("paygate", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new PaygateBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, Float.POSITIVE_INFINITY).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("ticket_machine", LightmansCurrency.MACHINE_GROUP, (Supplier<Block>)((Supplier)() -> new TicketMachineBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60913_(3.0f, 6.0f).m_60918_(SoundType.f_56743_))));
        ModBlocks.register("piggy_bank", CreativeModeTab.f_40750_, ModBlocks.getCoinJarGenerator(), (Supplier<Block>)((Supplier)() -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0))));
        ModBlocks.register("coinjar_blue", CreativeModeTab.f_40750_, ModBlocks.getCoinJarGenerator(), (Supplier<Block>)((Supplier)() -> new CoinJarBlock(BlockBehaviour.Properties.m_60939_((Material)Material.f_76278_).m_60913_(0.1f, 2.0f).m_60918_(SoundType.f_56742_), Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)8.0, (double)12.0))));
    }

    private static void register(String name, CreativeModeTab itemGroup, Supplier<Block> sup) {
        ModBlocks.register(name, itemGroup, ModBlocks.getDefaultGenerator(), sup);
    }

    private static void register(String name, CreativeModeTab itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> sup) {
        RegistryObject block = ModRegistries.BLOCKS.register(name, sup);
        if (block != null) {
            ModRegistries.ITEMS.register(name, () -> (Item)itemGenerator.apply((Block)block.get(), itemGroup));
        }
    }

    private static void registerColored(String name, CreativeModeTab itemGroup, Supplier<Block> block, @Nullable Reference.Color dontNameThisColor) {
        ModBlocks.registerColored(name, itemGroup, ModBlocks.getDefaultGenerator(), block, dontNameThisColor);
    }

    private static void registerColored(String name, CreativeModeTab itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> block, @Nullable Reference.Color dontNameThisColor) {
        for (Reference.Color color : Reference.Color.values()) {
            Object thisName = name;
            if (color != dontNameThisColor) {
                thisName = (String)thisName + "_" + color.toString().toLowerCase();
            }
            ModBlocks.register((String)thisName, itemGroup, itemGenerator, block);
        }
    }

    private static void registerWooden(String name, CreativeModeTab itemGroup, Supplier<Block> block) {
        ModBlocks.registerWooden(name, itemGroup, ModBlocks.getDefaultGenerator(), block);
    }

    private static void registerWooden(String name, CreativeModeTab itemGroup, BiFunction<Block, CreativeModeTab, Item> itemGenerator, Supplier<Block> block) {
        for (Reference.WoodType woodType : Reference.WoodType.values()) {
            String thisName = name + "_" + woodType.toString().toLowerCase();
            ModBlocks.register(thisName, itemGroup, itemGenerator, block);
        }
    }

    public static class Groups {
        public static ItemLike[] getVendingMachineList() {
            return new ItemLike[]{VENDING_MACHINE, VENDING_MACHINE_ORANGE, VENDING_MACHINE_MAGENTA, VENDING_MACHINE_LIGHTBLUE, VENDING_MACHINE_YELLOW, VENDING_MACHINE_LIME, VENDING_MACHINE_PINK, VENDING_MACHINE_GRAY, VENDING_MACHINE_LIGHTGRAY, VENDING_MACHINE_CYAN, VENDING_MACHINE_PURPLE, VENDING_MACHINE_BLUE, VENDING_MACHINE_BROWN, VENDING_MACHINE_GREEN, VENDING_MACHINE_RED, VENDING_MACHINE_BLACK};
        }

        public static ItemLike[] getLargeVendingMachineList() {
            return new ItemLike[]{VENDING_MACHINE_LARGE, VENDING_MACHINE_LARGE_ORANGE, VENDING_MACHINE_LARGE_MAGENTA, VENDING_MACHINE_LARGE_LIGHTBLUE, VENDING_MACHINE_LARGE_YELLOW, VENDING_MACHINE_LARGE_LIME, VENDING_MACHINE_LARGE_PINK, VENDING_MACHINE_LARGE_GRAY, VENDING_MACHINE_LARGE_LIGHTGRAY, VENDING_MACHINE_LARGE_CYAN, VENDING_MACHINE_LARGE_PURPLE, VENDING_MACHINE_LARGE_BLUE, VENDING_MACHINE_LARGE_BROWN, VENDING_MACHINE_LARGE_GREEN, VENDING_MACHINE_LARGE_RED, VENDING_MACHINE_LARGE_BLACK};
        }
    }
}

