/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.core;

import io.github.lightman314.lightmanscurrency.enchantments.CoinMagnetEnchantment;
import io.github.lightman314.lightmanscurrency.enchantments.MoneyMendingEnchantment;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="lightmanscurrency", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModEnchantments {
    private static final List<Enchantment> ENCHANTMENTS = new ArrayList<Enchantment>();
    public static final MoneyMendingEnchantment MONEY_MENDING = ModEnchantments.register("money_mending", new MoneyMendingEnchantment(Enchantment.Rarity.RARE, EquipmentSlot.values()));
    public static final CoinMagnetEnchantment COIN_MAGNET = ModEnchantments.register("coin_magnet", new CoinMagnetEnchantment(Enchantment.Rarity.COMMON, EquipmentSlot.values()));

    private static <T extends Enchantment> T register(String name, T enchantment) {
        enchantment.setRegistryName(name);
        ENCHANTMENTS.add(enchantment);
        return enchantment;
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        ENCHANTMENTS.forEach(enchantment -> event.getRegistry().register((IForgeRegistryEntry)enchantment));
        ENCHANTMENTS.clear();
    }
}

