/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.crafting;

import com.google.gson.JsonElement;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.crafting.RecipeTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CoinMintRecipe
implements Recipe<Container> {
    private ResourceLocation id;
    private MintType type;
    private Ingredient ingredient;
    private Item result;

    public static MintType readType(JsonElement json) {
        try {
            return CoinMintRecipe.readType(json.getAsString());
        }
        catch (Exception e) {
            e.printStackTrace();
            return MintType.OTHER;
        }
    }

    public static MintType readType(String typeName) {
        for (MintType type : MintType.values()) {
            if (!type.name().equals(typeName)) continue;
            return type;
        }
        return MintType.OTHER;
    }

    public CoinMintRecipe(ResourceLocation id, MintType type, Ingredient ingredient, ItemLike result) {
        this.id = id;
        this.type = type;
        this.ingredient = ingredient;
        this.result = result.m_5456_();
    }

    public Ingredient getIngredient() {
        return this.ingredient;
    }

    public ItemStack getResult() {
        if (this.isValid()) {
            return new ItemStack((ItemLike)this.result);
        }
        return ItemStack.f_41583_;
    }

    public MintType getMintType() {
        return this.type;
    }

    public boolean allowed() {
        if (this.type == MintType.MINT) {
            return (Boolean)Config.SERVER.allowCoinMinting.get() != false && Config.canMint(this.result);
        }
        if (this.type == MintType.MELT) {
            try {
                return (Boolean)Config.SERVER.allowCoinMelting.get() != false && Config.canMelt(this.ingredient.m_43908_()[0].m_41720_());
            }
            catch (Exception e) {
                return false;
            }
        }
        return true;
    }

    public boolean isValid() {
        return !this.ingredient.m_43947_() && this.result.m_5456_() != Items.f_41852_ && this.allowed();
    }

    public boolean m_5818_(Container inventory, Level level) {
        if (!this.isValid()) {
            return false;
        }
        ItemStack firstStack = inventory.m_8020_(0);
        return this.ingredient.test(firstStack);
    }

    public ItemStack m_5874_(Container inventory) {
        return this.getResult();
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack m_8043_() {
        return this.getResult();
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.COIN_MINT;
    }

    public RecipeType<?> m_6671_() {
        return RecipeTypes.COIN_MINT;
    }

    public static enum MintType {
        MINT,
        MELT,
        OTHER;

    }
}

