/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.datagen;

import com.google.gson.JsonObject;
import io.github.lightman314.lightmanscurrency.core.ModRecipes;
import io.github.lightman314.lightmanscurrency.crafting.CoinMintRecipe;
import java.util.function.Consumer;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;

public class CoinMintRecipeBuilder {
    private final RecipeSerializer<?> serializer;
    private final CoinMintRecipe.MintType type;
    private final Ingredient ingredient;
    private final Item result;

    public CoinMintRecipeBuilder(RecipeSerializer<?> serializer, CoinMintRecipe.MintType type, Ingredient ingredient, ItemLike result) {
        this.serializer = serializer;
        this.type = type;
        this.ingredient = ingredient;
        this.result = result.m_5456_();
    }

    public static CoinMintRecipeBuilder minting(Ingredient ingredient, ItemLike result) {
        return new CoinMintRecipeBuilder(ModRecipes.COIN_MINT, CoinMintRecipe.MintType.MINT, ingredient, result);
    }

    public static CoinMintRecipeBuilder melting(Ingredient ingredient, ItemLike result) {
        return new CoinMintRecipeBuilder(ModRecipes.COIN_MINT, CoinMintRecipe.MintType.MELT, ingredient, result);
    }

    public static CoinMintRecipeBuilder other(Ingredient ingredient, ItemLike result) {
        return new CoinMintRecipeBuilder(ModRecipes.COIN_MINT, CoinMintRecipe.MintType.OTHER, ingredient, result);
    }

    public void save(Consumer<FinishedRecipe> consumer, String name) {
        this.save(consumer, new ResourceLocation(name));
    }

    public void save(Consumer<FinishedRecipe> consumer, ResourceLocation id) {
        consumer.accept(new Result(id, this.serializer, this.type, this.ingredient, this.result));
    }

    public static class Result
    implements FinishedRecipe {
        private final ResourceLocation id;
        private final RecipeSerializer<?> serializer;
        private final CoinMintRecipe.MintType type;
        private final Ingredient ingredient;
        private final Item result;

        private Result(ResourceLocation id, RecipeSerializer<?> serializer, CoinMintRecipe.MintType type, Ingredient ingredient, Item result) {
            this.id = id;
            this.serializer = serializer;
            this.type = type;
            this.ingredient = ingredient;
            this.result = result;
        }

        public void m_7917_(JsonObject object) {
            object.addProperty("mintType", this.type.name());
            object.add("ingredient", this.ingredient.m_43942_());
            object.addProperty("result", this.result.getRegistryName().toString());
        }

        public ResourceLocation m_6445_() {
            return this.id;
        }

        public RecipeSerializer<?> m_6637_() {
            return this.serializer;
        }

        public JsonObject m_5860_() {
            return null;
        }

        public ResourceLocation m_6448_() {
            return null;
        }
    }
}

