/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.enchantments;

import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CurrencySoundEvents;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.core.ModEnchantments;
import io.github.lightman314.lightmanscurrency.enchantments.LCEnchantmentCategories;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.WalletMenu;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;

public class CoinMagnetEnchantment
extends Enchantment {
    public static final int MAX_LEVEL = 3;

    public CoinMagnetEnchantment(Enchantment.Rarity rarity, EquipmentSlot ... slots) {
        super(rarity, LCEnchantmentCategories.WALLET_PICKUP_CATEGORY, slots);
    }

    public int m_6183_(int level) {
        return 5 + (level - 1) * 8;
    }

    public int m_6175_(int level) {
        return super.m_6183_(level) + 50;
    }

    public int m_6586_() {
        return 3;
    }

    public static void runEntityTick(LivingEntity entity) {
        WalletCapability.getWalletHandler((Entity)entity).ifPresent(walletHandler -> {
            ItemStack wallet = walletHandler.getWallet();
            if (!(WalletItem.isWallet(wallet) && wallet.m_41720_() instanceof WalletItem && WalletItem.CanPickup((WalletItem)wallet.m_41720_()))) {
                return;
            }
            int enchantLevel = EnchantmentHelper.m_44843_((Enchantment)ModEnchantments.COIN_MAGNET, (ItemStack)wallet) - 1;
            if (enchantLevel < 0) {
                return;
            }
            float range = (Integer)Config.SERVER.coinMagnetRangeBase.get() + (Integer)Config.SERVER.coinMagnetRangeLevel.get() * Math.min(enchantLevel, 2);
            Level level = entity.f_19853_;
            if (level == null) {
                return;
            }
            AABB searchBox = new AABB(entity.f_19854_ - (double)range, entity.f_19855_ - (double)range, entity.f_19856_ - (double)range, entity.f_19854_ + (double)range, entity.f_19855_ + (double)range, entity.f_19856_ + (double)range);
            boolean updateWallet = false;
            for (Entity e2 : level.m_6249_((Entity)entity, searchBox, e -> e instanceof ItemEntity && MoneyUtil.isCoin(((ItemEntity)e).m_32055_(), false))) {
                ItemEntity ie = (ItemEntity)e2;
                ItemStack coinStack = ie.m_32055_();
                ItemStack leftovers = WalletItem.PickupCoin(wallet, coinStack);
                if (leftovers.m_41613_() == coinStack.m_41613_()) continue;
                updateWallet = true;
                if (leftovers.m_41619_()) {
                    ie.m_146870_();
                } else {
                    ie.m_32045_(leftovers);
                }
                level.m_6269_(null, (Entity)entity, CurrencySoundEvents.COINS_CLINKING, SoundSource.PLAYERS, 0.4f, 1.0f);
            }
            if (updateWallet) {
                walletHandler.setWallet(wallet);
                if (entity instanceof Player) {
                    Player player = (Player)entity;
                    if (player.f_36096_ instanceof WalletMenu) {
                        ((WalletMenu)player.f_36096_).onWalletSlotChanged();
                    }
                }
            }
        });
    }
}

