/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.menus;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.core.ModMenus;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.slots.BlacklistSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.CoinSlot;
import io.github.lightman314.lightmanscurrency.menus.slots.DisplaySlot;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class WalletMenu
extends AbstractContainerMenu
implements BankAccount.IBankAccountMenu {
    private static int maxWalletSlots = 0;
    private Container dummyInventory = new SimpleContainer(1);
    private final int walletStackIndex;
    private final Inventory inventory;
    private final List<IWalletMenuListener> listeners = Lists.newArrayList();
    private boolean walletSlotChanged = false;
    private Container coinInput;
    private WalletItem walletItem;
    boolean autoConvert = false;
    public final Player player;
    BankAccount.AccountReference accountSource;

    public static void updateMaxWalletSlots(int slotCount) {
        if (slotCount > maxWalletSlots) {
            maxWalletSlots = slotCount;
        }
    }

    public int getWalletIndex() {
        return this.walletStackIndex;
    }

    public boolean hasWallet() {
        ItemStack wallet = this.getWallet();
        return !wallet.m_41619_() && wallet.m_41720_() instanceof WalletItem;
    }

    private ItemStack getWallet() {
        if (this.walletStackIndex < 0) {
            return LightmansCurrency.getWalletStack(this.inventory.f_35978_);
        }
        return this.inventory.m_8020_(this.walletStackIndex);
    }

    public Component getTitle() {
        ItemStack wallet = this.getWallet();
        if (wallet.m_41619_()) {
            return new TextComponent("");
        }
        return wallet.m_41786_();
    }

    @Override
    public Player getPlayer() {
        return this.player;
    }

    @Override
    public BankAccount getAccount() {
        return this.accountSource.get();
    }

    public WalletMenu(int windowId, Inventory inventory, int walletStackIndex) {
        super(ModMenus.WALLET, windowId);
        this.walletStackIndex = walletStackIndex;
        this.inventory = inventory;
        this.player = inventory.f_35978_;
        this.accountSource = BankAccount.GenerateReference(this.player);
        this.init();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void init() {
        int x;
        int y;
        NonNullList newSlots = NonNullList.m_122779_();
        Item item = this.getWallet().m_41720_();
        this.walletItem = item instanceof WalletItem ? (WalletItem)item : null;
        int yOffset = this.getVerticalOffset();
        this.coinInput = new SimpleContainer(WalletItem.InventorySize(this.walletItem));
        NonNullList<ItemStack> walletInventory = WalletItem.getWalletInventory(this.getWallet());
        for (int i = 0; i < this.coinInput.m_6643_() && i < walletInventory.size(); ++i) {
            this.coinInput.m_6836_(i, (ItemStack)walletInventory.get(i));
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                int index = x + y * 9 + 9;
                if (index == this.walletStackIndex) {
                    newSlots.add((Object)new DisplaySlot((Container)this.inventory, index, 8 + x * 18, 32 + (y + this.getRowCount()) * 18 + yOffset));
                    continue;
                }
                newSlots.add((Object)new BlacklistSlot((Container)this.inventory, index, 8 + x * 18, 32 + (y + this.getRowCount()) * 18 + yOffset, (Container)this.inventory, this.walletStackIndex));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            if (x2 == this.walletStackIndex) {
                newSlots.add((Object)new DisplaySlot((Container)this.inventory, x2, 8 + x2 * 18, 90 + this.getRowCount() * 18 + yOffset));
                continue;
            }
            newSlots.add((Object)new BlacklistSlot((Container)this.inventory, x2, 8 + x2 * 18, 90 + this.getRowCount() * 18 + yOffset, (Container)this.inventory, this.walletStackIndex));
        }
        y = 0;
        while (y * 9 < this.coinInput.m_6643_()) {
            for (x = 0; x < 9 && x + y * 9 < this.coinInput.m_6643_(); ++x) {
                newSlots.add((Object)new CoinSlot(this.coinInput, x + y * 9, 8 + x * 18, 18 + y * 18 + yOffset).addListener(this::saveWalletContents));
            }
            ++y;
        }
        while (newSlots.size() < 37 + maxWalletSlots) {
            newSlots.add((Object)new DisplaySlot(this.dummyInventory, 0, 0x3FFFFFFF, 0x3FFFFFFF));
        }
        this.autoConvert = WalletItem.getAutoConvert(this.getWallet());
        this.listeners.forEach(listener -> listener.onReload());
        this.setSlots((List<Slot>)newSlots);
    }

    protected void setSlots(List<Slot> newSlots) {
        this.f_38839_.clear();
        newSlots.forEach(newSlot -> this.m_38897_((Slot)newSlot));
    }

    public void onWalletSlotChanged() {
        this.walletSlotChanged = true;
        this.f_38839_.forEach(slot -> {
            if (slot instanceof CoinSlot) {
                ((CoinSlot)((Object)slot)).Lock();
            }
        });
    }

    public void addListener(IWalletMenuListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public int getVerticalOffset() {
        if (this.hasBankAccess()) {
            return 109;
        }
        return 0;
    }

    public int getRowCount() {
        return 1 + (this.coinInput.m_6643_() - 1) / 9;
    }

    public int getSlotCount() {
        return this.coinInput.m_6643_();
    }

    public boolean m_6875_(Player playerIn) {
        return true;
    }

    public void m_6877_(Player playerIn) {
        super.m_6877_(playerIn);
        this.m_150411_(playerIn, this.dummyInventory);
        this.saveWalletContents();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    @SubscribeEvent
    public void onTick(TickEvent.WorldTickEvent event) {
        if (event.side.isClient() || event.phase != TickEvent.Phase.START) {
            return;
        }
        if (this.walletSlotChanged) {
            this.walletSlotChanged = false;
            this.init();
        }
        if (this.inventory == null) {
            return;
        }
    }

    public void clientTick() {
        if (this.walletSlotChanged) {
            this.walletSlotChanged = false;
            this.init();
        }
    }

    public void saveWalletContents() {
        if (!this.hasWallet()) {
            return;
        }
        NonNullList walletInventory = NonNullList.m_122780_((int)WalletItem.InventorySize(this.walletItem), (Object)ItemStack.f_41583_);
        for (int i = 0; i < walletInventory.size() && i < this.coinInput.m_6643_(); ++i) {
            walletInventory.set(i, (Object)this.coinInput.m_8020_(i));
        }
        WalletItem.putWalletInventory(this.getWallet(), (NonNullList<ItemStack>)walletInventory);
        if (this.autoConvert != WalletItem.getAutoConvert(this.getWallet())) {
            WalletItem.toggleAutoConvert(this.getWallet());
        }
    }

    public boolean canConvert() {
        return WalletItem.CanConvert(this.walletItem);
    }

    public boolean canPickup() {
        return WalletItem.CanPickup(this.walletItem);
    }

    public boolean hasBankAccess() {
        return WalletItem.HasBankAccess(this.walletItem);
    }

    public boolean getAutoConvert() {
        return this.autoConvert;
    }

    public void ToggleAutoConvert() {
        this.autoConvert = !this.autoConvert;
    }

    public ItemStack m_7648_(Player playerEntity, int index) {
        if (index + this.coinInput.m_6643_() == this.walletStackIndex) {
            return ItemStack.f_41583_;
        }
        ItemStack clickedStack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot != null && slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            clickedStack = slotStack.m_41777_();
            if (index == 0) {
                if (!this.m_38903_(slotStack, 1, 37, false)) {
                    return ItemStack.f_41583_;
                }
            } else if (index < 37) {
                if (clickedStack.m_41720_() instanceof WalletItem && !this.m_38903_(slotStack, 0, 1, true)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 37, this.f_38839_.size(), false)) {
                    return ItemStack.f_41583_;
                }
            } else if (!this.m_38903_(slotStack, 1, 37, true)) {
                return ItemStack.f_41583_;
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return clickedStack;
    }

    public void ConvertCoins() {
        MoneyUtil.ConvertAllCoinsUp(this.coinInput);
        MoneyUtil.SortCoins(this.coinInput);
        this.saveWalletContents();
    }

    @Override
    public void onDepositOrWithdraw() {
        if (this.canConvert()) {
            this.ConvertCoins();
        }
    }

    public ItemStack PickupCoins(ItemStack stack) {
        ItemStack returnValue = stack.m_41777_();
        for (int i = 0; i < this.coinInput.m_6643_() && !returnValue.m_41619_(); ++i) {
            ItemStack thisStack = this.coinInput.m_8020_(i);
            if (thisStack.m_41619_()) {
                this.coinInput.m_6836_(i, returnValue.m_41777_());
                returnValue = ItemStack.f_41583_;
                continue;
            }
            if (thisStack.m_41720_() != returnValue.m_41720_()) continue;
            int amountToAdd = MathUtil.clamp(returnValue.m_41613_(), 0, thisStack.m_41741_() - thisStack.m_41613_());
            thisStack.m_41764_(thisStack.m_41613_() + amountToAdd);
            returnValue.m_41764_(returnValue.m_41613_() - amountToAdd);
        }
        if (this.autoConvert) {
            this.ConvertCoins();
        }
        this.saveWalletContents();
        return returnValue;
    }

    @Override
    public Container getCoinInput() {
        return this.coinInput;
    }

    public static interface IWalletMenuListener {
        public void onReload();
    }
}

