/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.bank;

import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.SelectionTab;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraftforge.network.NetworkEvent;

public class MessageATMPlayerAccountResponse {
    private BankAccount.AccountReference account;
    private Component message;

    public MessageATMPlayerAccountResponse(BankAccount.AccountReference account, Component message) {
        this.account = account;
        this.message = message;
    }

    public static void encode(MessageATMPlayerAccountResponse message, FriendlyByteBuf buffer) {
        if (message.account != null) {
            buffer.writeBoolean(true);
            message.account.writeToBuffer(buffer);
        } else {
            buffer.writeBoolean(false);
        }
        buffer.m_130070_(Component.Serializer.m_130703_((Component)message.message));
    }

    public static MessageATMPlayerAccountResponse decode(FriendlyByteBuf buffer) {
        BankAccount.AccountReference account = null;
        if (buffer.readBoolean()) {
            account = BankAccount.LoadReference(true, buffer);
        }
        return new MessageATMPlayerAccountResponse(account, (Component)Component.Serializer.m_130701_((String)buffer.m_130277_()));
    }

    public static void handle(MessageATMPlayerAccountResponse message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            ATMScreen screen;
            Minecraft mc = Minecraft.m_91087_();
            if (mc.f_91080_ instanceof ATMScreen && (screen = (ATMScreen)mc.f_91080_).currentTab() instanceof SelectionTab) {
                ((SelectionTab)screen.currentTab()).ReceiveSelectPlayerResponse(message.account, message.message);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

