/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.network.message.paygate;

import io.github.lightman314.lightmanscurrency.blockentity.PaygateBlockEntity;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;

public class MessageUpdatePaygateData {
    private BlockPos pos;
    private CoinValue newPrice;
    private int newDuration;

    public MessageUpdatePaygateData(BlockPos pos, CoinValue newPrice, int newDuration) {
        this.pos = pos;
        this.newPrice = newPrice;
        this.newDuration = newDuration;
    }

    public static void encode(MessageUpdatePaygateData message, FriendlyByteBuf buffer) {
        buffer.m_130064_(message.pos);
        buffer.m_130079_(message.newPrice.writeToNBT(new CompoundTag(), "CoinValue"));
        buffer.writeInt(message.newDuration);
    }

    public static MessageUpdatePaygateData decode(FriendlyByteBuf buffer) {
        return new MessageUpdatePaygateData(buffer.m_130135_(), new CoinValue(buffer.m_130260_()), buffer.readInt());
    }

    public static void handle(MessageUpdatePaygateData message, Supplier<NetworkEvent.Context> supplier) {
        supplier.get().enqueueWork(() -> {
            BlockEntity blockEntity;
            ServerPlayer player = ((NetworkEvent.Context)supplier.get()).getSender();
            if (player != null && (blockEntity = player.f_19853_.m_7702_(message.pos)) != null && blockEntity instanceof PaygateBlockEntity) {
                PaygateBlockEntity paygateEntity = (PaygateBlockEntity)blockEntity;
                paygateEntity.setPrice(message.newPrice);
                paygateEntity.setDuration(message.newDuration);
            }
        });
        supplier.get().setPacketHandled(true);
    }
}

