/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.trades_basic.BasicTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.tradedata.IBarterTrade;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.restrictions.ItemTradeRestriction;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;

public class ItemTradeData
extends TradeData
implements IBarterTrade {
    public static final int MAX_CUSTOMNAME_LENGTH = 30;
    ItemTradeRestriction restriction = ItemTradeRestriction.NONE;
    SimpleContainer items = new SimpleContainer(4);
    ItemTradeType tradeType = ItemTradeType.SALE;
    String customName1 = "";
    String customName2 = "";

    public static int MaxTradeTypeStringLength() {
        int length = 0;
        for (ItemTradeType value : ItemTradeType.values()) {
            int thisLength = value.name().length();
            if (thisLength <= length) continue;
            length = thisLength;
        }
        return length;
    }

    public ItemStack getSellItem(int index) {
        if (index >= 0 && index < 2) {
            return this.restriction.modifySellItem(this.items.m_8020_(index).m_41777_(), this.getCustomName(index), this);
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getBarterItem(int index) {
        if (index >= 0 && index < 2) {
            return this.items.m_8020_(index + 2).m_41777_();
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getItem(int index) {
        if (index >= 0 && index < 2) {
            return this.getSellItem(index);
        }
        if (index >= 2 && index < 4) {
            return this.getBarterItem(index - 2);
        }
        return ItemStack.f_41583_;
    }

    public void setItem(ItemStack itemStack, int index) {
        if (index >= 0 && index < 4) {
            if (index < 2) {
                if (this.restriction.allowSellItem(itemStack) || itemStack.m_41619_()) {
                    this.items.m_6836_(index, this.restriction.filterSellItem(itemStack).m_41777_());
                }
            } else {
                this.items.m_6836_(index, itemStack.m_41777_());
            }
        } else {
            LightmansCurrency.LogError("Cannot define the item trades item at index " + index + ". Must be between 0-3!");
        }
    }

    public boolean allowItemInStorage(ItemStack item) {
        for (int i = 0; i < (this.isBarter() ? 4 : 2); ++i) {
            if (!InventoryUtil.ItemMatches(item, this.getItem(i))) continue;
            return true;
        }
        return this.restriction.allowExtraItemInStorage(item);
    }

    public boolean hasCustomName(int index) {
        return !this.getCustomName(index).isEmpty();
    }

    public String getCustomName(int index) {
        switch (index) {
            case 0: {
                return this.customName1;
            }
            case 1: {
                return this.customName2;
            }
        }
        return "";
    }

    public void setCustomName(int index, String customName) {
        switch (index) {
            case 0: {
                this.customName1 = customName;
                return;
            }
            case 1: {
                this.customName2 = customName;
                return;
            }
        }
    }

    @Override
    public TradeData.TradeDirection getTradeDirection() {
        switch (this.tradeType) {
            case SALE: {
                return TradeData.TradeDirection.SALE;
            }
            case PURCHASE: {
                return TradeData.TradeDirection.PURCHASE;
            }
        }
        return TradeData.TradeDirection.NONE;
    }

    public ItemTradeType getTradeType() {
        return this.tradeType;
    }

    public boolean isSale() {
        return this.tradeType == ItemTradeType.SALE;
    }

    public boolean isPurchase() {
        return this.tradeType == ItemTradeType.PURCHASE;
    }

    @Override
    public boolean isBarter() {
        return this.tradeType == ItemTradeType.BARTER;
    }

    public void setTradeType(ItemTradeType tradeDirection) {
        this.tradeType = tradeDirection;
    }

    public int getSlotCount() {
        return this.tradeType == ItemTradeType.BARTER ? 2 : 1;
    }

    public ItemTradeRestriction getRestriction() {
        return this.restriction;
    }

    public void setRestriction(ItemTradeRestriction restriction) {
        this.restriction = restriction;
    }

    @Override
    public boolean isValid() {
        if (this.tradeType == ItemTradeType.BARTER) {
            return this.sellItemsDefined() && this.barterItemsDefined();
        }
        return super.isValid() && this.sellItemsDefined();
    }

    public boolean sellItemsDefined() {
        return !this.getSellItem(0).m_41619_() || !this.getSellItem(1).m_41619_();
    }

    public boolean barterItemsDefined() {
        return !this.getBarterItem(0).m_41619_() || !this.getBarterItem(1).m_41619_();
    }

    public boolean hasStock(IItemTrader trader) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(trader) > 0;
    }

    public boolean hasStock(TradeContext context) {
        if (!this.sellItemsDefined()) {
            return false;
        }
        return this.stockCount(context) > 0;
    }

    public boolean hasSpace(IItemTrader trader) {
        switch (this.tradeType) {
            case PURCHASE: {
                return trader.getStorage().canFitItems(this.getSellItem(0), this.getSellItem(1));
            }
            case BARTER: {
                return trader.getStorage().canFitItems(this.getBarterItem(0), this.getBarterItem(1));
            }
        }
        return true;
    }

    public int stockCount(IItemTrader trader) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            if (this.cost.isFree()) {
                return 1;
            }
            if (this.cost.getRawValue() == 0L) {
                return 0;
            }
            long coinValue = trader.getStoredMoney().getRawValue();
            long price = this.cost.getRawValue();
            return (int)(coinValue / price);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this.getSellItem(0), this.getSellItem(1));
        }
        return 0;
    }

    public int stockCount(TradeContext context) {
        if (!this.sellItemsDefined()) {
            return 0;
        }
        if (!context.hasTrader() || !(context.getTrader() instanceof IItemTrader)) {
            return 0;
        }
        IItemTrader trader = (IItemTrader)context.getTrader();
        if (trader.getCoreSettings().isCreative()) {
            return 1;
        }
        if (this.tradeType == ItemTradeType.PURCHASE) {
            if (this.cost.isFree()) {
                return 1;
            }
            if (this.cost.getRawValue() == 0L) {
                return 0;
            }
            long coinValue = trader.getStoredMoney().getRawValue();
            long price = this.getCost(context).getRawValue();
            return (int)(coinValue / price);
        }
        if (this.tradeType == ItemTradeType.SALE || this.tradeType == ItemTradeType.BARTER) {
            return this.restriction.getSaleStock(trader.getStorage(), this.getSellItem(0), this.getSellItem(1));
        }
        return 0;
    }

    public boolean canAfford(TradeContext context) {
        if (this.isSale()) {
            return context.hasFunds(this.getCost(context));
        }
        if (this.isPurchase()) {
            return context.hasItems(this.getSellItem(0), this.getSellItem(1));
        }
        if (this.isBarter()) {
            return context.hasItems(this.getBarterItem(0), this.getBarterItem(1));
        }
        return false;
    }

    public void RemoveItemsFromStorage(TraderItemStorage storage) {
        this.restriction.removeItemsFromStorage(storage, this.getSellItem(0), this.getSellItem(1));
    }

    @Override
    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = super.getAsNBT();
        InventoryUtil.saveAllItems("Items", tradeNBT, (Container)this.items);
        tradeNBT.m_128359_("TradeDirection", this.tradeType.name());
        tradeNBT.m_128359_("CustomName1", this.customName1);
        tradeNBT.m_128359_("CustomName2", this.customName2);
        return tradeNBT;
    }

    public static CompoundTag saveAllData(CompoundTag nbt, List<ItemTradeData> data) {
        return ItemTradeData.saveAllData(nbt, data, "Trades");
    }

    public static CompoundTag saveAllData(CompoundTag nbt, List<ItemTradeData> data, String key) {
        ListTag listNBT = new ListTag();
        for (int i = 0; i < data.size(); ++i) {
            listNBT.add((Object)data.get(i).getAsNBT());
        }
        if (listNBT.size() > 0) {
            nbt.m_128365_(key, (Tag)listNBT);
        }
        return nbt;
    }

    public static ItemTradeData loadData(CompoundTag nbt) {
        ItemTradeData trade = new ItemTradeData();
        trade.loadFromNBT(nbt);
        return trade;
    }

    public static List<ItemTradeData> loadAllData(CompoundTag nbt, int arraySize) {
        return ItemTradeData.loadAllData("Trades", nbt, arraySize);
    }

    public static List<ItemTradeData> loadAllData(String key, CompoundTag nbt, int arraySize) {
        ListTag listNBT = nbt.m_128437_(key, 10);
        List<ItemTradeData> data = ItemTradeData.listOfSize(arraySize);
        for (int i = 0; i < listNBT.size() && i < arraySize; ++i) {
            data.get(i).loadFromNBT(listNBT.m_128728_(i));
        }
        return data;
    }

    @Override
    public void loadFromNBT(CompoundTag nbt) {
        super.loadFromNBT(nbt);
        if (nbt.m_128425_("Items", 9)) {
            this.items = InventoryUtil.loadAllItems("Items", nbt, 4);
        } else {
            this.items = new SimpleContainer(4);
            if (nbt.m_128425_("SellItem", 10)) {
                this.items.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("SellItem")));
            } else {
                this.items.m_6836_(0, ItemStack.m_41712_((CompoundTag)nbt));
            }
            if (nbt.m_128425_("BarterItem", 10)) {
                this.items.m_6836_(2, ItemStack.m_41712_((CompoundTag)nbt.m_128469_("BarterItem")));
            } else {
                this.items.m_6836_(2, ItemStack.f_41583_);
            }
        }
        this.tradeType = nbt.m_128425_("TradeDirection", 8) ? ItemTradeData.loadTradeType(nbt.m_128461_("TradeDirection")) : ItemTradeType.SALE;
        this.customName1 = nbt.m_128441_("CustomName1") ? nbt.m_128461_("CustomName1") : (nbt.m_128441_("CustomName") ? nbt.m_128461_("CustomName") : "");
        this.customName2 = nbt.m_128441_("CustomName2") ? nbt.m_128461_("CustomName2") : "";
    }

    public static ItemTradeType loadTradeType(String name) {
        ItemTradeType value = ItemTradeType.SALE;
        try {
            value = ItemTradeType.valueOf(name);
        }
        catch (IllegalArgumentException exception) {
            LightmansCurrency.LogError("Could not load '" + name + "' as a TradeDirection.");
        }
        return value;
    }

    public static List<ItemTradeData> listOfSize(int tradeCount) {
        ArrayList data = Lists.newArrayList();
        while (data.size() < tradeCount) {
            data.add(new ItemTradeData());
        }
        return data;
    }

    @Override
    public void markRulesDirty() {
    }

    @Override
    public TradeData.TradeComparisonResult compare(TradeData otherTrade) {
        TradeData.TradeComparisonResult result = new TradeData.TradeComparisonResult();
        if (otherTrade instanceof ItemTradeData) {
            ItemTradeData otherItemTrade = (ItemTradeData)otherTrade;
            result.setCompatible();
            result.addProductResults(TradeData.TradeComparisonResult.ProductComparisonResult.CompareTwoItems(this.getSellItem(0), this.getSellItem(1), otherItemTrade.getSellItem(0), otherItemTrade.getSellItem(1)));
            if (this.isBarter()) {
                result.addProductResults(TradeData.TradeComparisonResult.ProductComparisonResult.CompareTwoItems(this.getBarterItem(0), this.getBarterItem(1), otherItemTrade.getBarterItem(0), otherItemTrade.getBarterItem(1)));
            }
            if (!this.isBarter()) {
                result.setPriceResult(this.getCost().getRawValue() - otherTrade.getCost().getRawValue());
            }
            result.setTypeResult(this.tradeType == otherItemTrade.tradeType);
        }
        return result;
    }

    @Override
    public boolean AcceptableDifferences(TradeData.TradeComparisonResult result) {
        int i;
        if (!result.TypeMatches() || !result.isCompatible()) {
            return false;
        }
        if (result.getProductResultCount() < 2) {
            return false;
        }
        for (i = 0; i < 2; ++i) {
            TradeData.TradeComparisonResult.ProductComparisonResult sellResult = result.getProductResult(i);
            if (sellResult.SameProductType() && sellResult.SameProductNBT()) {
                if (!(this.isSale() || this.isBarter() ? sellResult.ProductQuantityDifference() > 0 : this.isPurchase() && sellResult.ProductQuantityDifference() < 0)) continue;
                return false;
            }
            return false;
        }
        if (this.isBarter()) {
            if (result.getProductResultCount() < 4) {
                return false;
            }
            for (i = 0; i < 2; ++i) {
                TradeData.TradeComparisonResult.ProductComparisonResult barterResult = result.getProductResult(i + 2);
                if (barterResult.SameProductType() && barterResult.SameProductNBT()) {
                    if (barterResult.ProductQuantityDifference() >= 0) continue;
                    return false;
                }
                return false;
            }
        }
        if (this.isSale() && result.isPriceExpensive()) {
            return false;
        }
        return !this.isPurchase() || !result.isPriceCheaper();
    }

    @Override
    public List<Component> GetDifferenceWarnings(TradeData.TradeComparisonResult differences) {
        ArrayList<Component> list = new ArrayList<Component>();
        if (!differences.PriceMatches()) {
            long difference = differences.priceDifference();
            if (difference < 0L) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.difference.expensive", new Object[]{MoneyUtil.getStringOfValue(-difference)}).m_130940_(ChatFormatting.RED));
            } else {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.difference.cheaper", new Object[]{MoneyUtil.getStringOfValue(difference)}).m_130940_(ChatFormatting.RED));
            }
        }
        for (int i = 0; i < differences.getProductResultCount(); ++i) {
            TranslatableComponent slotName = new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.product." + i);
            TradeData.TradeComparisonResult.ProductComparisonResult productCheck = differences.getProductResult(i);
            if (!productCheck.SameProductType()) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.itemtype", new Object[]{slotName}).m_130940_(ChatFormatting.RED));
                continue;
            }
            if (!productCheck.SameProductNBT()) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.itemnbt").m_130940_(ChatFormatting.RED));
                continue;
            }
            if (productCheck.SameProductQuantity()) continue;
            int quantityDifference = productCheck.ProductQuantityDifference();
            if (quantityDifference < 0) {
                list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.quantity.more", new Object[]{slotName, -quantityDifference}).m_130940_(ChatFormatting.RED));
                continue;
            }
            list.add((Component)new TranslatableComponent("gui.lightmanscurrency.interface.item.difference.quantity.less", new Object[]{slotName, quantityDifference}).m_130940_(ChatFormatting.RED));
        }
        return list;
    }

    @Override
    public List<TradeButton.DisplayEntry> getInputDisplays(TradeContext context) {
        if (this.isSale()) {
            return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(this.getCost(context), context.isStorageMode ? Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.lightmanscurrency.trader.price_edit")}) : null)});
        }
        if (this.isPurchase()) {
            return this.getSaleItemEntries(context);
        }
        if (this.isBarter()) {
            return this.getBarterItemEntries(context);
        }
        return new ArrayList<TradeButton.DisplayEntry>();
    }

    @Override
    public List<TradeButton.DisplayEntry> getOutputDisplays(TradeContext context) {
        if (this.isSale() || this.isBarter()) {
            return this.getSaleItemEntries(context);
        }
        if (this.isPurchase()) {
            return Lists.newArrayList((Object[])new TradeButton.DisplayEntry[]{TradeButton.DisplayEntry.of(this.getCost(context))});
        }
        return new ArrayList<TradeButton.DisplayEntry>();
    }

    private List<TradeButton.DisplayEntry> getSaleItemEntries(TradeContext context) {
        ArrayList<TradeButton.DisplayEntry> entries = new ArrayList<TradeButton.DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = this.getSellItem(i);
            if (!item.m_41619_()) {
                entries.add(TradeButton.DisplayEntry.of(item, item.m_41613_(), this.getSaleItemTooltip(item, this.getCustomName(i), context)));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(TradeButton.DisplayEntry.of(this.restriction.getEmptySlotBG(), (List<Component>)Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.lightmanscurrency.trader.item_edit")})));
        }
        return entries;
    }

    private List<Component> getSaleItemTooltip(ItemStack stack, String customName, TradeContext context) {
        if (stack.m_41619_()) {
            if (context.isStorageMode) {
                return Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.lightmanscurrency.trader.item_edit")});
            }
            return null;
        }
        List<Component> tooltips = ItemRenderUtil.getTooltipFromItem(stack);
        Component originalName = null;
        if (!customName.isEmpty() && (this.isSale() || this.isBarter())) {
            originalName = tooltips.get(0);
            tooltips.set(0, (Component)new TextComponent(customName).m_130940_(ChatFormatting.GOLD));
        }
        if (context.isStorageMode && originalName == null) {
            return tooltips;
        }
        tooltips.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.info"));
        if (originalName != null) {
            tooltips.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.originalname", new Object[]{originalName}));
        }
        if (context.hasTrader() && context.hasPlayerReference() && context.getTrader() instanceof IItemTrader) {
            IItemTrader trader = (IItemTrader)context.getTrader();
            tooltips.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.trader.stock", new Object[]{trader.getCoreSettings().isCreative() ? new TranslatableComponent("tooltip.lightmanscurrency.trader.stock.infinite") : new TextComponent(String.valueOf(this.stockCount(context))).m_130940_(ChatFormatting.GOLD)}));
        }
        return tooltips;
    }

    private List<TradeButton.DisplayEntry> getBarterItemEntries(TradeContext context) {
        ArrayList<TradeButton.DisplayEntry> entries = new ArrayList<TradeButton.DisplayEntry>();
        for (int i = 0; i < 2; ++i) {
            ItemStack item = this.getBarterItem(i);
            if (!item.m_41619_()) {
                entries.add(TradeButton.DisplayEntry.of(item, item.m_41613_(), ItemRenderUtil.getTooltipFromItem(item)));
                continue;
            }
            if (!context.isStorageMode) continue;
            entries.add(TradeButton.DisplayEntry.of(ItemRenderUtil.BACKGROUND, (List<Component>)Lists.newArrayList((Object[])new Component[]{new TranslatableComponent("tooltip.lightmanscurrency.trader.item_edit")})));
        }
        return entries;
    }

    @Override
    public int tradeButtonWidth(TradeContext context) {
        return 94;
    }

    @Override
    public int tradeButtonHeight(TradeContext context) {
        return 18;
    }

    @Override
    public TradeButton.DisplayData inputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(1, 1, 34, 16);
    }

    @Override
    public TradeButton.DisplayData outputDisplayArea(TradeContext context) {
        return new TradeButton.DisplayData(58, 1, 34, 16);
    }

    @Override
    public Pair<Integer, Integer> arrowPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public Pair<Integer, Integer> alertPosition(TradeContext context) {
        return Pair.of((Object)36, (Object)1);
    }

    @Override
    public List<Component> getAlerts(TradeContext context) {
        if (context.isStorageMode) {
            return null;
        }
        ArrayList<Component> alerts = new ArrayList<Component>();
        if (context.hasTrader() && context.getTrader() instanceof IItemTrader) {
            IItemTrader trader = (IItemTrader)context.getTrader();
            if (!trader.isCreative()) {
                if (this.stockCount(context) <= 0) {
                    alerts.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.outofstock"));
                }
                if (!this.hasSpace(trader)) {
                    alerts.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.outofspace"));
                }
            }
            if (!this.canAfford(context)) {
                alerts.add((Component)new TranslatableComponent("tooltip.lightmanscurrency.cannotafford"));
            }
        }
        this.addTradeRuleAlerts(alerts, context);
        return alerts;
    }

    @Override
    public void onInputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, ItemStack heldItem) {
        if (tab.menu.getTrader() instanceof IItemTrader) {
            IItemTrader it = (IItemTrader)tab.menu.getTrader();
            int tradeIndex = it.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if (this.isSale()) {
                CompoundTag extraData = new CompoundTag();
                extraData.m_128405_("TradeIndex", tradeIndex);
                extraData.m_128405_("StartingSlot", -1);
                tab.sendOpenTabMessage(2, extraData);
            }
            if (this.isPurchase() && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (sellItem.m_41619_() && heldItem.m_41619_()) {
                    CompoundTag extraData = new CompoundTag();
                    extraData.m_128405_("TradeIndex", tradeIndex);
                    extraData.m_128405_("StartingSlot", index);
                    tab.sendOpenTabMessage(2, extraData);
                } else if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                    sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (button == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index);
                }
                tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
            } else if (this.isBarter() && index >= 0 && index < 2) {
                ItemStack barterItem = this.getBarterItem(index);
                if (barterItem.m_41619_() && heldItem.m_41619_()) {
                    CompoundTag extraData = new CompoundTag();
                    extraData.m_128405_("TradeIndex", tradeIndex);
                    extraData.m_128405_("StartingSlot", index + 2);
                    tab.sendOpenTabMessage(2, extraData);
                }
                if (InventoryUtil.ItemMatches(barterItem, heldItem) && button == 1) {
                    barterItem.m_41764_(Math.min(barterItem.m_41613_() + 1, barterItem.m_41741_()));
                    this.setItem(barterItem, index + 2);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (button == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index + 2);
                }
                tab.sendInputInteractionMessage(tradeIndex, index, button, heldItem);
            }
        }
    }

    @Override
    public void onOutputDisplayInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int index, int button, ItemStack heldItem) {
        if (tab.menu.getTrader() instanceof IItemTrader) {
            IItemTrader it = (IItemTrader)tab.menu.getTrader();
            int tradeIndex = it.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            if ((this.isSale() || this.isBarter()) && index >= 0 && index < 2) {
                ItemStack sellItem = this.getSellItem(index);
                if (sellItem.m_41619_() && heldItem.m_41619_()) {
                    CompoundTag extraData = new CompoundTag();
                    extraData.m_128405_("TradeIndex", tradeIndex);
                    extraData.m_128405_("StartingSlot", index);
                    tab.sendOpenTabMessage(2, extraData);
                }
                if (InventoryUtil.ItemMatches(sellItem, heldItem) && button == 1) {
                    sellItem.m_41764_(Math.min(sellItem.m_41613_() + 1, sellItem.m_41741_()));
                    this.setItem(sellItem, index);
                } else {
                    ItemStack setItem = heldItem.m_41777_();
                    if (button == 1) {
                        setItem.m_41764_(1);
                    }
                    this.setItem(setItem, index);
                }
                tab.sendOutputInteractionMessage(tradeIndex, index, button, heldItem);
            } else if (this.isPurchase()) {
                CompoundTag extraData = new CompoundTag();
                extraData.m_128405_("TradeIndex", tradeIndex);
                extraData.m_128405_("StartingSlot", -1);
                tab.sendOpenTabMessage(2, extraData);
            }
        }
    }

    @Override
    public void onInteraction(BasicTradeEditTab tab, TraderStorageMenu.IClientMessage clientHandler, int mouseX, int mouseY, int button, ItemStack heldItem) {
        if (tab.menu.getTrader() instanceof IItemTrader) {
            IItemTrader it = (IItemTrader)tab.menu.getTrader();
            int tradeIndex = it.getAllTrades().indexOf(this);
            if (tradeIndex < 0) {
                return;
            }
            CompoundTag extraData = new CompoundTag();
            extraData.m_128405_("TradeIndex", tradeIndex);
            tab.sendOpenTabMessage(2, extraData);
        }
    }

    public static enum ItemTradeType {
        SALE(0, 1),
        PURCHASE(1, 2),
        BARTER(2, 0);

        public final int index;
        private final int nextIndex;

        public final ItemTradeType next() {
            return ItemTradeType.fromIndex(this.nextIndex);
        }

        private ItemTradeType(int index, int nextIndex) {
            this.index = index;
            this.nextIndex = nextIndex;
        }

        public static ItemTradeType fromIndex(int index) {
            for (ItemTradeType type : ItemTradeType.values()) {
                if (type.index != index) continue;
                return type;
            }
            return SALE;
        }
    }
}

