/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata;

import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public abstract class TradeData
implements ITradeRuleHandler,
TradeButton.ITradeData {
    public static final String DEFAULT_KEY = "Trades";
    protected CoinValue cost = new CoinValue(new CoinValue.CoinValuePair[0]);
    List<TradeRule> rules = new ArrayList<TradeRule>();

    public abstract TradeDirection getTradeDirection();

    public final boolean validCost() {
        return this.cost.isFree() || this.cost.getRawValue() > 0L;
    }

    @Override
    public boolean isValid() {
        return this.validCost();
    }

    public CoinValue getCost() {
        return this.cost;
    }

    public CoinValue getCost(TradeContext context) {
        if (context.hasTrader() && context.hasPlayerReference()) {
            return context.getTrader().runTradeCostEvent(context.getPlayerReference(), this).getCostResult();
        }
        return this.cost;
    }

    public void setCost(CoinValue value) {
        this.cost = value;
    }

    @Deprecated
    public boolean isFree() {
        return this.cost.isFree();
    }

    @Deprecated
    public void setFree(boolean free) {
        this.cost.setFree(free);
    }

    public CompoundTag getAsNBT() {
        CompoundTag tradeNBT = new CompoundTag();
        this.cost.writeToNBT(tradeNBT, "Price");
        TradeRule.writeRules(tradeNBT, this.rules);
        return tradeNBT;
    }

    protected void loadFromNBT(CompoundTag nbt) {
        this.cost.readFromNBT(nbt, "Price");
        if (nbt.m_128441_("IsFree")) {
            this.cost.setFree(nbt.m_128471_("IsFree"));
        }
        this.rules.clear();
        this.rules = TradeRule.readRules(nbt);
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.rules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.rules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.rules.forEach(rule -> rule.afterTrade(event));
    }

    @Override
    public List<TradeRule> getRules() {
        return this.rules;
    }

    public void setRules(List<TradeRule> rules) {
        this.rules = rules;
    }

    @Override
    public void clearRules() {
        this.rules.clear();
    }

    public void addTradeRuleAlerts(List<Component> alerts, TradeContext context) {
        TradeEvent.PreTradeEvent pte;
        if (context.hasTrader() && context.hasPlayerReference() && (pte = context.getTrader().runPreTradeEvent(context.getPlayerReference(), this)).isCanceled()) {
            alerts.addAll(pte.getDenialReasons());
        }
    }

    @Override
    public void markRulesDirty() {
    }

    public abstract TradeComparisonResult compare(TradeData var1);

    public abstract boolean AcceptableDifferences(TradeComparisonResult var1);

    public abstract List<Component> GetDifferenceWarnings(TradeComparisonResult var1);

    public static class TradeComparisonResult {
        private boolean compatible = false;
        private List<ProductComparisonResult> tradeProductResults = new ArrayList<ProductComparisonResult>();
        private long priceChange = 0L;
        private boolean tradeTypeMatches = true;

        public boolean isCompatible() {
            return this.compatible;
        }

        public boolean ProductMatches() {
            for (ProductComparisonResult result : this.tradeProductResults) {
                if (result.Identical()) continue;
                return false;
            }
            return true;
        }

        public ProductComparisonResult getProductResult(int index) {
            if (index < 0 || index >= this.tradeProductResults.size()) {
                return null;
            }
            return this.tradeProductResults.get(index);
        }

        public int getProductResultCount() {
            return this.tradeProductResults.size();
        }

        public boolean PriceMatches() {
            return this.priceChange == 0L;
        }

        public long priceDifference() {
            return this.priceChange;
        }

        public boolean isPriceCheaper() {
            return this.priceChange > 0L;
        }

        public boolean isPriceExpensive() {
            return this.priceChange < 0L;
        }

        public boolean TypeMatches() {
            return this.tradeTypeMatches;
        }

        public boolean Identical() {
            return this.compatible && this.ProductMatches() && this.PriceMatches() && this.TypeMatches();
        }

        public void addProductResult(ProductComparisonResult result) {
            this.tradeProductResults.add(result);
        }

        public void addProductResults(Collection<? extends ProductComparisonResult> results) {
            this.tradeProductResults.addAll(results);
        }

        public void addProductResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
            this.tradeProductResults.add(new ProductComparisonResult(sameProduct, sameNBT, quantityDifference));
        }

        public void setPriceResult(long priceChange) {
            this.priceChange = priceChange;
        }

        public void setTypeResult(boolean typeMatches) {
            this.tradeTypeMatches = typeMatches;
        }

        public void setCompatible() {
            this.compatible = true;
        }

        public static class ProductComparisonResult {
            private final boolean sameProduct;
            private final boolean sameNBT;
            private final int quantityDifference;

            public boolean Identical() {
                return this.SameProductType() && this.SameProductNBT() && this.SameProductQuantity();
            }

            public boolean SameProductType() {
                return this.sameProduct;
            }

            public boolean SameProductNBT() {
                return this.sameNBT;
            }

            public boolean SameProductQuantity() {
                return this.quantityDifference == 0;
            }

            public int ProductQuantityDifference() {
                return this.quantityDifference;
            }

            private ProductComparisonResult(boolean sameProduct, boolean sameNBT, int quantityDifference) {
                this.sameProduct = sameProduct;
                this.sameNBT = sameNBT;
                this.quantityDifference = quantityDifference;
            }

            public static ProductComparisonResult CompareItem(ItemStack original, ItemStack query) {
                boolean isItemEqual;
                boolean bl = isItemEqual = original.m_41720_() == query.m_41720_();
                boolean isTagEqual = original.m_41783_() != null ? original.m_41783_().equals((Object)query.m_41783_()) : query.m_41783_() == null;
                int quantityDifference = original.m_41613_() - query.m_41613_();
                return new ProductComparisonResult(isItemEqual, isTagEqual, quantityDifference);
            }

            public static List<ProductComparisonResult> CompareTwoItems(ItemStack original1, ItemStack original2, ItemStack query1, ItemStack query2) {
                boolean flipMatch;
                ArrayList<ProductComparisonResult> results = new ArrayList<ProductComparisonResult>();
                boolean bl = flipMatch = original1.m_41720_() == query2.m_41720_() && original2.m_41720_() == query1.m_41720_() && original1.m_41720_() != original2.m_41720_() && query1.m_41720_() != query2.m_41720_();
                if (flipMatch) {
                    results.add(ProductComparisonResult.CompareItem(original1, query2));
                    results.add(ProductComparisonResult.CompareItem(original2, query1));
                } else {
                    results.add(ProductComparisonResult.CompareItem(original1, query1));
                    results.add(ProductComparisonResult.CompareItem(original2, query2));
                }
                return results;
            }

            public static ProductComparisonResult CompareFluid(FluidStack original, FluidStack query) {
                boolean isFluidEqual;
                boolean bl = isFluidEqual = original.getFluid() == query.getFluid();
                boolean isTagEqual = original.getTag() != null ? original.getTag().equals((Object)query.getTag()) : query.getTag() == null;
                int quantityDifference = original.getAmount() - query.getAmount();
                return new ProductComparisonResult(isFluidEqual, isTagEqual, quantityDifference);
            }

            public static ProductComparisonResult CompareEnergy(int original, int query) {
                return new ProductComparisonResult(true, true, original - query);
            }
        }
    }

    public static enum TradeDirection {
        SALE(0, 1),
        PURCHASE(1, 0),
        NONE(-1, 0);

        public final int index;
        private final int nextIndex;

        public final TradeDirection next() {
            return TradeDirection.fromIndex(this.nextIndex);
        }

        private TradeDirection(int index, int nextIndex) {
            this.index = index;
            this.nextIndex = nextIndex;
        }

        public static TradeDirection fromIndex(int index) {
            for (TradeDirection d : TradeDirection.values()) {
                if (d.index != index) continue;
                return d;
            }
            return SALE;
        }
    }
}

