/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.trader.tradedata.rules;

import com.google.common.base.Supplier;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.TradeRuleScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.trader.tradedata.TradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FreeSample
extends TradeRule {
    public static final ResourceLocation TYPE = new ResourceLocation("lightmanscurrency", "free_sample");
    List<UUID> memory = new ArrayList<UUID>();

    public void resetMemory() {
        this.memory.clear();
    }

    public FreeSample() {
        super(TYPE);
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        if (this.giveDiscount(event.getPlayerReference().id) && event.getTrade().getTradeDirection() != TradeData.TradeDirection.PURCHASE) {
            event.applyCostMultiplier(0.0);
        }
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        if (this.giveDiscount(event.getPlayerReference().id)) {
            this.addToMemory(event.getPlayerReference().id);
            event.markDirty();
        }
    }

    private void addToMemory(UUID playerID) {
        if (!this.memory.contains(playerID)) {
            this.memory.add(playerID);
        }
    }

    public boolean giveDiscount(UUID playerID) {
        return !this.givenFreeSample(playerID);
    }

    private boolean givenFreeSample(UUID playerID) {
        return this.memory.contains(playerID);
    }

    @Override
    public CompoundTag write(CompoundTag compound) {
        ListTag memoryList = new ListTag();
        for (UUID entry : this.memory) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("id", entry);
            memoryList.add((Object)tag);
        }
        compound.m_128365_("Memory", (Tag)memoryList);
        return compound;
    }

    @Override
    public JsonObject saveToJson(JsonObject json) {
        return json;
    }

    @Override
    public void readNBT(CompoundTag compound) {
        if (compound.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = compound.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag tag = memoryList.m_128728_(i);
                if (!tag.m_128441_("id")) continue;
                this.memory.add(tag.m_128342_("id"));
            }
        }
    }

    @Override
    public void handleUpdateMessage(CompoundTag updateInfo) {
        if (updateInfo.m_128441_("ClearMemory")) {
            this.resetMemory();
        }
    }

    @Override
    public CompoundTag savePersistentData() {
        CompoundTag data = new CompoundTag();
        ListTag memoryList = new ListTag();
        for (UUID entry : this.memory) {
            CompoundTag tag = new CompoundTag();
            tag.m_128362_("id", entry);
            memoryList.add((Object)tag);
        }
        data.m_128365_("Memory", (Tag)memoryList);
        return data;
    }

    @Override
    public void loadPersistentData(CompoundTag data) {
        if (data.m_128425_("Memory", 9)) {
            this.memory.clear();
            ListTag memoryList = data.m_128437_("Memory", 10);
            for (int i = 0; i < memoryList.size(); ++i) {
                CompoundTag tag = memoryList.m_128728_(i);
                if (!tag.m_128441_("id")) continue;
                this.memory.add(tag.m_128342_("id"));
            }
        }
    }

    @Override
    public void loadFromJson(JsonObject json) {
    }

    @Override
    public IconData getButtonIcon() {
        return IconAndButtonUtil.ICON_FREE_SAMPLE;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public TradeRule.GUIHandler createHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
        return new GUIHandler(screen, rule);
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class GUIHandler
    extends TradeRule.GUIHandler {
        Button buttonClearMemory;

        private final FreeSample getRule() {
            if (this.getRuleRaw() instanceof FreeSample) {
                return (FreeSample)this.getRuleRaw();
            }
            return null;
        }

        GUIHandler(TradeRuleScreen screen, Supplier<TradeRule> rule) {
            super(screen, rule);
        }

        @Override
        public void initTab() {
            int n = this.screen.guiLeft() + 10;
            int n2 = this.screen.guiTop() + 50;
            Objects.requireNonNull(this.screen);
            this.buttonClearMemory = this.addCustomRenderable(new Button(n, n2, 176 - 20, 20, (Component)new TranslatableComponent("gui.button.lightmanscurrency.free_sample.reset"), this::PressClearMemoryButton));
        }

        @Override
        public void renderTab(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
            if (this.buttonClearMemory.m_5953_((double)mouseX, (double)mouseY)) {
                this.screen.m_96602_(poseStack, (Component)new TranslatableComponent("gui.button.lightmanscurrency.free_sample.reset.tooltip"), mouseX, mouseY);
            }
        }

        @Override
        public void onTabClose() {
            this.removeCustomWidget(this.buttonClearMemory);
        }

        @Override
        public void onScreenTick() {
        }

        void PressClearMemoryButton(Button button) {
            this.getRule().memory.clear();
            CompoundTag updateInfo = new CompoundTag();
            updateInfo.m_128379_("ClearMemory", true);
            this.screen.updateServer(TYPE, updateInfo);
        }
    }
}

