/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.NonNullList;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class CustomCreativeTab
extends CreativeModeTab {
    private final ItemSorter itemSorter;
    Supplier<ItemLike> iconItem;

    public CustomCreativeTab(String label, Supplier<ItemLike> iconItem) {
        super(label);
        this.iconItem = iconItem;
        this.itemSorter = new ItemSorter();
    }

    public ItemStack m_6976_() {
        if (this.iconItem != null) {
            return new ItemStack(this.iconItem.get());
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_6151_(NonNullList<ItemStack> items) {
        super.m_6151_(items);
        Collections.sort(items, this.itemSorter);
    }

    public void addToSortingList(List<ItemLike> extras) {
        this.itemSorter.addToSortingList(extras);
    }

    public void initSortingList(List<ItemLike> defaultList) {
        this.itemSorter.initSortingList(defaultList);
    }

    public void initSortingList2(List<RegistryObject<? extends ItemLike>> defaultList) {
        ArrayList<ItemLike> list = new ArrayList<ItemLike>();
        for (RegistryObject<? extends ItemLike> item : defaultList) {
            ItemLike i = (ItemLike)item.get();
            if (i == null) continue;
            list.add(i);
        }
        this.itemSorter.initSortingList(list);
    }

    private static class ItemSorter
    implements Comparator<ItemStack> {
        private ArrayList<Item> sortList = null;

        private ArrayList<Item> convertList(List<ItemLike> sourceList) {
            ArrayList list = Lists.newArrayList();
            for (int i = 0; i < sourceList.size(); ++i) {
                list.add(sourceList.get(i).m_5456_());
            }
            return list;
        }

        public void initSortingList(List<ItemLike> sortList) {
            if (this.sortList == null) {
                this.sortList = this.convertList(sortList);
            } else {
                ArrayList<Item> copyList = this.sortList;
                this.sortList = this.convertList(sortList);
                for (int i = 0; i < copyList.size(); ++i) {
                    this.sortList.add((Item)copyList.get(i));
                }
            }
        }

        public void addToSortingList(List<ItemLike> extras) {
            if (this.sortList == null) {
                this.sortList = this.convertList(extras);
                return;
            }
            for (int i = 0; i < extras.size(); ++i) {
                this.sortList.add(extras.get(i).m_5456_());
            }
            LightmansCurrency.LogInfo("Added " + extras.size() + " items to the creative tab sorting list.");
        }

        @Override
        public int compare(ItemStack o1, ItemStack o2) {
            Item item1 = o1.m_41720_();
            Item item2 = o2.m_41720_();
            if (this.sortList == null) {
                LightmansCurrency.LogWarning("No sortlist defined for this CurrencyGroup.");
                return 0;
            }
            if (this.sortList.contains(item1) && !this.sortList.contains(item2)) {
                return -1;
            }
            if (!this.sortList.contains(item1) && this.sortList.contains(item2)) {
                return 1;
            }
            if (this.sortListContains(item1) && this.sortListContains(item2)) {
                int index2;
                int index1 = this.indexOf(item1);
                if (index1 < (index2 = this.indexOf(item2))) {
                    return -1;
                }
                if (index1 > index2) {
                    return 1;
                }
                return 0;
            }
            return 0;
        }

        private boolean sortListContains(Item item) {
            return this.indexOf(item) >= 0;
        }

        private int indexOf(Item item) {
            for (int i = 0; i < this.sortList.size(); ++i) {
                if (item != this.sortList.get(i)) continue;
                return i;
            }
            return -1;
        }
    }
}

