/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency;

import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CustomCreativeTab;
import io.github.lightman314.lightmanscurrency.Reference;
import io.github.lightman314.lightmanscurrency.common.atm.ATMIconData;
import io.github.lightman314.lightmanscurrency.common.capability.ISpawnTracker;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.AuctionHouseCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.BankCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.categories.TraderCategory;
import io.github.lightman314.lightmanscurrency.common.notifications.types.ItemTradeNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.LowBalanceNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.OutOfStockNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseBuyerNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseCancelNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNobidNotification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.auction.AuctionHouseSellerNotification;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.auction.AuctionHouseTrader;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalItemTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.ItemTraderSearchFilter;
import io.github.lightman314.lightmanscurrency.common.universal_traders.traderSearching.TraderSearchFilter;
import io.github.lightman314.lightmanscurrency.core.ModBlocks;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.core.ModRegistries;
import io.github.lightman314.lightmanscurrency.discord.CurrencyMessages;
import io.github.lightman314.lightmanscurrency.discord.DiscordListenerRegistration;
import io.github.lightman314.lightmanscurrency.enchantments.LCEnchantmentCategories;
import io.github.lightman314.lightmanscurrency.gamerule.ModGameRules;
import io.github.lightman314.lightmanscurrency.integration.curios.LCCurios;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.loot.LootManager;
import io.github.lightman314.lightmanscurrency.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.time.MessageSyncClientTime;
import io.github.lightman314.lightmanscurrency.proxy.ClientProxy;
import io.github.lightman314.lightmanscurrency.proxy.CommonProxy;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.FreeSample;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerBlacklist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerDiscounts;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerTradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.PlayerWhitelist;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TimedSale;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeLimit;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.upgrades.UpgradeType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.curios.api.SlotTypeMessage;

@Mod(value="lightmanscurrency")
public class LightmansCurrency {
    public static final String MODID = "lightmanscurrency";
    public static final CommonProxy PROXY = (CommonProxy)DistExecutor.safeRunForDist(() -> ClientProxy::new, () -> CommonProxy::new);
    private static final Logger LOGGER = LogManager.getLogger();
    public static final CustomCreativeTab COIN_GROUP = new CustomCreativeTab("lightmanscurrency.coins", () -> (ItemLike)ModBlocks.COINPILE_GOLD.get());
    public static final CustomCreativeTab MACHINE_GROUP = new CustomCreativeTab("lightmanscurrency.machines", () -> (ItemLike)ModBlocks.MACHINE_ATM.get());
    public static final CustomCreativeTab UPGRADE_GROUP = new CustomCreativeTab("lightmanscurrency.upgrades", () -> (ItemLike)ModItems.ITEM_CAPACITY_UPGRADE_1.get());
    public static final CustomCreativeTab TRADING_GROUP = new CustomCreativeTab("lightmanscurrency.trading", () -> (ItemLike)ModBlocks.DISPLAY_CASE.get());
    private static boolean discordIntegrationLoaded = false;
    private static boolean curiosLoaded = false;

    public static boolean isDiscordIntegrationLoaded() {
        return discordIntegrationLoaded;
    }

    public static boolean isCuriosLoaded() {
        return curiosLoaded;
    }

    public static boolean isCuriosValid(LivingEntity player) {
        try {
            if (curiosLoaded) {
                return LCCurios.hasWalletSlot(player);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    public LightmansCurrency() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doCommonStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::registerCapabilities);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::imc);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)Config.clientSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.commonSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.serverSpec);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModRegistries.register(FMLJavaModLoadingContext.get().getModEventBus());
        MinecraftForge.EVENT_BUS.register((Object)PROXY);
        discordIntegrationLoaded = ModList.get().isLoaded("lightmansdiscord");
        curiosLoaded = ModList.get().isLoaded("curios");
        if (discordIntegrationLoaded) {
            MinecraftForge.EVENT_BUS.register(DiscordListenerRegistration.class);
            CurrencyMessages.init();
        }
    }

    private void imc(InterModEnqueueEvent event) {
        if (LightmansCurrency.isCuriosLoaded()) {
            InterModComms.sendTo((String)"curios", (String)"register_type", () -> new SlotTypeMessage.Builder("wallet").icon(WalletSlot.EMPTY_WALLET_SLOT).size(1).build());
        }
    }

    private void doCommonStuff(FMLCommonSetupEvent event) {
        LightmansCurrencyPacketHandler.init();
        TradingOffice.RegisterDataType(UniversalItemTraderData.TYPE, (Supplier<? extends UniversalTraderData>)((Supplier)UniversalItemTraderData::new));
        TradingOffice.RegisterDataType(AuctionHouseTrader.TYPE, (Supplier<? extends UniversalTraderData>)((Supplier)AuctionHouseTrader::new));
        ModGameRules.registerRules();
        TradeRule.RegisterDeserializer(PlayerWhitelist.TYPE, (Supplier<TradeRule>)((Supplier)PlayerWhitelist::new));
        TradeRule.RegisterDeserializer(PlayerBlacklist.TYPE, (Supplier<TradeRule>)((Supplier)PlayerBlacklist::new));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)PlayerTradeLimit::new));
        TradeRule.RegisterDeserializer(PlayerTradeLimit.OLD_TYPE, (Supplier<TradeRule>)((Supplier)PlayerTradeLimit::new), true);
        TradeRule.RegisterDeserializer(PlayerDiscounts.TYPE, (Supplier<TradeRule>)((Supplier)PlayerDiscounts::new));
        TradeRule.RegisterDeserializer(TimedSale.TYPE, (Supplier<TradeRule>)((Supplier)TimedSale::new));
        TradeRule.RegisterDeserializer(TradeLimit.TYPE, (Supplier<TradeRule>)((Supplier)TradeLimit::new));
        TradeRule.RegisterDeserializer(TradeLimit.OLD_TYPE, (Supplier<TradeRule>)((Supplier)TradeLimit::new), true);
        TradeRule.RegisterDeserializer(FreeSample.TYPE, (Supplier<TradeRule>)((Supplier)FreeSample::new));
        Notification.register(ItemTradeNotification.TYPE, ItemTradeNotification::new);
        Notification.register(PaygateNotification.TYPE, PaygateNotification::new);
        Notification.register(OutOfStockNotification.TYPE, OutOfStockNotification::new);
        Notification.register(LowBalanceNotification.TYPE, LowBalanceNotification::new);
        Notification.register(AuctionHouseSellerNotification.TYPE, AuctionHouseSellerNotification::new);
        Notification.register(AuctionHouseBuyerNotification.TYPE, AuctionHouseBuyerNotification::new);
        Notification.register(AuctionHouseSellerNobidNotification.TYPE, AuctionHouseSellerNobidNotification::new);
        Notification.register(AuctionHouseBidNotification.TYPE, AuctionHouseBidNotification::new);
        Notification.register(AuctionHouseCancelNotification.TYPE, AuctionHouseCancelNotification::new);
        Notification.Category.register(Notification.Category.GENERAL_TYPE, compound -> Notification.Category.GENERAL);
        Notification.Category.register(TraderCategory.TYPE, TraderCategory::new);
        Notification.Category.register(BankCategory.TYPE, BankCategory::new);
        Notification.Category.register(AuctionHouseCategory.TYPE, compound -> AuctionHouseCategory.INSTANCE);
        TraderSearchFilter.addFilter(new ItemTraderSearchFilter());
        MinecraftForge.EVENT_BUS.post((Event)new UpgradeType.RegisterUpgradeTypeEvent());
        COIN_GROUP.m_40781_(new EnchantmentCategory[]{LCEnchantmentCategories.WALLET_CATEGORY, LCEnchantmentCategories.WALLET_PICKUP_CATEGORY});
        COIN_GROUP.initSortingList2(Lists.newArrayList((Object[])new RegistryObject[]{ModItems.COIN_COPPER, ModItems.COIN_IRON, ModItems.COIN_GOLD, ModItems.COIN_EMERALD, ModItems.COIN_DIAMOND, ModItems.COIN_NETHERITE, ModBlocks.COINPILE_COPPER, ModBlocks.COINPILE_IRON, ModBlocks.COINPILE_GOLD, ModBlocks.COINPILE_EMERALD, ModBlocks.COINPILE_DIAMOND, ModBlocks.COINPILE_NETHERITE, ModBlocks.COINBLOCK_COPPER, ModBlocks.COINBLOCK_IRON, ModBlocks.COINBLOCK_GOLD, ModBlocks.COINBLOCK_EMERALD, ModBlocks.COINBLOCK_DIAMOND, ModBlocks.COINBLOCK_NETHERITE, ModItems.TRADING_CORE, ModItems.TICKET, ModItems.TICKET_MASTER, ModItems.TICKET_STUB, ModItems.WALLET_COPPER, ModItems.WALLET_IRON, ModItems.WALLET_GOLD, ModItems.WALLET_EMERALD, ModItems.WALLET_DIAMOND, ModItems.WALLET_NETHERITE}));
        MACHINE_GROUP.initSortingList2(Lists.newArrayList((Object[])new RegistryObject[]{ModBlocks.MACHINE_ATM, ModItems.PORTABLE_ATM, ModBlocks.MACHINE_MINT, ModBlocks.CASH_REGISTER, ModBlocks.TERMINAL, ModItems.PORTABLE_TERMINAL, ModBlocks.GEM_TERMINAL, ModItems.PORTABLE_GEM_TERMINAL, ModBlocks.ITEM_TRADER_INTERFACE, ModBlocks.PAYGATE, ModBlocks.TICKET_MACHINE}));
        UPGRADE_GROUP.initSortingList2(Lists.newArrayList((Object[])new RegistryObject[]{ModItems.ITEM_CAPACITY_UPGRADE_1, ModItems.ITEM_CAPACITY_UPGRADE_2, ModItems.ITEM_CAPACITY_UPGRADE_3, ModItems.SPEED_UPGRADE_1, ModItems.SPEED_UPGRADE_2, ModItems.SPEED_UPGRADE_3, ModItems.SPEED_UPGRADE_4, ModItems.SPEED_UPGRADE_5}));
        TRADING_GROUP.initSortingList(Lists.newArrayList((Object[])new ItemLike[]{(ItemLike)ModBlocks.SHELF.get(Reference.WoodType.OAK), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.BIRCH), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.SPRUCE), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.JUNGLE), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.ACACIA), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.DARK_OAK), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.CRIMSON), (ItemLike)ModBlocks.SHELF.get(Reference.WoodType.WARPED), (ItemLike)ModBlocks.DISPLAY_CASE.get(), (ItemLike)ModBlocks.ARMOR_DISPLAY.get(), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.OAK), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.BIRCH), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.SPRUCE), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.JUNGLE), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.ACACIA), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.DARK_OAK), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.CRIMSON), (ItemLike)ModBlocks.CARD_DISPLAY.get(Reference.WoodType.WARPED), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.WHITE), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.ORANGE), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.MAGENTA), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.LIGHTBLUE), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.YELLOW), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.LIME), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.PINK), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.GRAY), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.LIGHTGRAY), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.CYAN), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.PURPLE), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.BLUE), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.BROWN), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.GREEN), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.RED), (ItemLike)ModBlocks.VENDING_MACHINE.get(Reference.Color.BLACK), (ItemLike)ModBlocks.FREEZER.get(), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.WHITE), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.ORANGE), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.MAGENTA), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.LIGHTBLUE), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.YELLOW), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.LIME), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.PINK), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.GRAY), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.LIGHTGRAY), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.CYAN), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.PURPLE), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.BLUE), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.BROWN), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.GREEN), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.RED), (ItemLike)ModBlocks.VENDING_MACHINE_LARGE.get(Reference.Color.BLACK), (ItemLike)ModBlocks.TICKET_KIOSK.get(), (ItemLike)ModBlocks.ITEM_TRADER_SERVER_SMALL.get(), (ItemLike)ModBlocks.ITEM_TRADER_SERVER_MEDIUM.get(), (ItemLike)ModBlocks.ITEM_TRADER_SERVER_LARGE.get(), (ItemLike)ModBlocks.ITEM_TRADER_SERVER_EXTRA_LARGE.get()}));
        ATMIconData.init();
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        PROXY.setupClient();
    }

    private void onConfigLoad(ModConfigEvent event) {
        if (event.getConfig().getModId().equals(MODID) && event.getConfig().getSpec() == Config.commonSpec) {
            LootManager.validateEntityDropList();
            LootManager.debugLootConfigs();
            if (event instanceof ModConfigEvent.Loading) {
                Config.reloadVillagerOverrides();
            }
        }
    }

    private void registerCapabilities(RegisterCapabilitiesEvent event) {
        event.register(IWalletHandler.class);
        event.register(ISpawnTracker.class);
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        PacketDistributor.PacketTarget target = LightmansCurrencyPacketHandler.getTarget(event.getPlayer());
        LightmansCurrencyPacketHandler.instance.send(target, (Object)new MessageSyncClientTime());
        LightmansCurrencyPacketHandler.instance.send(target, (Object)TradingOffice.getAdminSyncMessage());
    }

    public static ItemStack getWalletStack(Player player) {
        ItemStack wallet = ItemStack.f_41583_;
        IWalletHandler walletHandler = (IWalletHandler)WalletCapability.getWalletHandler((Entity)player).orElse(null);
        if (walletHandler != null) {
            wallet = walletHandler.getWallet();
        }
        if (!WalletItem.validWalletStack(wallet)) {
            LightmansCurrency.LogError(player.m_7755_().getString() + "'s equipped wallet is not a valid WalletItem.");
            LightmansCurrency.LogError("Equipped wallet is of type " + wallet.m_41720_().getClass().getName());
            return ItemStack.f_41583_;
        }
        return wallet;
    }

    public static void LogDebug(String message) {
        LOGGER.debug(message);
    }

    public static void LogInfo(String message) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 0) {
            LOGGER.debug("INFO: " + message);
        } else {
            LOGGER.info(message);
        }
    }

    public static void LogWarning(String message) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 1) {
            LOGGER.debug("WARN: " + message);
        } else {
            LOGGER.warn(message);
        }
    }

    public static void LogError(String message, Object ... objects) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message, objects);
        } else {
            LOGGER.error(message, objects);
        }
    }

    public static void LogError(String message) {
        if (Config.COMMON != null && (Integer)Config.COMMON.debugLevel.get() > 2) {
            LOGGER.debug("ERROR: " + message);
        } else {
            LOGGER.error(message);
        }
    }
}

