/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.trader.ITrader;
import io.github.lightman314.lightmanscurrency.trader.ITraderSource;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.network.NetworkHooks;

public class CashRegisterBlockEntity
extends BlockEntity
implements ITraderSource {
    List<BlockPos> positions = new ArrayList<BlockPos>();

    public CashRegisterBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.CASH_REGISTER.get(), pos, state);
    }

    public void loadDataFromItems(CompoundTag itemTag) {
        if (itemTag == null) {
            return;
        }
        this.readPositions(itemTag);
    }

    public void OpenContainer(Player player) {
        TraderBlockEntity.TradeMenuProvider<CashRegisterBlockEntity> provider = new TraderBlockEntity.TradeMenuProvider<CashRegisterBlockEntity>(this);
        if (!(player instanceof ServerPlayer)) {
            LightmansCurrency.LogError("Player is not a server player entity. Cannot open the trade menu.");
            return;
        }
        if (this.getTraders().size() > 0) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), provider, (BlockPos)this.f_58858_);
        } else {
            player.m_6352_((Component)new TranslatableComponent("message.lightmanscurrency.cash_register.notlinked"), new UUID(0L, 0L));
        }
    }

    @Override
    public boolean isSingleTrader() {
        return false;
    }

    @Override
    public List<ITrader> getTraders() {
        ArrayList<ITrader> traders = new ArrayList<ITrader>();
        for (int i = 0; i < this.positions.size(); ++i) {
            BlockEntity be = this.f_58857_.m_7702_(this.positions.get(i));
            if (!(be instanceof ITrader)) continue;
            traders.add((ITrader)be);
        }
        return traders;
    }

    public void m_183515_(CompoundTag compound) {
        ListTag storageList = new ListTag();
        for (int i = 0; i < this.positions.size(); ++i) {
            CompoundTag thisEntry = new CompoundTag();
            BlockPos thisPos = this.positions.get(i);
            thisEntry.m_128405_("x", thisPos.m_123341_());
            thisEntry.m_128405_("y", thisPos.m_123342_());
            thisEntry.m_128405_("z", thisPos.m_123343_());
            storageList.add((Object)thisEntry);
        }
        if (storageList.size() > 0) {
            compound.m_128365_("TraderPos", (Tag)storageList);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        this.readPositions(compound);
        super.m_142466_(compound);
    }

    private void readPositions(CompoundTag compound) {
        if (compound.m_128441_("TraderPos")) {
            this.positions = new ArrayList<BlockPos>();
            ListTag storageList = compound.m_128437_("TraderPos", 10);
            for (int i = 0; i < storageList.size(); ++i) {
                CompoundTag thisEntry = storageList.m_128728_(i);
                if (!thisEntry.m_128441_("x") || !thisEntry.m_128441_("y") || !thisEntry.m_128441_("z")) continue;
                BlockPos thisPos = new BlockPos(thisEntry.m_128451_("x"), thisEntry.m_128451_("y"), thisEntry.m_128451_("z"));
                this.positions.add(thisPos);
            }
        }
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }
}

