/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ItemShopLogger;
import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.handler.TraderItemHandler;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageUpdateTradeRule;
import io.github.lightman314.lightmanscurrency.trader.IItemTrader;
import io.github.lightman314.lightmanscurrency.trader.common.TraderItemStorage;
import io.github.lightman314.lightmanscurrency.trader.settings.ItemTraderSettings;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.ItemTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemTraderBlockEntity
extends TraderBlockEntity
implements IItemTrader {
    public static final int VERSION = 1;
    TraderItemHandler itemHandler = new TraderItemHandler(this);
    ItemTraderSettings itemSettings = new ItemTraderSettings(this, this::markItemSettingsDirty, this::sendSettingsUpdateToServer);
    protected TraderItemStorage storage = new TraderItemStorage(this);
    Container upgradeInventory = new SimpleContainer(5);
    private final ItemShopLogger logger = new ItemShopLogger();
    protected int tradeCount = 1;
    private long rotationTime = 0L;
    protected List<ItemTradeData> trades;
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    @Override
    public IItemHandler getItemHandler(Direction relativeSide) {
        return this.itemHandler.getHandler(relativeSide);
    }

    @Override
    public Map<String, Integer> getAllyDefaultPermissions() {
        return ImmutableMap.of((Object)"changeExternalInputs", (Object)1);
    }

    @Override
    public Container getUpgradeInventory() {
        return this.upgradeInventory;
    }

    @Override
    public void markUpgradesDirty() {
        this.m_6596_();
        if (!this.isClient()) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeUpgradeInventory(new CompoundTag()));
        }
    }

    public ItemTraderBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.ITEM_TRADER.get(), pos, state);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.validateTradeRestrictions();
    }

    public ItemTraderBlockEntity(BlockPos pos, BlockState state, int tradeCount) {
        super((BlockEntityType)ModBlockEntities.ITEM_TRADER.get(), pos, state);
        this.tradeCount = tradeCount;
        this.trades = ItemTradeData.listOfSize(tradeCount);
        this.validateTradeRestrictions();
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.trades = ItemTradeData.listOfSize(this.tradeCount);
        this.validateTradeRestrictions();
    }

    protected ItemTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state, int tradeCount) {
        super(type, pos, state);
        this.tradeCount = tradeCount;
        this.trades = ItemTradeData.listOfSize(tradeCount);
        this.validateTradeRestrictions();
    }

    @Override
    public int getTradeCount() {
        return MathUtil.clamp(this.tradeCount, 1, 32);
    }

    @Override
    public void addTrade(Player requestor) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tradeCount >= 32) {
            return;
        }
        if (TradingOffice.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.tradeCount + 1);
            this.coreSettings.getLogger().LogAddRemoveTrade(requestor, true, this.tradeCount);
            this.markCoreSettingsDirty();
        } else {
            Settings.PermissionWarning(requestor, "add a trade slot", "LC_ADMIN_MODE");
        }
    }

    @Override
    public void removeTrade(Player requestor) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tradeCount <= 1) {
            return;
        }
        if (TradingOffice.isAdminPlayer(requestor)) {
            this.overrideTradeCount(this.tradeCount - 1);
            this.coreSettings.getLogger().LogAddRemoveTrade(requestor, false, this.tradeCount);
            this.markCoreSettingsDirty();
        } else {
            Settings.PermissionWarning(requestor, "remove a trade slot", "LC_ADMIN_MODE");
        }
    }

    public final void validateTradeRestrictions() {
        for (int i = 0; i < this.trades.size(); ++i) {
            ItemTradeData trade = this.trades.get(i);
            trade.setRestriction(this.getRestriction(i));
        }
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 32);
        List<ItemTradeData> oldTrades = this.trades;
        this.trades = ItemTradeData.listOfSize(this.getTradeCount());
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.validateTradeRestrictions();
        if (!this.f_58857_.f_46443_) {
            CompoundTag compound = this.writeTrades(new CompoundTag());
            BlockEntityUtil.sendUpdatePacket(this, this.writeStorage(compound));
        }
    }

    @Override
    public ItemTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new ItemTradeData();
        }
        return this.trades.get(tradeSlot);
    }

    @Override
    public List<ItemTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeTrades(new CompoundTag()));
        }
        this.m_6596_();
    }

    @Override
    public ItemTraderSettings getItemSettings() {
        return this.itemSettings;
    }

    @Override
    public List<Settings> getAdditionalSettings() {
        return Lists.newArrayList((Object[])new Settings[]{this.itemSettings});
    }

    @Override
    public void markItemSettingsDirty() {
        if (this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeItemSettings(new CompoundTag()));
        }
    }

    @Override
    public void markStorageDirty() {
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeStorage(new CompoundTag()));
        }
        this.m_6596_();
    }

    @Override
    public ItemShopLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeLogger(new CompoundTag()));
        }
        this.m_6596_();
    }

    @Override
    public int getTradeStock(int tradeSlot) {
        ItemTradeData trade = this.getTrade(tradeSlot);
        if (trade.sellItemsDefined()) {
            if (this.coreSettings.isCreative()) {
                return Integer.MAX_VALUE;
            }
            return trade.stockCount(this);
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Vector3f> GetStackRenderPos(int tradeSlot, boolean isDoubleTrade) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderPos(tradeSlot, this.m_58900_(), isDoubleTrade);
        }
        ArrayList<Vector3f> posList = new ArrayList<Vector3f>();
        posList.add(new Vector3f(0.0f, 0.0f, 0.0f));
        return posList;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, float partialTicks) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            List<Quaternion> rotation = traderBlock.GetStackRenderRot(tradeSlot, this.m_58900_());
            if (rotation == null) {
                rotation = new ArrayList<Quaternion>();
                rotation.add(Vector3f.f_122225_.m_122240_(((float)this.rotationTime + partialTicks) * 2.0f));
            }
            return rotation;
        }
        ArrayList<Quaternion> rotation = new ArrayList<Quaternion>();
        rotation.add(Vector3f.f_122225_.m_122240_(0.0f));
        return rotation;
    }

    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot) {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.GetStackRenderScale(tradeSlot, this.m_58900_());
        }
        return 0.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        Block block = this.m_58900_().m_60734_();
        if (block instanceof IItemTraderBlock) {
            IItemTraderBlock traderBlock = (IItemTraderBlock)block;
            return traderBlock.maxRenderIndex();
        }
        return 0;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeStorage(compound);
        this.writeTrades(compound);
        this.writeItemSettings(compound);
        this.writeUpgradeInventory(compound);
        this.writeLogger(compound);
        this.writeTradeRules(compound);
    }

    protected CompoundTag writeStorage(CompoundTag compound) {
        this.storage.save(compound, "Storage");
        return compound;
    }

    public CompoundTag writeTrades(CompoundTag compound) {
        compound.m_128405_("TradeLimit", this.tradeCount);
        ItemTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    public CompoundTag writeItemSettings(CompoundTag compound) {
        compound.m_128365_("ItemSettings", (Tag)this.itemSettings.save(new CompoundTag()));
        return compound;
    }

    public CompoundTag writeUpgradeInventory(CompoundTag compound) {
        InventoryUtil.saveAllItems("UpgradeInventory", compound, this.upgradeInventory);
        return compound;
    }

    public CompoundTag writeLogger(CompoundTag compound) {
        this.logger.write(compound);
        return compound;
    }

    public CompoundTag writeTradeRules(CompoundTag compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.m_128451_("TradeLimit"), 1, 32);
        }
        if (compound.m_128441_("Trades")) {
            this.trades = ItemTradeData.loadAllData(compound, this.getTradeCount());
            this.validateTradeRestrictions();
        }
        if (compound.m_128441_("Storage")) {
            this.storage.load(compound, "Storage");
        } else if (compound.m_128441_("Items")) {
            SimpleContainer container = InventoryUtil.loadAllItems("Items", compound, this.getTradeCount() * 9);
            this.storage.loadFromContainer((Container)container);
        }
        if (compound.m_128425_("UpgradeInventory", 9)) {
            this.upgradeInventory = InventoryUtil.loadAllItems("UpgradeInventory", compound, 5);
        }
        if (compound.m_128425_("ItemSettings", 10)) {
            this.itemSettings.load(compound.m_128469_("ItemSettings"));
        }
        this.logger.read(compound);
        if (compound.m_128425_("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        super.m_142466_(compound);
    }

    @Override
    public void dumpContents(List<ItemStack> contents) {
        contents.addAll(this.storage.getSplitContents());
        for (int i = 0; i < this.upgradeInventory.m_6643_(); ++i) {
            contents.add(this.upgradeInventory.m_8020_(i));
        }
    }

    public AABB getRenderBoundingBox() {
        if (this.m_58900_() != null) {
            return this.m_58900_().m_60812_((BlockGetter)this.f_58857_, this.f_58858_).m_83215_().m_82338_(this.f_58858_);
        }
        return super.getRenderBoundingBox();
    }

    @Override
    public void clientTick() {
        super.clientTick();
        ++this.rotationTime;
    }

    @Override
    public TraderItemStorage getStorage() {
        return this.storage;
    }

    @Override
    public int GetCurrentVersion() {
        return 1;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
        if (oldVersion < 1) {
            for (ItemTradeData trade : this.trades) {
                ItemStack tradeStack = trade.getSellItem(0);
                if (tradeStack.m_41619_()) continue;
                this.storage.forceAddItem(tradeStack);
            }
        }
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            LightmansCurrency.LogInfo("Blocked rule addition due to rule of same type already present.");
            return;
        }
        this.tradeRules.add(newRule);
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        if (!this.f_58857_.f_46443_) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeTradeRules(new CompoundTag()));
        }
        this.m_6596_();
    }

    public void closeRuleScreen(Player player) {
        this.openStorageMenu(player);
    }

    @Override
    public ITradeRuleScreenHandler getRuleScreenHandler(int tradeIndex) {
        return new TraderScreenHandler(this, tradeIndex);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        ItemInterfaceBlockEntity.IItemHandlerBlock handlerBlock;
        ItemInterfaceBlockEntity.IItemHandlerBlockEntity blockEntity;
        Block block;
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (block = this.m_58900_().m_60734_()) instanceof ItemInterfaceBlockEntity.IItemHandlerBlock && (blockEntity = (handlerBlock = (ItemInterfaceBlockEntity.IItemHandlerBlock)block).getItemHandlerEntity(this.m_58900_(), this.f_58857_, this.f_58858_)) != null) {
            IItemHandler handler = blockEntity.getItemHandler(handlerBlock.getRelativeSide(this.m_58900_(), side));
            if (handler != null) {
                return LazyOptional.of(() -> handler).cast();
            }
            return LazyOptional.empty();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void sendTradeRuleUpdateMessage(int tradeIndex, ResourceLocation type, CompoundTag updateInfo) {
        if (this.isClient()) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule(this.f_58858_, tradeIndex, type, updateInfo));
        }
    }

    @Override
    public void receiveTradeRuleMessage(Player player, int index, ResourceLocation ruleType, CompoundTag updateInfo) {
        if (!this.hasPermission(player, "editTradeRules")) {
            Settings.PermissionWarning(player, "edit trade rule", "editTradeRules");
            return;
        }
        if (index >= 0) {
            this.getTrade(index).updateRule(ruleType, updateInfo);
            this.markTradesDirty();
        } else {
            this.updateRule(ruleType, updateInfo);
            this.markRulesDirty();
        }
    }

    private static class TraderScreenHandler
    implements ITradeRuleScreenHandler {
        private final ItemTraderBlockEntity tileEntity;
        private final int tradeIndex;

        public TraderScreenHandler(ItemTraderBlockEntity tileEntity, int tradeIndex) {
            this.tileEntity = tileEntity;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            if (this.tradeIndex < 0) {
                return this.tileEntity;
            }
            return this.tileEntity.getTrade(this.tradeIndex);
        }

        @Override
        public void reopenLastScreen() {
            this.tileEntity.sendOpenStorageMessage();
        }

        @Override
        public void updateServer(ResourceLocation type, CompoundTag updateInfo) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule(this.tileEntity.f_58858_, this.tradeIndex, type, updateInfo));
        }

        @Override
        public boolean stillValid() {
            return !this.tileEntity.m_58901_();
        }
    }
}

