/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import com.google.common.collect.Lists;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.api.ILoggerSupport;
import io.github.lightman314.lightmanscurrency.api.PaygateLogger;
import io.github.lightman314.lightmanscurrency.blockentity.TraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.PaygateBlock;
import io.github.lightman314.lightmanscurrency.client.gui.screen.ITradeRuleScreenHandler;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.trade.TradeButton;
import io.github.lightman314.lightmanscurrency.common.notifications.Notification;
import io.github.lightman314.lightmanscurrency.common.notifications.types.PaygateNotification;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.core.ModItems;
import io.github.lightman314.lightmanscurrency.events.TradeEvent;
import io.github.lightman314.lightmanscurrency.items.TicketItem;
import io.github.lightman314.lightmanscurrency.menus.TraderStorageMenu;
import io.github.lightman314.lightmanscurrency.menus.traderstorage.paygate.PaygateTradeEditTab;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageAddOrRemoveTrade;
import io.github.lightman314.lightmanscurrency.network.message.trader.MessageUpdateTradeRule;
import io.github.lightman314.lightmanscurrency.trader.ITradeSource;
import io.github.lightman314.lightmanscurrency.trader.common.TradeContext;
import io.github.lightman314.lightmanscurrency.trader.settings.PlayerReference;
import io.github.lightman314.lightmanscurrency.trader.settings.Settings;
import io.github.lightman314.lightmanscurrency.trader.tradedata.PaygateTradeData;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.ITradeRuleHandler;
import io.github.lightman314.lightmanscurrency.trader.tradedata.rules.TradeRule;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.MathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.NonNullSupplier;

public class PaygateBlockEntity
extends TraderBlockEntity
implements ITradeRuleHandler,
ITradeRuleHandler.ITradeRuleMessageHandler,
ILoggerSupport<PaygateLogger>,
ITradeSource<PaygateTradeData> {
    public static final int VERSION = 0;
    public static final int DURATION_MIN = 1;
    public static final int DURATION_MAX = 1200;
    private int timer;
    PaygateLogger logger = new PaygateLogger();
    protected int tradeCount = 1;
    protected List<PaygateTradeData> trades;
    List<TradeRule> tradeRules = new ArrayList<TradeRule>();

    public PaygateBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)ModBlockEntities.PAYGATE.get(), pos, state);
    }

    public PaygateBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.trades = PaygateTradeData.listOfSize(1);
    }

    @Override
    public int getTradeCount() {
        return MathUtil.clamp(this.tradeCount, 1, 32);
    }

    @Override
    public boolean canEditTradeCount() {
        return true;
    }

    @Override
    public int getMaxTradeCount() {
        return 4;
    }

    @Override
    public void requestAddOrRemoveTrade(boolean isAdd) {
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageAddOrRemoveTrade(this.f_58858_, isAdd));
    }

    @Override
    public void addTrade(Player requestor) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tradeCount >= 32) {
            return;
        }
        if (this.tradeCount >= this.getMaxTradeCount() && !TradingOffice.isAdminPlayer(requestor)) {
            Settings.PermissionWarning(requestor, "add creative trade slot", "LC_ADMIN_MODE");
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Settings.PermissionWarning(requestor, "add trade slot", "editTrades");
            return;
        }
        this.overrideTradeCount(this.tradeCount + 1);
    }

    @Override
    public void removeTrade(Player requestor) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.tradeCount <= 1) {
            return;
        }
        if (!this.hasPermission(requestor, "editTrades")) {
            Settings.PermissionWarning(requestor, "remove trade slot", "editTrades");
            return;
        }
        this.overrideTradeCount(this.tradeCount - 1);
    }

    public void overrideTradeCount(int newTradeCount) {
        if (this.tradeCount == newTradeCount) {
            return;
        }
        this.tradeCount = MathUtil.clamp(newTradeCount, 1, 32);
        List<PaygateTradeData> oldTrades = this.trades;
        this.trades = PaygateTradeData.listOfSize(this.tradeCount);
        for (int i = 0; i < oldTrades.size() && i < this.trades.size(); ++i) {
            this.trades.set(i, oldTrades.get(i));
        }
        this.markTradesDirty();
    }

    @Override
    public PaygateTradeData getTrade(int tradeSlot) {
        if (tradeSlot < 0 || tradeSlot >= this.trades.size()) {
            LightmansCurrency.LogError("Cannot get trade in index " + tradeSlot + " from a trader with only " + this.trades.size() + " trades.");
            return new PaygateTradeData();
        }
        return this.trades.get(tradeSlot);
    }

    public List<PaygateTradeData> getAllTrades() {
        return this.trades;
    }

    @Override
    public List<? extends TradeButton.ITradeData> getTradeInfo() {
        return this.trades;
    }

    @Override
    public void markTradesDirty() {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeTrades(new CompoundTag()));
        }
    }

    @Override
    public List<Settings> getAdditionalSettings() {
        return Lists.newArrayList();
    }

    @Override
    public PaygateLogger getLogger() {
        return this.logger;
    }

    @Override
    public void clearLogger() {
        this.logger.clear();
        this.markLoggerDirty();
    }

    @Override
    public void markLoggerDirty() {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeLogger(new CompoundTag()));
        }
    }

    @Override
    public int getTradeStock(int tradeIndex) {
        return 1;
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeTimer(compound);
        this.writeTrades(compound);
        this.writeLogger(compound);
        this.writeTradeRules(compound);
    }

    public final CompoundTag writeTimer(CompoundTag compound) {
        compound.m_128405_("Timer", Math.max(this.timer, 0));
        return compound;
    }

    public final CompoundTag writeTrades(CompoundTag compound) {
        compound.m_128405_("TradeLimit", this.tradeCount);
        PaygateTradeData.saveAllData(compound, this.trades);
        return compound;
    }

    public final CompoundTag writeLogger(CompoundTag compound) {
        this.logger.write(compound);
        return compound;
    }

    public final CompoundTag writeTradeRules(CompoundTag compound) {
        TradeRule.writeRules(compound, this.tradeRules);
        return compound;
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        if (compound.m_128425_("TradeLimit", 3)) {
            this.tradeCount = MathUtil.clamp(compound.m_128451_("TradeLimit"), 1, 32);
        }
        if (compound.m_128441_("Trades")) {
            this.trades = PaygateTradeData.loadAllData(compound, this.getTradeCount());
        } else if (compound.m_128425_("Duration", 3) && this.trades.size() == 1 && !this.trades.get(0).isValid()) {
            PaygateTradeData trade;
            UUID ticketID;
            int duration = compound.m_128451_("Duration");
            ArrayList<PaygateTradeData> generatedTrades = new ArrayList<PaygateTradeData>();
            if (compound.m_128441_("TicketID") && (ticketID = compound.m_128342_("TicketID")) != null) {
                trade = new PaygateTradeData();
                trade.setDuration(duration);
                trade.setTicketID(ticketID);
                generatedTrades.add(trade);
            }
            if (compound.m_128441_("Price")) {
                CoinValue price = new CoinValue(new CoinValue.CoinValuePair[0]);
                price.readFromNBT(compound, "Price");
                if (price.getRawValue() > 0L || price.isFree()) {
                    trade = new PaygateTradeData();
                    trade.setDuration(duration);
                    trade.setCost(price);
                    generatedTrades.add(trade);
                }
            }
            if (generatedTrades.size() > 0) {
                this.trades = generatedTrades;
                this.tradeCount = this.trades.size();
            }
        }
        this.logger.read(compound);
        if (compound.m_128425_("Timer", 3)) {
            this.timer = Math.max(compound.m_128451_("Timer"), 0);
        }
        if (compound.m_128425_("TradeRules", 9)) {
            this.tradeRules = TradeRule.readRules(compound);
        }
        super.m_142466_(compound);
    }

    @Override
    public int GetCurrentVersion() {
        return 0;
    }

    @Override
    protected void onVersionUpdate(int oldVersion) {
    }

    @Override
    public void beforeTrade(TradeEvent.PreTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.beforeTrade(event));
    }

    @Override
    public void tradeCost(TradeEvent.TradeCostEvent event) {
        this.tradeRules.forEach(rule -> rule.tradeCost(event));
    }

    @Override
    public void afterTrade(TradeEvent.PostTradeEvent event) {
        this.tradeRules.forEach(rule -> rule.afterTrade(event));
    }

    public void addRule(TradeRule newRule) {
        if (newRule == null) {
            return;
        }
        for (int i = 0; i < this.tradeRules.size(); ++i) {
            if (newRule.type != this.tradeRules.get((int)i).type) continue;
            LightmansCurrency.LogInfo("Blocked rule addition due to rule of same type already present.");
            return;
        }
        this.tradeRules.add(newRule);
    }

    @Override
    public List<TradeRule> getRules() {
        return this.tradeRules;
    }

    public void setRules(List<TradeRule> rules) {
        this.tradeRules = rules;
    }

    public void removeRule(TradeRule rule) {
        if (this.tradeRules.contains(rule)) {
            this.tradeRules.remove(rule);
        }
    }

    @Override
    public void clearRules() {
        this.tradeRules.clear();
    }

    @Override
    public void markRulesDirty() {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeTradeRules(new CompoundTag()));
        }
    }

    public void closeRuleScreen(Player player) {
        this.openStorageMenu(player);
    }

    @Override
    public ITradeRuleScreenHandler getRuleScreenHandler(int tradeIndex) {
        return new TraderScreenHandler(this, tradeIndex);
    }

    @Override
    public void receiveTradeRuleMessage(Player player, int index, ResourceLocation ruleType, CompoundTag updateInfo) {
        if (!this.hasPermission(player, "editTradeRules")) {
            Settings.PermissionWarning(player, "edit trade rule", "editTradeRules");
            return;
        }
        if (index >= 0) {
            this.getTrade(index).updateRule(ruleType, updateInfo);
            this.markTradesDirty();
        } else {
            this.updateRule(ruleType, updateInfo);
            this.markRulesDirty();
        }
    }

    public boolean isActive() {
        return this.timer > 0;
    }

    public void activate(int duration) {
        this.timer = duration;
        this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(true)));
        this.markTimerDirty();
    }

    @Override
    public void serverTick() {
        if (this.timer > 0) {
            --this.timer;
            this.markTimerDirty();
            if (this.timer <= 0) {
                this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.f_58857_.m_8055_(this.f_58858_).m_61124_((Property)PaygateBlock.POWERED, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void markTimerDirty() {
        this.m_6596_();
        if (this.isServer()) {
            BlockEntityUtil.sendUpdatePacket(this, this.writeTimer(new CompoundTag()));
        }
    }

    public int getValidTicketTrade(Player player, ItemStack heldItem) {
        UUID ticketID;
        if (heldItem.m_41720_() == ModItems.TICKET.get() && (ticketID = TicketItem.GetTicketID(heldItem)) != null) {
            for (int i = 0; i < this.trades.size(); ++i) {
                PaygateTradeData trade = this.trades.get(i);
                if (!trade.isTicketTrade() || !trade.getTicketID().equals(ticketID) || this.runPreTradeEvent(PlayerReference.of(player), trade).isCanceled()) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public void initStorageTabs(TraderStorageMenu menu) {
        menu.setTab(2, new PaygateTradeEditTab(menu));
    }

    @Override
    public TradeContext.TradeResult ExecuteTrade(TradeContext context, int tradeIndex) {
        PaygateTradeData trade = this.getTrade(tradeIndex);
        if (trade == null) {
            LightmansCurrency.LogError("Trade at index " + tradeIndex + " is null. Cannot execute trade!");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (!trade.isValid()) {
            LightmansCurrency.LogWarning("Trade at index " + tradeIndex + " is not a valid trade. Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_INVALID_TRADE;
        }
        if (this.isActive()) {
            LightmansCurrency.LogWarning("Paygate is already activated. It cannot be activated until the previous timer is completed.");
            return TradeContext.TradeResult.FAIL_OUT_OF_STOCK;
        }
        if (!context.hasPlayerReference()) {
            return TradeContext.TradeResult.FAIL_NULL;
        }
        if (this.runPreTradeEvent(context.getPlayerReference(), trade).isCanceled()) {
            return TradeContext.TradeResult.FAIL_TRADE_RULE_DENIAL;
        }
        CoinValue price = this.runTradeCostEvent(context.getPlayerReference(), trade).getCostResult();
        if (trade.isTicketTrade()) {
            if (!trade.canAfford(context)) {
                LightmansCurrency.LogDebug("Ticket ID " + trade.getTicketID() + " could not be found in the players inventory to pay for trade " + tradeIndex + ". Cannot execute trade.");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            if (!context.canFitItem(new ItemStack((ItemLike)ModItems.TICKET_STUB.get()))) {
                LightmansCurrency.LogInfo("Not enough room for the ticket stub. Aborting trade!");
                return TradeContext.TradeResult.FAIL_NO_OUTPUT_SPACE;
            }
            if (!context.collectTicket(trade.getTicketID())) {
                LightmansCurrency.LogError("Unable to collect the ticket. Aborting Trade!");
                return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
            }
            context.putItem(new ItemStack((ItemLike)ModItems.TICKET_STUB.get()));
            this.activate(trade.getDuration());
            this.getLogger().AddLog(context.getPlayerReference(), trade, price, this.getCoreSettings().isCreative());
            this.markLoggerDirty();
            this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new PaygateNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory())));
            this.runPostTradeEvent(context.getPlayerReference(), trade, price);
            return TradeContext.TradeResult.SUCCESS;
        }
        if (!context.getPayment(price)) {
            LightmansCurrency.LogDebug("Not enough money is present for the trade at index " + tradeIndex + ". Cannot execute trade.");
            return TradeContext.TradeResult.FAIL_CANNOT_AFFORD;
        }
        this.activate(trade.getDuration());
        this.getLogger().AddLog(context.getPlayerReference(), trade, price, this.getCoreSettings().isCreative());
        this.markLoggerDirty();
        this.getCoreSettings().pushNotification((NonNullSupplier<Notification>)((NonNullSupplier)() -> new PaygateNotification(trade, price, context.getPlayerReference(), this.getNotificationCategory())));
        if (!this.isCreative()) {
            this.addStoredMoney(price);
        }
        this.runPostTradeEvent(context.getPlayerReference(), trade, price);
        return TradeContext.TradeResult.SUCCESS;
    }

    @Override
    public void dumpContents(List<ItemStack> contents) {
    }

    private static class TraderScreenHandler
    implements ITradeRuleScreenHandler {
        private final PaygateBlockEntity tileEntity;
        private final int tradeIndex;

        public TraderScreenHandler(PaygateBlockEntity tileEntity, int tradeIndex) {
            this.tileEntity = tileEntity;
            this.tradeIndex = tradeIndex;
        }

        @Override
        public ITradeRuleHandler ruleHandler() {
            if (this.tradeIndex < 0) {
                return this.tileEntity;
            }
            return this.tileEntity.getTrade(this.tradeIndex);
        }

        @Override
        public void reopenLastScreen() {
            this.tileEntity.sendOpenStorageMessage();
        }

        @Override
        public void updateServer(ResourceLocation type, CompoundTag updateInfo) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageUpdateTradeRule(this.tileEntity.f_58858_, this.tradeIndex, type, updateInfo));
        }

        @Override
        public boolean stillValid() {
            return !this.tileEntity.m_58901_();
        }
    }
}

