/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blockentity;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.interfaces.IOwnableBlockEntity;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.util.BlockEntityUtil;
import io.github.lightman314.lightmanscurrency.util.DebugUtil;
import io.github.lightman314.lightmanscurrency.util.InventoryUtil;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class UniversalTraderBlockEntity
extends BlockEntity
implements IOwnableBlockEntity {
    UUID traderID = null;
    private boolean allowRemoval = false;

    public boolean allowRemoval() {
        return this.allowRemoval;
    }

    public void flagAsRemovable() {
        this.allowRemoval = true;
    }

    public UniversalTraderData getData() {
        if (this.traderID != null) {
            return TradingOffice.getData(this.traderID);
        }
        LightmansCurrency.LogError("Trader ID is null. Cannot get the trader data (" + DebugUtil.getSideText(this.f_58857_) + ").");
        return null;
    }

    public UniversalTraderBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public UUID getTraderID() {
        return this.traderID;
    }

    public boolean hasPermission(Player player, String permission) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.hasPermission," + DebugUtil.getSideText((Entity)player) + ").");
            return true;
        }
        return this.getData().hasPermission(player, permission);
    }

    public int getPermissionLevel(Player player, String permission) {
        if (this.getData() == null) {
            LightmansCurrency.LogError("Trader Data for trader of id '" + this.traderID + "' is null (tileEntity.getPermissionLevel," + DebugUtil.getSideText((Entity)player) + ").");
            return Integer.MAX_VALUE;
        }
        return this.getData().getPermissionLevel(player, permission);
    }

    @Deprecated
    public void updateNames(Player player) {
    }

    @Override
    public boolean canBreak(Player player) {
        return this.hasPermission(player, "breakTrader");
    }

    public void init(Player owner) {
        this.init(owner, null);
    }

    public void init(Player owner, String customName) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        if (this.traderID == null) {
            UniversalTraderData traderData = this.createInitialData((Entity)owner);
            if (customName != null) {
                traderData.getCoreSettings().setCustomName(null, customName);
            }
            this.traderID = TradingOffice.registerTrader(traderData, owner);
            BlockEntityUtil.sendUpdatePacket(this);
        }
    }

    protected abstract UniversalTraderData createInitialData(Entity var1);

    public void m_183515_(CompoundTag compound) {
        if (this.traderID != null) {
            compound.m_128362_("ID", this.traderID);
        }
        super.m_183515_(compound);
    }

    public void m_142466_(CompoundTag compound) {
        if (compound.m_128441_("ID")) {
            this.traderID = compound.m_128342_("ID");
        }
        super.m_142466_(compound);
    }

    public void openStorageMenu(Player player) {
        if (!this.f_58857_.f_46443_ && this.getData() != null) {
            this.getData().openStorageMenu(player);
        }
    }

    public void onDestroyed() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        TradingOffice.removeTrader(this.traderID);
    }

    public void dumpContents(Level level, BlockState state, BlockPos pos) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        UniversalTraderData data = this.getData();
        if (data != null) {
            InventoryUtil.dumpContents(level, pos, data.dumpContents(state, true));
        }
    }
}

