/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks;

import io.github.lightman314.lightmanscurrency.blockentity.CoinJarBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.money.MoneyUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CoinJarBlock
extends RotatableBlock
implements EntityBlock {
    public CoinJarBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public CoinJarBlock(BlockBehaviour.Properties properties, VoxelShape shape) {
        super(properties, shape);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CoinJarBlockEntity(pos, state);
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jar = (CoinJarBlockEntity)blockEntity;
            jar.readItemTag(stack);
        }
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (!level.f_46443_) {
            CoinJarBlockEntity jar;
            ItemStack coinStack = player.m_21120_(hand);
            if (!MoneyUtil.isCoin(coinStack, false)) {
                return InteractionResult.SUCCESS;
            }
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof CoinJarBlockEntity && (jar = (CoinJarBlockEntity)blockEntity).addCoin(coinStack)) {
                coinStack.m_41774_(1);
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity tileEntity = level.m_7702_(pos);
        if (tileEntity instanceof CoinJarBlockEntity) {
            CoinJarBlockEntity jarEntity = (CoinJarBlockEntity)tileEntity;
            if (EnchantmentHelper.m_44836_((Enchantment)Enchantments.f_44985_, (LivingEntity)player) > 0) {
                ItemStack dropStack = new ItemStack((ItemLike)Item.m_41439_((Block)this), 1);
                if (jarEntity.getStorage().size() > 0) {
                    jarEntity.writeItemTag(dropStack);
                }
                Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)dropStack);
            } else {
                jarEntity.getStorage().forEach(coin -> Block.m_49840_((Level)level, (BlockPos)pos, (ItemStack)coin));
            }
        }
        super.m_5707_(level, pos, state, player);
    }
}

