/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.networktraders.templates;

import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.blockentity.UniversalTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.templates.RotatableBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.ITraderBlock;
import io.github.lightman314.lightmanscurrency.common.emergency_ejection.EjectionData;
import io.github.lightman314.lightmanscurrency.common.universal_traders.TradingOffice;
import io.github.lightman314.lightmanscurrency.common.universal_traders.data.UniversalTraderData;
import io.github.lightman314.lightmanscurrency.items.TooltipItem;
import io.github.lightman314.lightmanscurrency.items.tooltips.LCTooltips;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class NetworkTraderBlock
extends RotatableBlock
implements ITraderBlock,
EntityBlock {
    public NetworkTraderBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.createBlockEntity(pos, state);
    }

    protected abstract BlockEntity createBlockEntity(BlockPos var1, BlockState var2);

    public void m_6402_(Level level, BlockPos pos, BlockState state, LivingEntity player, ItemStack stack) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof UniversalTraderBlockEntity && player instanceof Player) {
            UniversalTraderBlockEntity trader = (UniversalTraderBlockEntity)blockEntity;
            if (stack.m_41788_()) {
                trader.init((Player)player, stack.m_41786_().getString());
            } else {
                trader.init((Player)player);
            }
        }
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof UniversalTraderBlockEntity) {
            UniversalTraderBlockEntity trader = (UniversalTraderBlockEntity)blockEntity;
            if (!trader.canBreak(player)) {
                return;
            }
            trader.dumpContents(level, state, pos);
            trader.onDestroyed();
            trader.flagAsRemovable();
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean flag) {
        BlockEntity blockEntity;
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        if (!level.f_46443_ && (blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos)) instanceof UniversalTraderBlockEntity) {
            UniversalTraderBlockEntity trader = (UniversalTraderBlockEntity)blockEntity;
            if (!trader.allowRemoval()) {
                UniversalTraderData traderData = trader.getData();
                if (traderData != null) {
                    LightmansCurrency.LogError("Trader block at " + pos.m_123341_() + " " + pos.m_123342_() + " " + pos.m_123343_() + " was broken by illegal means!");
                    LightmansCurrency.LogError("Activating emergency eject protocol.");
                    EjectionData data = EjectionData.create(state, traderData);
                    TradingOffice.handleEjectionData(level, pos, data);
                    trader.onDestroyed();
                    trader.flagAsRemovable();
                    try {
                        this.onInvalidRemoval(state, level, pos, traderData);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                LightmansCurrency.LogInfo("Trader block was broken by legal means!");
            }
        }
        super.m_6810_(state, level, pos, newState, flag);
    }

    protected abstract void onInvalidRemoval(BlockState var1, Level var2, BlockPos var3, UniversalTraderData var4);

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        UniversalTraderBlockEntity trader;
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof UniversalTraderBlockEntity && (trader = (UniversalTraderBlockEntity)blockEntity).hasPermission(player, "openStorage")) {
            trader.openStorageMenu(player);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockEntity getBlockEntity(BlockState state, LevelAccessor level, BlockPos pos) {
        return level.m_7702_(pos);
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flagIn) {
        TooltipItem.addTooltip(tooltip, LCTooltips.ITEM_NETWORK_TRADER);
        super.m_5871_(stack, level, tooltip, flagIn);
    }
}

