/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.blocks.traderblocks;

import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import io.github.lightman314.lightmanscurrency.blockentity.ItemInterfaceBlockEntity;
import io.github.lightman314.lightmanscurrency.blockentity.TicketTraderBlockEntity;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.interfaces.IItemTraderBlock;
import io.github.lightman314.lightmanscurrency.blocks.traderblocks.templates.TraderBlockTallRotatable;
import io.github.lightman314.lightmanscurrency.blocks.util.LazyShapes;
import io.github.lightman314.lightmanscurrency.core.ModBlockEntities;
import io.github.lightman314.lightmanscurrency.items.tooltips.LCTooltips;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.NonNullSupplier;

public class TicketKioskBlock
extends TraderBlockTallRotatable
implements IItemTraderBlock {
    public static final int TRADECOUNT = 4;
    private static final VoxelShape HORIZ_SHAPE = TicketKioskBlock.m_49796_((double)3.0, (double)0.0, (double)1.0, (double)13.0, (double)32.0, (double)15.0);
    private static final VoxelShape VERT_SHAPE = TicketKioskBlock.m_49796_((double)1.0, (double)0.0, (double)3.0, (double)15.0, (double)32.0, (double)13.0);

    public TicketKioskBlock(BlockBehaviour.Properties properties) {
        super(properties, LazyShapes.lazyTallDirectionalShape(VERT_SHAPE, HORIZ_SHAPE, VERT_SHAPE, HORIZ_SHAPE));
    }

    @Override
    public BlockEntity makeTrader(BlockPos pos, BlockState state) {
        return new TicketTraderBlockEntity(pos, state, 4);
    }

    @Override
    protected BlockEntity makeDummy(BlockPos pos, BlockState state) {
        return new ItemInterfaceBlockEntity(pos, state);
    }

    @Override
    public BlockEntityType<?> traderType() {
        return (BlockEntityType)ModBlockEntities.ITEM_TRADER.get();
    }

    @Override
    public List<Vector3f> GetStackRenderPos(int tradeSlot, BlockState state, boolean isDoubleBlock) {
        return new ArrayList<Vector3f>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public List<Quaternion> GetStackRenderRot(int tradeSlot, BlockState state) {
        return new ArrayList<Quaternion>();
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public float GetStackRenderScale(int tradeSlot, BlockState state) {
        return 0.0f;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int maxRenderIndex() {
        return -1;
    }

    @Override
    public Direction getRelativeSide(BlockState state, Direction side) {
        return ItemInterfaceBlockEntity.IItemHandlerBlock.getRelativeSide(this.getFacing(state), side);
    }

    @Override
    public ItemInterfaceBlockEntity.IItemHandlerBlockEntity getItemHandlerEntity(BlockState state, Level level, BlockPos pos) {
        BlockEntity blockEntity = this.getBlockEntity(state, (LevelAccessor)level, pos);
        if (blockEntity instanceof ItemInterfaceBlockEntity.IItemHandlerBlockEntity) {
            return (ItemInterfaceBlockEntity.IItemHandlerBlockEntity)blockEntity;
        }
        return null;
    }

    @Override
    protected NonNullSupplier<List<Component>> getItemTooltips() {
        return LCTooltips.ITEM_TRADER_TICKET;
    }
}

