/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import io.github.lightman314.lightmanscurrency.Config;
import io.github.lightman314.lightmanscurrency.CurrencySoundEvents;
import io.github.lightman314.lightmanscurrency.LightmansCurrency;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.WalletScreen;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.VisibilityToggleButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.NotificationButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TeamManagerButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.TraderRecoveryButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.inventory.WalletButton;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.common.capability.IWalletHandler;
import io.github.lightman314.lightmanscurrency.common.capability.WalletCapability;
import io.github.lightman314.lightmanscurrency.items.WalletItem;
import io.github.lightman314.lightmanscurrency.menus.slots.WalletSlot;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.wallet.MessageOpenWallet;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketSetVisible;
import io.github.lightman314.lightmanscurrency.network.message.walletslot.CPacketWalletInteraction;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.CreativeModeInventoryScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ContainerScreenEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="lightmanscurrency", value={Dist.CLIENT})
public class ClientEvents {
    public static final ResourceLocation WALLET_SLOT_TEXTURE = new ResourceLocation("lightmanscurrency", "textures/gui/container/wallet_slot.png");
    public static final KeyMapping KEY_WALLET = new KeyMapping("key.wallet", 86, "key.categories.inventory");

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91080_ instanceof WalletScreen) {
            if (event.getAction() == 1 && event.getKey() == KEY_WALLET.getKey().m_84873_()) {
                minecraft.f_91074_.m_108763_();
            }
        } else if (minecraft.f_91074_ != null && minecraft.f_91080_ == null) {
            LocalPlayer player = minecraft.f_91074_;
            if (KEY_WALLET.m_90857_()) {
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenWallet(-1));
                if (!LightmansCurrency.getWalletStack((Player)player).m_41619_()) {
                    minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)SoundEvents.f_11678_, (float)(1.25f + player.f_19853_.f_46441_.nextFloat() * 0.5f), (float)0.75f));
                    ItemStack wallet = LightmansCurrency.getWalletStack((Player)player);
                    if (!WalletItem.isEmpty(wallet)) {
                        minecraft.m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_119755_((SoundEvent)CurrencySoundEvents.COINS_CLINKING, (float)1.0f, (float)0.4f));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onInventoryGuiInit(ScreenEvent.InitScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            Minecraft mc = Minecraft.m_91087_();
            if (!LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
                Pair<Integer, Integer> slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen);
                int xPos = (Integer)slotPosition.getFirst() + (Integer)Config.CLIENT.walletButtonOffsetX.get();
                int yPos = (Integer)slotPosition.getSecond() + (Integer)Config.CLIENT.walletButtonOffsetY.get();
                event.addListener((GuiEventListener)new WalletButton(gui, xPos, yPos, b -> LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageOpenWallet(-1))));
                event.addListener((GuiEventListener)new VisibilityToggleButton(gui, (Integer)slotPosition.getFirst(), (Integer)slotPosition.getSecond(), ClientEvents::toggleVisibility));
            }
            event.addListener((GuiEventListener)new NotificationButton(gui));
            event.addListener((GuiEventListener)new TeamManagerButton(gui));
            event.addListener((GuiEventListener)new TraderRecoveryButton(gui));
        }
    }

    private static void toggleVisibility(Button button) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        IWalletHandler handler = (IWalletHandler)WalletCapability.getWalletHandler((Entity)player).orElse(null);
        if (handler != null) {
            boolean nowVisible = !handler.visible();
            handler.setVisible(nowVisible);
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketSetVisible(player.m_142049_(), nowVisible));
        }
    }

    @SubscribeEvent
    public static void renderInventoryScreen(ContainerScreenEvent.DrawBackground event) {
        Minecraft mc = Minecraft.m_91087_();
        if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
            return;
        }
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            if (screen instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)screen).m_98628_() != CreativeModeTab.f_40761_.m_40775_()) {
                return;
            }
            IWalletHandler walletHandler = ClientEvents.getWalletHandler();
            if (walletHandler == null) {
                return;
            }
            Pair<Integer, Integer> slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen);
            RenderSystem.m_157456_((int)0, (ResourceLocation)WALLET_SLOT_TEXTURE);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            screen.m_93228_(event.getPoseStack(), screen.getGuiLeft() + (Integer)slotPosition.getFirst(), screen.getGuiTop() + (Integer)slotPosition.getSecond(), 0, 0, 18, 18);
            ItemStack wallet = walletHandler.getWallet();
            if (wallet.m_41619_()) {
                ItemRenderUtil.drawSlotBackground(event.getPoseStack(), screen.getGuiLeft() + (Integer)slotPosition.getFirst() + 1, screen.getGuiTop() + (Integer)slotPosition.getSecond() + 1, WalletSlot.BACKGROUND);
            } else {
                ItemRenderUtil.drawItemStack((GuiComponent)screen, null, wallet, screen.getGuiLeft() + (Integer)slotPosition.getFirst() + 1, screen.getGuiTop() + (Integer)slotPosition.getSecond() + 1);
            }
            if (ClientEvents.isMouseOverWalletSlot(screen, event.getMouseX(), event.getMouseY(), slotPosition)) {
                AbstractContainerScreen.m_169606_((PoseStack)event.getPoseStack(), (int)(screen.getGuiLeft() + (Integer)slotPosition.getFirst() + 1), (int)(screen.getGuiTop() + (Integer)slotPosition.getSecond() + 1), (int)screen.m_93252_());
            }
        }
    }

    @SubscribeEvent
    public static void renderInventoryTooltips(ScreenEvent.DrawScreenEvent.Post event) {
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            if (!gui.m_6262_().m_142621_().m_41619_()) {
                return;
            }
            if (gui instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)gui).m_98628_() != CreativeModeTab.f_40761_.m_40775_()) {
                return;
            }
            Minecraft mc = Minecraft.m_91087_();
            if (!LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
                Pair<Integer, Integer> slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen);
                if (ClientEvents.isMouseOverWalletSlot(gui, event.getMouseX(), event.getMouseY(), slotPosition)) {
                    ItemStack wallet;
                    IWalletHandler walletHandler = ClientEvents.getWalletHandler();
                    ItemStack itemStack = wallet = walletHandler == null ? ItemStack.f_41583_ : walletHandler.getWallet();
                    if (!wallet.m_41619_()) {
                        screen.m_96597_(event.getPoseStack(), ItemRenderUtil.getTooltipFromItem(wallet), event.getMouseX(), event.getMouseY());
                    }
                }
            }
            NotificationButton.tryRenderTooltip(event.getPoseStack(), event.getMouseX(), event.getMouseY());
            TeamManagerButton.tryRenderTooltip(event.getPoseStack(), event.getMouseX(), event.getMouseY());
        }
    }

    @SubscribeEvent
    public static void onInventoryClick(ScreenEvent.MouseClickedEvent.Pre event) {
        Minecraft mc = Minecraft.m_91087_();
        if (LightmansCurrency.isCuriosValid((LivingEntity)mc.f_91074_)) {
            return;
        }
        Screen screen = event.getScreen();
        if (screen instanceof InventoryScreen || screen instanceof CreativeModeInventoryScreen) {
            Slot hoveredSlot;
            CreativeModeInventoryScreen creativeScreen;
            AbstractContainerScreen gui = (AbstractContainerScreen)screen;
            if (gui instanceof CreativeModeInventoryScreen && (creativeScreen = (CreativeModeInventoryScreen)gui).m_98628_() != CreativeModeTab.f_40761_.m_40775_()) {
                return;
            }
            Pair<Integer, Integer> slotPosition = ClientEvents.getWalletSlotPosition(screen instanceof CreativeModeInventoryScreen);
            if (ClientEvents.isMouseOverWalletSlot(gui, event.getMouseX(), event.getMouseY(), slotPosition) && !ClientEvents.isMouseOverVisibilityButton(gui, event.getMouseX(), event.getMouseY(), slotPosition)) {
                ItemStack heldStack = gui.m_6262_().m_142621_().m_41777_();
                boolean shiftHeld = Screen.m_96638_() && !(gui instanceof CreativeModeInventoryScreen);
                LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketWalletInteraction(-1, shiftHeld, heldStack));
                WalletCapability.WalletSlotInteraction(ClientEvents.getPlayer(), -1, shiftHeld, heldStack);
            } else if (Screen.m_96638_() && !(gui instanceof CreativeModeInventoryScreen) && (hoveredSlot = gui.getSlotUnderMouse()) != null) {
                int slotIndex;
                Player player = ClientEvents.getPlayer();
                int n = slotIndex = hoveredSlot.f_40218_ != player.m_150109_() ? -1 : hoveredSlot.m_150661_();
                if (slotIndex < 0) {
                    return;
                }
                ItemStack slotItem = player.m_150109_().m_8020_(slotIndex);
                if (WalletSlot.isValidWallet(slotItem)) {
                    ItemStack heldStack = gui.m_6262_().m_142621_().m_41777_();
                    LightmansCurrencyPacketHandler.instance.sendToServer((Object)new CPacketWalletInteraction(slotIndex, true, heldStack));
                    WalletCapability.WalletSlotInteraction(ClientEvents.getPlayer(), slotIndex, true, heldStack);
                    event.setCanceled(true);
                }
            }
        }
    }

    private static boolean isMouseOverWalletSlot(AbstractContainerScreen<?> gui, double mouseX, double mouseY, Pair<Integer, Integer> slotPosition) {
        int leftEdge = (Integer)slotPosition.getFirst() + gui.getGuiLeft();
        int topEdge = (Integer)slotPosition.getSecond() + gui.getGuiTop();
        return mouseX >= (double)leftEdge && mouseX < (double)(leftEdge + 18) && mouseY >= (double)topEdge && mouseY < (double)(topEdge + 18);
    }

    private static boolean isMouseOverVisibilityButton(AbstractContainerScreen<?> gui, double mouseX, double mouseY, Pair<Integer, Integer> slotPosition) {
        int leftEdge = (Integer)slotPosition.getFirst() + gui.getGuiLeft();
        int topEdge = (Integer)slotPosition.getSecond() + gui.getGuiTop();
        return mouseX >= (double)leftEdge && mouseX < (double)(leftEdge + 6) && mouseY >= (double)topEdge && mouseY < (double)(topEdge + 6);
    }

    private static IWalletHandler getWalletHandler() {
        Minecraft mc = Minecraft.m_91087_();
        return (IWalletHandler)WalletCapability.getWalletHandler((Entity)mc.f_91074_).orElse(null);
    }

    private static Player getPlayer() {
        Minecraft mc = Minecraft.m_91087_();
        return mc.f_91074_;
    }

    private static Pair<Integer, Integer> getWalletSlotPosition(boolean isCreative) {
        return isCreative ? Pair.of((Object)((Integer)Config.CLIENT.walletSlotCreativeX.get()), (Object)((Integer)Config.CLIENT.walletSlotCreativeY.get())) : Pair.of((Object)((Integer)Config.CLIENT.walletSlotX.get()), (Object)((Integer)Config.CLIENT.walletSlotY.get()));
    }
}

