/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageSetBankNotificationLevel;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;

public class NotificationTab
extends ATMTab {
    CoinValueInput notificationSelection;

    public NotificationTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconData.of((ItemLike)Items.f_42584_);
    }

    @Override
    public Component getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.atm.notification");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.m_6262_());
        Component accountName = ((ATMMenu)this.screen.m_6262_()).getPlayer().m_5446_();
        if (((ATMMenu)this.screen.m_6262_()).getBankAccount() != null) {
            accountName = ((ATMMenu)this.screen.m_6262_()).getBankAccount().getName();
        }
        this.notificationSelection = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft(), this.screen.getGuiTop(), accountName, ((ATMMenu)this.screen.m_6262_()).getBankAccount().getNotificationValue(), this.screen.getFont(), this::onValueChanged, this.screen::addRenderableTabWidget));
        this.notificationSelection.drawBG = false;
        this.notificationSelection.allowFreeToggle = false;
        this.notificationSelection.init();
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.hideCoinSlots(pose);
        BankAccount account = ((ATMMenu)this.screen.m_6262_()).getBankAccount();
        if (account != null) {
            TextRenderUtil.drawCenteredMultilineText(pose, (Component)(account.getNotificationLevel() > 0L ? new TranslatableComponent("gui.lightmanscurrency.notification.details", new Object[]{account.getNotificationValue().getString()}) : new TranslatableComponent("gui.lightmanscurrency.notification.disabled")), this.screen.getGuiLeft() + 5, this.screen.getXSize() - 10, this.screen.getGuiTop() + 70, 0x404040);
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
    }

    @Override
    public void tick() {
        this.notificationSelection.tick();
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.m_6262_());
    }

    public void onValueChanged(CoinValue value) {
        ((ATMMenu)this.screen.m_6262_()).getBankAccount().setNotificationValue(value);
        LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageSetBankNotificationLevel(value));
    }
}

