/*
 * Decompiled with CFR 0.152.
 */
package io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.vertex.PoseStack;
import io.github.lightman314.lightmanscurrency.client.ClientTradingOffice;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.ATMScreen;
import io.github.lightman314.lightmanscurrency.client.gui.screen.inventory.atm.ATMTab;
import io.github.lightman314.lightmanscurrency.client.gui.widget.CoinValueInput;
import io.github.lightman314.lightmanscurrency.client.gui.widget.TeamSelectWidget;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.IconButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.TeamButton;
import io.github.lightman314.lightmanscurrency.client.gui.widget.button.icon.IconData;
import io.github.lightman314.lightmanscurrency.client.util.IconAndButtonUtil;
import io.github.lightman314.lightmanscurrency.client.util.ItemRenderUtil;
import io.github.lightman314.lightmanscurrency.client.util.TextRenderUtil;
import io.github.lightman314.lightmanscurrency.common.teams.Team;
import io.github.lightman314.lightmanscurrency.common.universal_traders.bank.BankAccount;
import io.github.lightman314.lightmanscurrency.menus.ATMMenu;
import io.github.lightman314.lightmanscurrency.menus.slots.SimpleSlot;
import io.github.lightman314.lightmanscurrency.money.CoinValue;
import io.github.lightman314.lightmanscurrency.network.LightmansCurrencyPacketHandler;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferPlayer;
import io.github.lightman314.lightmanscurrency.network.message.bank.MessageBankTransferTeam;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Widget;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.NonNullSupplier;

public class TransferTab
extends ATMTab {
    public static final int RESPONSE_DURATION = 100;
    private int responseTimer = 0;
    CoinValueInput amountWidget;
    EditBox playerInput;
    TeamSelectWidget teamSelection;
    IconButton buttonToggleMode;
    Button buttonTransfer;
    UUID selectedTeam = null;
    boolean playerMode = true;

    public TransferTab(ATMScreen screen) {
        super(screen);
    }

    @Override
    public IconData getIcon() {
        return IconAndButtonUtil.ICON_STORE_COINS;
    }

    public MutableComponent getTooltip() {
        return new TranslatableComponent("tooltip.lightmanscurrency.atm.transfer");
    }

    @Override
    public void init() {
        SimpleSlot.SetInactive(this.screen.m_6262_());
        this.responseTimer = 0;
        ((ATMMenu)this.screen.m_6262_()).clearMessage();
        this.amountWidget = this.screen.addRenderableTabWidget(new CoinValueInput(this.screen.getGuiLeft(), this.screen.getGuiTop(), (Component)new TranslatableComponent("gui.lightmanscurrency.bank.transfertip"), CoinValue.EMPTY, this.screen.getFont(), value -> {}, this.screen::addRenderableTabWidget));
        this.amountWidget.init();
        this.amountWidget.allowFreeToggle = false;
        this.amountWidget.drawBG = false;
        this.buttonToggleMode = this.screen.addRenderableTabWidget(new IconButton(this.screen.getGuiLeft() + this.screen.getXSize() - 30, this.screen.getGuiTop() + 64, this::ToggleMode, this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of(ItemRenderUtil.getAlexHead()), (Button.OnTooltip)new IconAndButtonUtil.ToggleTooltip((NonNullSupplier<Boolean>)((NonNullSupplier)() -> this.playerMode), (Component)new TranslatableComponent("tooltip.lightmanscurrency.atm.transfer.mode.team"), (Component)new TranslatableComponent("tooltip.lightmanscurrency.atm.transfer.mode.player"))));
        this.playerInput = this.screen.addRenderableTabWidget(new EditBox(this.screen.getFont(), this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 104, this.screen.getXSize() - 20, 20, (Component)new TextComponent("")));
        this.playerInput.f_93624_ = this.playerMode;
        this.teamSelection = this.screen.addRenderableTabWidget(new TeamSelectWidget(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 84, 2, TeamButton.Size.NORMAL, this::getTeamList, this::selectedTeam, this::SelectTeam));
        this.teamSelection.init(this.screen::addRenderableTabWidget, this.screen.getFont());
        this.teamSelection.f_93624_ = !this.playerMode;
        this.buttonTransfer = this.screen.addRenderableTabWidget(new Button(this.screen.getGuiLeft() + 10, this.screen.getGuiTop() + 126, this.screen.getXSize() - 20, 20, (Component)new TranslatableComponent(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team"), this::PressTransfer));
        this.buttonTransfer.f_93623_ = false;
    }

    private List<Team> getTeamList() {
        ArrayList results = Lists.newArrayList();
        BankAccount.AccountReference source = ((ATMMenu)this.screen.m_6262_()).getBankAccountReference();
        Team blockTeam = null;
        if (source != null && source.accountType == BankAccount.AccountType.Team) {
            blockTeam = ClientTradingOffice.getTeam(source.id);
        }
        for (Team team : ClientTradingOffice.getTeamList()) {
            if (!team.hasBankAccount() || team == blockTeam) continue;
            results.add(team);
        }
        return results;
    }

    public Team selectedTeam() {
        if (this.selectedTeam != null) {
            return ClientTradingOffice.getTeam(this.selectedTeam);
        }
        return null;
    }

    public void SelectTeam(int teamIndex) {
        try {
            Team team = this.getTeamList().get(teamIndex);
            if (team.getID().equals(this.selectedTeam)) {
                return;
            }
            this.selectedTeam = team.getID();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void PressTransfer(Button button) {
        if (this.playerMode) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferPlayer(this.playerInput.m_94155_(), this.amountWidget.getCoinValue()));
            this.playerInput.m_94144_("");
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        } else if (this.selectedTeam != null) {
            LightmansCurrencyPacketHandler.instance.sendToServer((Object)new MessageBankTransferTeam(this.selectedTeam, this.amountWidget.getCoinValue()));
            this.amountWidget.setCoinValue(CoinValue.EMPTY);
        }
    }

    private void ToggleMode(Button button) {
        this.playerMode = !this.playerMode;
        this.buttonTransfer.m_93666_((Component)new TranslatableComponent(this.playerMode ? "gui.button.bank.transfer.player" : "gui.button.bank.transfer.team"));
        this.teamSelection.f_93624_ = !this.playerMode;
        this.playerInput.f_93624_ = this.playerMode;
        this.buttonToggleMode.setIcon(this.playerMode ? IconData.of((ItemLike)Items.f_42680_) : IconData.of(ItemRenderUtil.getAlexHead()));
    }

    @Override
    public void preRender(PoseStack pose, int mouseX, int mouseY, float partialTicks) {
        this.hideCoinSlots(pose);
        TranslatableComponent balance = ((ATMMenu)this.screen.m_6262_()).getBankAccount() == null ? new TranslatableComponent("gui.lightmanscurrency.bank.null") : new TranslatableComponent("gui.lightmanscurrency.bank.balance", new Object[]{((ATMMenu)this.screen.m_6262_()).getBankAccount().getCoinStorage().getString("0")});
        this.screen.getFont().m_92889_(pose, (Component)balance, (float)this.screen.getGuiLeft() + 8.0f, (float)(this.screen.getGuiTop() + 72), 0x404040);
        if (this.hasMessage()) {
            TextRenderUtil.drawCenteredMultilineText(pose, (Component)this.getMessage(), this.screen.getGuiLeft() + 2, this.screen.getXSize() - 4, this.screen.getGuiTop() + 5, 0x404040);
            this.amountWidget.f_93624_ = false;
        } else {
            this.amountWidget.f_93624_ = true;
        }
    }

    @Override
    public void postRender(PoseStack pose, int mouseX, int mouseY) {
        IconAndButtonUtil.renderButtonTooltips(pose, mouseX, mouseY, Lists.newArrayList((Object[])new Widget[]{this.buttonToggleMode}));
    }

    @Override
    public void tick() {
        this.amountWidget.tick();
        if (this.playerMode) {
            this.playerInput.m_94120_();
            this.buttonTransfer.f_93623_ = !this.playerInput.m_94155_().isBlank() && this.amountWidget.getCoinValue().isValid();
        } else {
            Team team = this.selectedTeam();
            boolean bl = this.buttonTransfer.f_93623_ = team != null && team.hasBankAccount() && this.amountWidget.getCoinValue().isValid();
        }
        if (this.hasMessage()) {
            ++this.responseTimer;
            if (this.responseTimer >= 100) {
                this.responseTimer = 0;
                ((ATMMenu)this.screen.m_6262_()).clearMessage();
            }
        }
    }

    private boolean hasMessage() {
        return ((ATMMenu)this.screen.m_6262_()).hasTransferMessage();
    }

    private MutableComponent getMessage() {
        return ((ATMMenu)this.screen.m_6262_()).getTransferMessage();
    }

    @Override
    public void onClose() {
        SimpleSlot.SetActive(this.screen.m_6262_());
        this.responseTimer = 0;
        ((ATMMenu)this.screen.m_6262_()).clearMessage();
    }

    @Override
    public boolean blockInventoryClosing() {
        return this.playerMode;
    }
}

